/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.completion.CamelOptionValuesCompletionsFuture;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamURIInstance;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentItem;

public class OptionParamValueURIInstance
extends CamelUriElementInstance {
    private String valueName;
    private OptionParamURIInstance optionParamURIInstance;

    public OptionParamValueURIInstance(OptionParamURIInstance optionParamURIInstance, String value, int startPosition, int endPosition) {
        super(startPosition, endPosition);
        this.optionParamURIInstance = optionParamURIInstance;
        this.valueName = value;
    }

    public String getValueName() {
        return this.valueName;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(CompletableFuture<CamelCatalog> camelCatalog, int positionInCamelUri, TextDocumentItem docItem, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        if (this.getStartPositionInUri() <= positionInCamelUri && positionInCamelUri <= this.getEndPositionInUri()) {
            return camelCatalog.thenApply((Function)new CamelOptionValuesCompletionsFuture(this, this.getFilter(positionInCamelUri)));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public OptionParamURIInstance getOptionParamURIInstance() {
        return this.optionParamURIInstance;
    }

    private String getFilter(int positionInUri) {
        int len = positionInUri - this.getStartPositionInUri() - 1;
        if (this.valueName != null && this.valueName.trim().length() > 0 && this.getStartPositionInUri() != positionInUri) {
            return this.valueName.length() > len ? this.valueName.substring(0, Math.max(1, len)) : this.valueName;
        }
        return null;
    }

    @Override
    public String getComponentName() {
        return this.optionParamURIInstance.getComponentName();
    }

    @Override
    public String getDescription(ComponentModel componentModel, KameletsCatalogManager kameletCatalogManager) {
        return this.optionParamURIInstance.getDescription(componentModel, kameletCatalogManager);
    }

    @Override
    public CamelURIInstance getCamelUriInstance() {
        return this.optionParamURIInstance.getCamelUriInstance();
    }
}

