/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel;

import com.github.cameltooling.lsp.internal.catalog.model.ApiOptionMethodsModel;
import com.github.cameltooling.lsp.internal.catalog.model.ApiOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CamelComponentSchemesCompletionsFuture;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.completion.KameletTemplateIdCompletionProvider;
import com.github.cameltooling.lsp.internal.instancemodel.CamelComponentAndPathUriInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.instancemodel.KnativeCompletionProvider;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.v1.kameletspec.Definition;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathParamURIInstance
extends CamelUriElementInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathParamURIInstance.class);
    private CamelComponentAndPathUriInstance camelComponentAndPathUriInstance;
    private String value;
    private int pathParamIndex;

    public PathParamURIInstance(CamelComponentAndPathUriInstance uriInstance, String value, int startPosition, int endPosition, int pathParamIndex) {
        super(startPosition, endPosition);
        this.camelComponentAndPathUriInstance = uriInstance;
        this.value = value;
        this.pathParamIndex = pathParamIndex;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(CompletableFuture<CamelCatalog> camelCatalog, int positionInCamelUri, TextDocumentItem docItem, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        if (this.pathParamIndex == 0) {
            String componentName = this.getCamelComponentAndPathUriInstance().getComponentName();
            if ("kamelet".equals(componentName)) {
                return new KameletTemplateIdCompletionProvider(kameletsCatalogManager).get(this);
            }
            return this.getCompletionForApiName(camelCatalog, positionInCamelUri, docItem);
        }
        if (this.pathParamIndex == 1) {
            String componentName = this.getCamelComponentAndPathUriInstance().getComponentName();
            if ("knative".equals(componentName)) {
                return new KnativeCompletionProvider().get(this);
            }
            return this.getCompletionForApiMethodName(camelCatalog, positionInCamelUri, docItem);
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private CompletableFuture<List<CompletionItem>> getCompletionForApiMethodName(CompletableFuture<CamelCatalog> camelCatalog, int positionInCamelUri, TextDocumentItem docItem) {
        return camelCatalog.thenApply(catalog -> {
            ComponentModel model = ModelHelper.generateComponentModel(catalog.componentJSonSchema(this.getComponentName()), true);
            List<ApiOptionModel> apis = model.getApis();
            if (apis != null && !apis.isEmpty()) {
                Optional<ApiOptionModel> optionModel = apis.stream().filter(apiOption -> {
                    PathParamURIInstance apiNamePath = this.getCamelComponentAndPathUriInstance().getApiNamePath();
                    return apiNamePath != null && apiOption.getName().equals(apiNamePath.getValue());
                }).findAny();
                if (optionModel.isPresent()) {
                    List<CompletionItem> completionItems = this.getCompletionForApiMethodName(optionModel.get());
                    String start = this.value.substring(0, positionInCamelUri - this.getStartPositionInUri());
                    return completionItems.stream().filter(FilterPredicateUtils.matchesCompletionFilter(start)).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }
            return new CamelComponentSchemesCompletionsFuture(this.getCamelComponentAndPathUriInstance(), this.getCamelComponentAndPathUriInstance().getFilter(positionInCamelUri), docItem).apply((CamelCatalog)catalog);
        });
    }

    private List<CompletionItem> getCompletionForApiMethodName(ApiOptionModel apiOptionModel) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        ApiOptionMethodsModel apiOptionsMethodsModel = apiOptionModel.getApiOptionsMethodsModel();
        Map<String, String> aliasesAsMap = apiOptionModel.getKindToAlias();
        if (apiOptionsMethodsModel.getCreator() != null) {
            completionItems.add(this.createCompletionItem(aliasesAsMap.get("^creator$")));
        }
        if (apiOptionsMethodsModel.getDeleter() != null) {
            completionItems.add(this.createCompletionItem(aliasesAsMap.get("^deleter$")));
        }
        if (apiOptionsMethodsModel.getFetcher() != null) {
            completionItems.add(this.createCompletionItem(aliasesAsMap.get("^fetcher$")));
        }
        if (apiOptionsMethodsModel.getReader() != null) {
            completionItems.add(this.createCompletionItem(aliasesAsMap.get("^reader$")));
        }
        if (apiOptionsMethodsModel.getUpdater() != null) {
            completionItems.add(this.createCompletionItem(aliasesAsMap.get("^updater$")));
        }
        return completionItems;
    }

    private CompletionItem createCompletionItem(String name) {
        CompletionItem completionItem = new CompletionItem(name);
        completionItem.setInsertText(name);
        CompletionResolverUtils.applyTextEditToCompletionItem(this, completionItem);
        return completionItem;
    }

    private CompletableFuture<List<CompletionItem>> getCompletionForApiName(CompletableFuture<CamelCatalog> camelCatalog, int positionInCamelUri, TextDocumentItem docItem) {
        return camelCatalog.thenApply(catalog -> {
            ComponentModel model = ModelHelper.generateComponentModel(catalog.componentJSonSchema(this.getComponentName()), true);
            String start = this.value.substring(0, positionInCamelUri - this.getStartPositionInUri());
            List<ApiOptionModel> apis = model.getApis();
            if (apis != null && !apis.isEmpty()) {
                return apis.stream().map(apiOption -> {
                    String optionName = apiOption.getName();
                    CompletionItem completionItem = new CompletionItem(optionName);
                    completionItem.setInsertText(optionName);
                    CompletionResolverUtils.applyTextEditToCompletionItem(this, completionItem);
                    return completionItem;
                }).filter(FilterPredicateUtils.matchesCompletionFilter(start)).collect(Collectors.toList());
            }
            return new CamelComponentSchemesCompletionsFuture(this.getCamelComponentAndPathUriInstance(), this.getCamelComponentAndPathUriInstance().getFilter(positionInCamelUri), docItem).apply((CamelCatalog)catalog);
        });
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathParamURIInstance) {
            return this.value.equals(((PathParamURIInstance)obj).getValue()) && this.getStartPositionInUri() == ((PathParamURIInstance)obj).getStartPositionInUri() && this.getEndPositionInUri() == ((PathParamURIInstance)obj).getEndPositionInUri();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.getStartPositionInUri(), this.getEndPositionInUri());
    }

    public String toString() {
        return "Value: " + this.value + " start position:" + this.getStartPositionInUri() + " end position:" + this.getEndPositionInUri();
    }

    @Override
    public String getComponentName() {
        return this.getCamelComponentAndPathUriInstance().getComponentName();
    }

    @Override
    public String getDescription(ComponentModel componentModel, KameletsCatalogManager kameletCatalogManager) {
        Definition kamelet;
        if (this.pathParamIndex == 0 && "kamelet".equals(this.getComponentName()) && (kamelet = kameletCatalogManager.getCatalog().getKameletDefinition(this.getValue())) != null) {
            return kamelet.getDescription();
        }
        return componentModel.getSyntax();
    }

    @Override
    public CamelURIInstance getCamelUriInstance() {
        return this.getCamelComponentAndPathUriInstance().getCamelUriInstance();
    }

    public String getName(CompletableFuture<CamelCatalog> camelCatalog) {
        try {
            return (String)((CompletableFuture)camelCatalog.thenApply(catalog -> {
                List endpointPathOptions;
                org.apache.camel.tooling.model.ComponentModel componentModel = catalog.componentModel(this.getCamelComponentAndPathUriInstance().getComponentName());
                if (componentModel != null && (endpointPathOptions = componentModel.getEndpointPathOptions()) != null && endpointPathOptions.size() >= this.pathParamIndex) {
                    return ((ComponentModel.EndpointOptionModel)endpointPathOptions.get(this.pathParamIndex)).getName();
                }
                return null;
            })).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException ee) {
            LOGGER.warn("Cannot retrieve Path parameter name", (Throwable)ee);
            return null;
        }
    }

    public int getPathParamIndex() {
        return this.pathParamIndex;
    }

    public CamelComponentAndPathUriInstance getCamelComponentAndPathUriInstance() {
        return this.camelComponentAndPathUriInstance;
    }
}

