/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel.propertiesfile;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.model.ComponentOptionModel;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.catalog.util.StringUtils;
import com.github.cameltooling.lsp.internal.completion.CamelComponentOptionNamesCompletionFuture;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelComponentPropertyKey;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyValueInstance;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;

public class CamelComponentParameterPropertyInstance
implements ILineRangeDefineable {
    private String componentParameter;
    private CamelComponentPropertyKey camelComponentPropertykey;
    private int startCharacterInLine;

    public CamelComponentParameterPropertyInstance(String componentParameter, int startCharacterInLine, CamelComponentPropertyKey camelComponentPropertyKey) {
        this.componentParameter = componentParameter;
        this.startCharacterInLine = startCharacterInLine;
        this.camelComponentPropertykey = camelComponentPropertyKey;
    }

    @Override
    public int getLine() {
        return this.camelComponentPropertykey.getLine();
    }

    @Override
    public int getStartPositionInLine() {
        return this.startCharacterInLine;
    }

    @Override
    public int getEndPositionInLine() {
        return this.startCharacterInLine + this.componentParameter.length();
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        CamelPropertyValueInstance camelPropertyFileValueInstance = this.camelComponentPropertykey.getCamelPropertyKeyInstance().getCamelPropertyEntryInstance().getCamelPropertyValueInstance();
        String startComponentProperty = this.componentParameter.substring(0, position.getCharacter() - this.getStartPositionInLine());
        return camelCatalog.thenApply((Function)new CamelComponentOptionNamesCompletionFuture(this.camelComponentPropertykey.getComponentId(), this, camelPropertyFileValueInstance, startComponentProperty));
    }

    public String getProperty() {
        return this.componentParameter;
    }

    public CompletableFuture<Hover> getHover(CompletableFuture<CamelCatalog> camelCatalog) {
        return camelCatalog.thenApply(catalog -> {
            String description;
            ComponentOptionModel componentOptionModel;
            ComponentModel componentModel;
            String componentJSonSchema = catalog.componentJSonSchema(this.camelComponentPropertykey.getComponentId());
            if (componentJSonSchema != null && (componentModel = ModelHelper.generateComponentModel(componentJSonSchema, true)) != null && (componentOptionModel = this.findComponentOptionModel(componentModel)) != null && (description = componentOptionModel.getDescription()) != null) {
                return this.createHover(description);
            }
            return null;
        });
    }

    private ComponentOptionModel findComponentOptionModel(ComponentModel componentModel) {
        String propertyWrittenName = this.getProperty();
        ComponentOptionModel componentOptionModel = componentModel.getComponentOption(propertyWrittenName);
        if (componentOptionModel == null && propertyWrittenName.contains("-")) {
            componentOptionModel = componentModel.getComponentOption(StringUtils.dashToCamelCase(propertyWrittenName));
        }
        return componentOptionModel;
    }

    public boolean shouldUseDashedCase() {
        return this.camelComponentPropertykey.shouldUseDashedCase();
    }
}

