/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel.propertiesfile;

import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyKeyInstance;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyValueInstance;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.DashedCaseDetector;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;

public class CamelPropertyEntryInstance
implements ILineRangeDefineable {
    private CamelPropertyKeyInstance camelPropertyKeyInstance;
    private CamelPropertyValueInstance camelPropertyValueInstance;
    private String line;
    private Position startPosition;
    private TextDocumentItem textDocumentItem;

    public CamelPropertyEntryInstance(String line, Position startPosition, TextDocumentItem textDocumentItem) {
        String camelPropertyFileValueInstanceString;
        String camelPropertyFileKeyInstanceString;
        this.line = line;
        this.startPosition = startPosition;
        this.textDocumentItem = textDocumentItem;
        int indexOf = line.indexOf(61);
        if (indexOf != -1) {
            camelPropertyFileKeyInstanceString = line.substring(0, indexOf);
            camelPropertyFileValueInstanceString = line.substring(indexOf + 1);
        } else {
            camelPropertyFileKeyInstanceString = line;
            camelPropertyFileValueInstanceString = null;
        }
        this.camelPropertyKeyInstance = new CamelPropertyKeyInstance(camelPropertyFileKeyInstanceString, this);
        this.camelPropertyValueInstance = new CamelPropertyValueInstance(camelPropertyFileValueInstanceString, this.camelPropertyKeyInstance, textDocumentItem);
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, CompletableFuture<CamelCatalog> camelCatalog, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        if (this.isOnPropertyKey(position)) {
            return this.camelPropertyKeyInstance.getCompletions(position, camelCatalog);
        }
        return this.camelPropertyValueInstance.getCompletions(position, camelCatalog, kameletsCatalogManager);
    }

    private boolean isOnPropertyKey(Position position) {
        return position.getCharacter() <= this.camelPropertyKeyInstance.getEndposition();
    }

    CamelPropertyKeyInstance getCamelPropertyKeyInstance() {
        return this.camelPropertyKeyInstance;
    }

    CamelPropertyValueInstance getCamelPropertyValueInstance() {
        return this.camelPropertyValueInstance;
    }

    @Override
    public int getLine() {
        return this.startPosition.getLine();
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition.getCharacter();
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + this.line.length();
    }

    public CompletableFuture<Hover> getHover(Position position, CompletableFuture<CamelCatalog> camelCatalog, KameletsCatalogManager kameletCatalogManager) {
        if (this.isOnPropertyKey(position)) {
            return this.camelPropertyKeyInstance.getHover(position, camelCatalog);
        }
        return this.camelPropertyValueInstance.getHover(position, camelCatalog, kameletCatalogManager);
    }

    public boolean shouldUseDashedCase() {
        return this.textDocumentItem != null && new DashedCaseDetector().hasDashedCaseInCamelPropertyOption(this.textDocumentItem.getText());
    }

    public Collection<Diagnostic> validate(Set<CamelPropertyEntryInstance> allCamelPropertyEntriesOfTheFile) {
        if (this.camelPropertyKeyInstance != null) {
            return this.camelPropertyKeyInstance.validate(allCamelPropertyEntriesOfTheFile);
        }
        return Collections.emptyList();
    }
}

