/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.parser;

import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.parser.NoopErrorHandler;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.parser.helper.CamelXmlHelper;
import org.apache.camel.parser.helper.XmlLineNumberParser;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParserXMLFileHelper
extends ParserFileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserXMLFileHelper.class);
    protected static final List<String> CAMEL_POSSIBLE_TYPES = Arrays.asList("to", "from", "endpoint");
    protected static final List<Character> POSSIBLE_URI_CLOSURE_CHARS = Arrays.asList(Character.valueOf('\"'), Character.valueOf('\''));
    private static final String ATTRIBUTE_ROUTE = "route";
    private static final String ATTRIBUTE_CAMEL_CONTEXT = "camelContext";
    private static final String NAMESPACEURI_CAMEL_BLUEPRINT = "http://camel.apache.org/schema/blueprint";
    private static final String NAMESPACEURI_CAMEL_SPRING = "http://camel.apache.org/schema/spring";
    private static final String NAMESPACEURI_CAMEL_XMLIO = "http://camel.apache.org/schema/xml-io";
    private static final List<String> CAMEL_NAMESPACE_URIS = Arrays.asList("http://camel.apache.org/schema/blueprint", "http://camel.apache.org/schema/spring", "http://camel.apache.org/schema/xml-io");
    private static final List<String> DOCUMENT_SYMBOL_POSSIBLE_TYPES = Arrays.asList("camelContext", "route");
    private static final String URI_PARAM = "uri=";
    private String prefixCamelNamespace = null;

    @Override
    public String getCamelComponentUri(String line, int characterPosition) {
        int uriAttribute = line.indexOf(URI_PARAM);
        if (uriAttribute != -1) {
            int firstQuote = uriAttribute + URI_PARAM.length();
            Character closure = Character.valueOf(line.charAt(firstQuote));
            if (POSSIBLE_URI_CLOSURE_CHARS.contains(closure)) {
                int nextQuote = line.indexOf(closure.charValue(), firstQuote + 1);
                if (this.isBetween(characterPosition, firstQuote, nextQuote)) {
                    return line.substring(firstQuote + 1, nextQuote);
                }
            } else {
                LOGGER.warn("Encountered an unsupported URI closure char {}", (Object)closure);
            }
        }
        return null;
    }

    public Node getCorrespondingCamelNodeForCompletion(TextDocumentItem textDocumentItem, int line) {
        try {
            if (this.hasElementFromCamelNamespace(textDocumentItem)) {
                Document parseXml = this.getDocumentWithLineInformation(textDocumentItem);
                Element documentElement = parseXml.getDocumentElement();
                return this.findElementAtLine(line, documentElement);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Exception while trying to parse the file", (Throwable)e);
            return null;
        }
    }

    public boolean hasElementFromCamelNamespace(TextDocumentItem textDocumentItem) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        dbf.setNamespaceAware(true);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        documentBuilder.setErrorHandler(new NoopErrorHandler());
        Document xmlParsed = documentBuilder.parse(new ByteArrayInputStream(textDocumentItem.getText().getBytes(StandardCharsets.UTF_8)));
        HashSet<String> interestingCamelNodeType = new HashSet<String>(CAMEL_POSSIBLE_TYPES);
        interestingCamelNodeType.addAll(DOCUMENT_SYMBOL_POSSIBLE_TYPES);
        for (String camelNodeTag : interestingCamelNodeType) {
            for (String camelNamespace : CAMEL_NAMESPACE_URIS) {
                if (!this.hasElementFromCamelNameSpaces(xmlParsed.getElementsByTagNameNS(camelNamespace, camelNodeTag))) continue;
                return true;
            }
        }
        return false;
    }

    private Node findElementAtLine(int line, Node node) {
        if (CAMEL_POSSIBLE_TYPES.contains(this.prefixCamelNamespace != null ? node.getNodeName().substring(this.prefixCamelNamespace.length() + 1) : node.getNodeName())) {
            return node;
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            String nodeLineStart = (String)childNode.getUserData("lineNumber");
            String nodeLineEnd = (String)childNode.getUserData("lineNumberEnd");
            if (nodeLineStart == null || nodeLineEnd == null || !this.isBetween(line, Integer.parseInt(nodeLineStart) - 1, Integer.parseInt(nodeLineEnd) - 1)) continue;
            return this.findElementAtLine(line, childNode);
        }
        return null;
    }

    private boolean hasElementFromCamelNameSpaces(NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!NAMESPACEURI_CAMEL_BLUEPRINT.equals(child.getNamespaceURI()) && !NAMESPACEURI_CAMEL_SPRING.equals(child.getNamespaceURI()) && !NAMESPACEURI_CAMEL_XMLIO.equals(child.getNamespaceURI())) continue;
            this.prefixCamelNamespace = child.getPrefix();
            return true;
        }
        return false;
    }

    public NodeList getRouteNodes(TextDocumentItem textDocumentItem) throws Exception {
        return this.getNodesOfType(textDocumentItem, ATTRIBUTE_ROUTE);
    }

    public NodeList getCamelContextNodes(TextDocumentItem textDocumentItem) throws Exception {
        return this.getNodesOfType(textDocumentItem, ATTRIBUTE_CAMEL_CONTEXT);
    }

    private NodeList getNodesOfType(TextDocumentItem textDocumentItem, String attributeTypeToFilter) throws Exception {
        if (this.hasElementFromCamelNamespace(textDocumentItem)) {
            Document parsedXml = XmlLineNumberParser.parseXml((InputStream)new ByteArrayInputStream(textDocumentItem.getText().getBytes(StandardCharsets.UTF_8)));
            if (this.prefixCamelNamespace != null) {
                return parsedXml.getElementsByTagName(this.prefixCamelNamespace + ":" + attributeTypeToFilter);
            }
            return parsedXml.getElementsByTagName(attributeTypeToFilter);
        }
        return null;
    }

    private Document getDocumentWithLineInformation(TextDocumentItem textDocumentItem) throws Exception {
        return XmlLineNumberParser.parseXml((InputStream)new ByteArrayInputStream(textDocumentItem.getText().getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public CamelURIInstance createCamelURIInstance(TextDocumentItem textDocumentItem, Position position, String camelComponentUri) {
        Node correspondingCamelNode = this.getCorrespondingCamelNodeForCompletion(textDocumentItem, position.getLine());
        CamelURIInstance uriInstance = new CamelURIInstance(camelComponentUri, correspondingCamelNode, textDocumentItem);
        int start = this.getStartCharacterInDocumentOnLinePosition(textDocumentItem, position);
        uriInstance.setStartPositionInDocument(new Position(position.getLine(), start));
        uriInstance.setEndPositionInDocument(new Position(position.getLine(), start + camelComponentUri.length()));
        return uriInstance;
    }

    private int getStartCharacterInDocumentOnLinePosition(TextDocumentItem textDocumentItem, Position position) {
        return this.parserFileHelperUtil.getLine(textDocumentItem, position.getLine()).indexOf(URI_PARAM) + 1 + URI_PARAM.length();
    }

    @Override
    public int getPositionInCamelURI(TextDocumentItem textDocumentItem, Position position) {
        return position.getCharacter() - this.parserFileHelperUtil.getLine(textDocumentItem, position).indexOf(URI_PARAM) - 5;
    }

    public List<Node> getAllEndpoints(TextDocumentItem textDocumentItem) throws Exception {
        if (this.hasElementFromCamelNamespace(textDocumentItem)) {
            return CamelXmlHelper.findAllEndpoints((Document)this.getDocumentWithLineInformation(textDocumentItem));
        }
        return Collections.emptyList();
    }

    public Location retrieveLocation(Node node, TextDocumentItem textDocumentItem) {
        Position startPosition = new Position(this.retrieveIntUserData(node, "lineNumber"), this.retrieveIntUserData(node, "colNumber"));
        Position endPosition = new Position(this.retrieveIntUserData(node, "lineNumberEnd"), this.retrieveIntUserData(node, "colNumberEnd"));
        Range range = new Range(startPosition, endPosition);
        return new Location(textDocumentItem.getUri(), range);
    }

    private int retrieveIntUserData(Node node, String userData) {
        return Integer.parseInt((String)node.getUserData(userData)) - 1;
    }
}

