/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.references;

import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.ReferenceUtils;
import com.github.cameltooling.lsp.internal.parser.ParserXMLFileHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.parser.helper.CamelXmlHelper;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ReferencesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferencesProcessor.class);
    private ParserXMLFileHelper parserXMLFileHelper = new ParserXMLFileHelper();
    private TextDocumentItem textDocumentItem;
    private CamelTextDocumentService textDocumentService;

    public ReferencesProcessor(CamelTextDocumentService textDocumentService, TextDocumentItem textDocumentItem) {
        this.textDocumentService = textDocumentService;
        this.textDocumentItem = textDocumentItem;
    }

    public CompletableFuture<List<? extends Location>> getReferences(Position position) {
        if (this.textDocumentItem.getUri().endsWith(".xml")) {
            try {
                String camelComponentUri = this.parserXMLFileHelper.getCamelComponentUri(this.textDocumentItem, position);
                CamelURIInstance camelURIInstanceToSearchReference = this.parserXMLFileHelper.createCamelURIInstance(this.textDocumentItem, position, camelComponentUri);
                if (ReferenceUtils.isReferenceComponentKind(camelURIInstanceToSearchReference)) {
                    Map<CamelURIInstance, Node> allCamelUriInstances = this.retrieveAllEndpoints();
                    return CompletableFuture.completedFuture(this.findReferences(camelURIInstanceToSearchReference, allCamelUriInstances));
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot compute references", (Throwable)e);
            }
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private List<Location> findReferences(CamelURIInstance camelURIInstanceToSearchReference, Map<CamelURIInstance, Node> allCamelUriInstance) {
        ArrayList<Location> references = new ArrayList<Location>();
        String directId = ReferenceUtils.getReferenceKey(camelURIInstanceToSearchReference);
        if (directId != null && !directId.isEmpty()) {
            for (Map.Entry<CamelURIInstance, Node> entry : allCamelUriInstance.entrySet()) {
                CamelURIInstance camelURIInstance = entry.getKey();
                if (!this.isReference(camelURIInstanceToSearchReference, directId, camelURIInstance)) continue;
                references.add(this.parserXMLFileHelper.retrieveLocation(entry.getValue(), camelURIInstance.getDocument()));
            }
        }
        return references;
    }

    private boolean isReference(CamelURIInstance camelURIInstanceToSearchReference, String directId, CamelURIInstance camelURIInstance) {
        return ReferenceUtils.isReferenceComponentKind(camelURIInstance) && (camelURIInstanceToSearchReference.isProducer() && !camelURIInstance.isProducer() || !camelURIInstanceToSearchReference.isProducer() && camelURIInstance.isProducer()) && directId.equals(ReferenceUtils.getReferenceKey(camelURIInstance));
    }

    private Map<CamelURIInstance, Node> retrieveAllEndpoints() throws Exception {
        HashMap<CamelURIInstance, Node> allCamelUriInstance = new HashMap<CamelURIInstance, Node>();
        for (TextDocumentItem docItem : this.textDocumentService.getAllOpenedDocuments()) {
            for (Node endpoint : this.parserXMLFileHelper.getAllEndpoints(docItem)) {
                String uriToParse = CamelXmlHelper.getSafeAttribute((Node)endpoint, (String)"uri");
                if (uriToParse == null) continue;
                allCamelUriInstance.put(new CamelURIInstance(uriToParse, endpoint, docItem), endpoint);
            }
        }
        return allCamelUriInstance;
    }
}

