/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.telemetry;

import com.github.cameltooling.lsp.internal.telemetry.JVM;
import com.github.cameltooling.lsp.internal.telemetry.Memory;
import com.github.cameltooling.lsp.internal.telemetry.Platform;
import java.util.HashMap;
import java.util.Map;

public class InitializationTelemetryInfo {
    public static final String JVM_MEMORY_MAX = "jvm.memory.max";
    public static final String JVM_MEMORY_TOTAL = "jvm.memory.total";
    public static final String JVM_MEMORY_FREE = "jvm.memory.free";
    public static final String JVM_IS_NATIVE_IMAGE = "server.is.native";
    public static final String JVM_RUNTIME = "jvm.runtime";
    public static final String JVM_VERSION = "jvm.version";
    public static final String JVM_NAME = "jvm.name";
    public static final String SERVER_VERSION_NUMBER = "server.version";

    private InitializationTelemetryInfo() {
    }

    public static Map<String, Object> getInitializationTelemetryInfo() {
        HashMap<String, Object> initTelemetry = new HashMap<String, Object>();
        JVM jvm = Platform.getJVM();
        initTelemetry.put(JVM_NAME, jvm.getName());
        initTelemetry.put(JVM_VERSION, jvm.getVersion());
        initTelemetry.put(JVM_RUNTIME, jvm.getRuntime());
        initTelemetry.put(JVM_IS_NATIVE_IMAGE, jvm.isNativeImage());
        Memory memory = jvm.getMemory();
        initTelemetry.put(JVM_MEMORY_FREE, memory.getFree());
        initTelemetry.put(JVM_MEMORY_TOTAL, memory.getTotal());
        initTelemetry.put(JVM_MEMORY_MAX, memory.getMax());
        return initTelemetry;
    }
}

