/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.websocket;

import com.github.cameltooling.lsp.internal.websocket.CamelLSPWebSocketServerConfigProvider;
import jakarta.websocket.DeploymentException;
import org.glassfish.tyrus.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketRunner.class);
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 8025;
    private static final String DEFAULT_CONTEXT_PATH = "/";
    private boolean isStarted = false;
    private boolean isStopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWebSocketServer(String hostname, int port, String contextPath) {
        hostname = hostname != null ? hostname : DEFAULT_HOSTNAME;
        port = port != -1 ? port : 8025;
        contextPath = contextPath != null ? contextPath : DEFAULT_CONTEXT_PATH;
        Server server = new Server(hostname, port, contextPath, null, new Class[]{CamelLSPWebSocketServerConfigProvider.class});
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            server.stop();
            this.isStopped = true;
        }, "camel-lsp-websocket-server-shutdown-hook"));
        try {
            server.start();
            this.isStarted = true;
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            LOGGER.error("Camel LSP Websocket server has been interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (DeploymentException e) {
            LOGGER.error("Cannot start Camel LSP Websocket server.", (Throwable)e);
        }
        finally {
            server.stop();
            this.isStopped = true;
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isStopped() {
        return this.isStopped;
    }
}

