/*
 * Decompiled with CFR 0.152.
 */
package tscfg;

import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import tscfg.Main;
import tscfg.Main$CmdLineOpts$;
import tscfg.ModelBuildResult;
import tscfg.ModelBuilder$;
import tscfg.generators.GenOpts;
import tscfg.generators.GenOpts$;
import tscfg.generators.GenResult;
import tscfg.generators.Generator;
import tscfg.generators.TemplateGenerator;
import tscfg.generators.TemplateOpts;
import tscfg.generators.TemplateOpts$;
import tscfg.generators.java.JavaGen;
import tscfg.generators.scala.ScalaGen;
import tscfg.model;

public final class Main$ {
    public static Main$ MODULE$;
    private final String version;
    private final GenOpts defaultGenOpts;
    private final String defaultDestDir;
    private TemplateOpts templateOpts;
    private final String usage;

    static {
        new Main$();
    }

    public String version() {
        return this.version;
    }

    public GenOpts defaultGenOpts() {
        return this.defaultGenOpts;
    }

    public String defaultDestDir() {
        return this.defaultDestDir;
    }

    public TemplateOpts templateOpts() {
        return this.templateOpts;
    }

    public void templateOpts_$eq(TemplateOpts x$1) {
        this.templateOpts = x$1;
    }

    public String usage() {
        return this.usage;
    }

    public void main(String[] args) {
        this.generate(this.getOpts((List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList()));
    }

    /*
     * WARNING - void declaration
     */
    private Main.CmdLineOpts getOpts(List<String> args) {
        void var2_2;
        if (args.isEmpty()) {
            Predef$.MODULE$.println((Object)this.usage());
            throw package$.MODULE$.exit(0);
        }
        Main.CmdLineOpts opts = this.traverseList$1(args, Main$.traverseList$default$2$1());
        opts.inputFilename().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.println((Object)"--spec not given");
            return package$.MODULE$.exit(1);
        });
        return var2_2;
    }

    private void generate(Main.CmdLineOpts opts) {
        Generator generator;
        PrintWriter printWriter;
        Predef$.MODULE$.require(opts.inputFilename().isDefined());
        String ext = opts.language();
        String inputFilename = (String)opts.inputFilename().get();
        String destFilename = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.destDir(), opts.className(), ext}));
        File destFile = new File(destFilename);
        PrintWriter out = new PrintWriter(destFile);
        GenOpts genOpts = new GenOpts(opts.packageName(), opts.className(), opts.j7(), opts.useBackticks());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parsing: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputFilename})));
        String source = Source$.MODULE$.fromFile(new File(inputFilename), Codec$.MODULE$.fallbackSystemCodec()).mkString().trim();
        ModelBuildResult buildResult = ModelBuilder$.MODULE$.apply(source);
        model.ObjectType objectType = buildResult.objectType();
        if (buildResult.warnings().nonEmpty()) {
            Predef$.MODULE$.println((Object)"WARNINGS:");
            buildResult.warnings().foreach((Function1 & Serializable & scala.Serializable)w -> {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"   line ", ": ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)w.line()), w.source(), w.message()})));
                return BoxedUnit.UNIT;
            });
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generating: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destFile})));
        PrintWriter printWriter2 = out;
        PrintWriter printWriter3 = printWriter2 != null ? (printWriter = printWriter2) : new PrintWriter(printWriter2);
        PrintWriter pw = printWriter3;
        String string = opts.language();
        if ("java".equals(string)) {
            generator = new JavaGen(genOpts);
        } else if ("scala".equals(string)) {
            generator = new ScalaGen(genOpts);
        } else {
            throw new MatchError((Object)string);
        }
        JavaGen generator2 = generator;
        GenResult results = ((Generator)generator2).generate(objectType);
        pw.println(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"// generated by tscfg ", " on ", "\n         |// source: ", "\n         |\n         |", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.version(), new Date(), inputFilename, results.code()})))).stripMargin());
        out.close();
        opts.tplFilename().foreach((Function1 & Serializable & scala.Serializable)filename -> {
            Main$.$anonfun$generate$2(this, objectType, filename);
            return BoxedUnit.UNIT;
        });
    }

    private static final String chkVal$1(String v) {
        if (v.startsWith("-")) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"error: argument looks like a switch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
            throw package$.MODULE$.exit(0);
        }
        return v;
    }

    private final Main.CmdLineOpts traverseList$1(List list, Main.CmdLineOpts opts) {
        List list2;
        .colon.colon colon2;
        boolean bl;
        while (true) {
            bl = false;
            colon2 = null;
            list2 = list;
            if (list2 instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list2;
                String string = (String)colon2.head();
                List list3 = colon2.tl$access$1();
                if ("--spec".equals(string) && list3 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list3;
                    String filename = (String)colon3.head();
                    List rest = colon3.tl$access$1();
                    opts = opts.copy((Option<String>)new Some((Object)Main$.chkVal$1(filename)), opts.copy$default$2(), opts.copy$default$3(), opts.copy$default$4(), opts.copy$default$5(), opts.copy$default$6(), opts.copy$default$7(), opts.copy$default$8());
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list4 = colon2.tl$access$1();
                if ("--pn".equals(string) && list4 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list4;
                    String packageName = (String)colon4.head();
                    List rest = colon4.tl$access$1();
                    String x$1 = Main$.chkVal$1(packageName);
                    Option<String> x$2 = opts.copy$default$1();
                    String x$3 = opts.copy$default$3();
                    String x$4 = opts.copy$default$4();
                    boolean x$5 = opts.copy$default$5();
                    String x$6 = opts.copy$default$6();
                    boolean x$7 = opts.copy$default$7();
                    Option<String> x$8 = opts.copy$default$8();
                    opts = opts.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list5 = colon2.tl$access$1();
                if ("--cn".equals(string) && list5 instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list5;
                    String className = (String)colon5.head();
                    List rest = colon5.tl$access$1();
                    String x$9 = Main$.chkVal$1(className);
                    Option<String> x$10 = opts.copy$default$1();
                    String x$11 = opts.copy$default$2();
                    String x$12 = opts.copy$default$4();
                    boolean x$13 = opts.copy$default$5();
                    String x$14 = opts.copy$default$6();
                    boolean x$15 = opts.copy$default$7();
                    Option<String> x$16 = opts.copy$default$8();
                    opts = opts.copy(x$10, x$11, x$9, x$12, x$13, x$14, x$15, x$16);
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list6 = colon2.tl$access$1();
                if ("--dd".equals(string) && list6 instanceof .colon.colon) {
                    .colon.colon colon6 = (.colon.colon)list6;
                    String destDir = (String)colon6.head();
                    List rest = colon6.tl$access$1();
                    String x$17 = Main$.chkVal$1(destDir);
                    Option<String> x$18 = opts.copy$default$1();
                    String x$19 = opts.copy$default$2();
                    String x$20 = opts.copy$default$3();
                    boolean x$21 = opts.copy$default$5();
                    String x$22 = opts.copy$default$6();
                    boolean x$23 = opts.copy$default$7();
                    Option<String> x$24 = opts.copy$default$8();
                    opts = opts.copy(x$18, x$19, x$20, x$17, x$21, x$22, x$23, x$24);
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List rest = colon2.tl$access$1();
                if ("--j7".equals(string)) {
                    boolean x$25 = true;
                    Option<String> x$26 = opts.copy$default$1();
                    String x$27 = opts.copy$default$2();
                    String x$28 = opts.copy$default$3();
                    String x$29 = opts.copy$default$4();
                    String x$30 = opts.copy$default$6();
                    boolean x$31 = opts.copy$default$7();
                    Option<String> x$32 = opts.copy$default$8();
                    opts = opts.copy(x$26, x$27, x$28, x$29, x$25, x$30, x$31, x$32);
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List rest = colon2.tl$access$1();
                if ("--scala".equals(string)) {
                    String x$33 = "scala";
                    Option<String> x$34 = opts.copy$default$1();
                    String x$35 = opts.copy$default$2();
                    String x$36 = opts.copy$default$3();
                    String x$37 = opts.copy$default$4();
                    boolean x$38 = opts.copy$default$5();
                    boolean x$39 = opts.copy$default$7();
                    Option<String> x$40 = opts.copy$default$8();
                    opts = opts.copy(x$34, x$35, x$36, x$37, x$38, x$33, x$39, x$40);
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List rest = colon2.tl$access$1();
                if ("--scala:bt".equals(string)) {
                    boolean x$41 = true;
                    Option<String> x$42 = opts.copy$default$1();
                    String x$43 = opts.copy$default$2();
                    String x$44 = opts.copy$default$3();
                    String x$45 = opts.copy$default$4();
                    boolean x$46 = opts.copy$default$5();
                    String x$47 = opts.copy$default$6();
                    Option<String> x$48 = opts.copy$default$8();
                    opts = opts.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$41, x$48);
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List rest = colon2.tl$access$1();
                if ("--java".equals(string)) {
                    String x$49 = "java";
                    Option<String> x$50 = opts.copy$default$1();
                    String x$51 = opts.copy$default$2();
                    String x$52 = opts.copy$default$3();
                    String x$53 = opts.copy$default$4();
                    boolean x$54 = opts.copy$default$5();
                    boolean x$55 = opts.copy$default$7();
                    Option<String> x$56 = opts.copy$default$8();
                    opts = opts.copy(x$50, x$51, x$52, x$53, x$54, x$49, x$55, x$56);
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list7 = colon2.tl$access$1();
                if ("--tpl".equals(string) && list7 instanceof .colon.colon) {
                    .colon.colon colon7 = (.colon.colon)list7;
                    String filename = (String)colon7.head();
                    List rest = colon7.tl$access$1();
                    Some x$57 = new Some((Object)filename);
                    Option<String> x$58 = opts.copy$default$1();
                    String x$59 = opts.copy$default$2();
                    String x$60 = opts.copy$default$3();
                    String x$61 = opts.copy$default$4();
                    boolean x$62 = opts.copy$default$5();
                    String x$63 = opts.copy$default$6();
                    boolean x$64 = opts.copy$default$7();
                    opts = opts.copy(x$58, x$59, x$60, x$61, x$62, x$63, x$64, (Option<String>)x$57);
                    list = rest;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list8 = colon2.tl$access$1();
                if ("--tpl.ind".equals(string) && list8 instanceof .colon.colon) {
                    .colon.colon colon8 = (.colon.colon)list8;
                    String indent = (String)colon8.head();
                    List rest = colon8.tl$access$1();
                    TemplateOpts qual$1 = this.templateOpts();
                    String x$65 = indent;
                    String x$66 = qual$1.copy$default$2();
                    this.templateOpts_$eq(qual$1.copy(x$65, x$66));
                    list = rest;
                    continue;
                }
            }
            if (!bl) break;
            String string = (String)colon2.head();
            List list9 = colon2.tl$access$1();
            if (!"--tpl.cp".equals(string) || !(list9 instanceof .colon.colon)) break;
            .colon.colon colon9 = (.colon.colon)list9;
            String prefixComment = (String)colon9.head();
            List rest = colon9.tl$access$1();
            TemplateOpts qual$2 = this.templateOpts();
            String x$67 = prefixComment;
            String x$68 = qual$2.copy$default$1();
            this.templateOpts_$eq(qual$2.copy(x$68, x$67));
            list = rest;
        }
        if (bl) {
            String opt = (String)colon2.head();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"missing argument or unknown option: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt})));
            throw package$.MODULE$.exit(0);
        }
        if (!Nil$.MODULE$.equals(list2)) {
            throw new MatchError((Object)list2);
        }
        Main.CmdLineOpts cmdLineOpts = opts;
        return cmdLineOpts;
    }

    private static final Main.CmdLineOpts traverseList$default$2$1() {
        return new Main.CmdLineOpts(Main$CmdLineOpts$.MODULE$.apply$default$1(), Main$CmdLineOpts$.MODULE$.apply$default$2(), Main$CmdLineOpts$.MODULE$.apply$default$3(), Main$CmdLineOpts$.MODULE$.apply$default$4(), Main$CmdLineOpts$.MODULE$.apply$default$5(), Main$CmdLineOpts$.MODULE$.apply$default$6(), Main$CmdLineOpts$.MODULE$.apply$default$7(), Main$CmdLineOpts$.MODULE$.apply$default$8());
    }

    public static final /* synthetic */ void $anonfun$generate$2(Main$ $this, model.ObjectType objectType$1, String filename) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generating template ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})));
        File destFile = new File(filename);
        PrintWriter out = new PrintWriter(destFile);
        TemplateGenerator templater = new TemplateGenerator($this.templateOpts());
        String template = templater.generate(objectType$1);
        out.println(template);
        out.close();
    }

    private Main$() {
        MODULE$ = this;
        this.version = ConfigFactory.load().getString("tscfg.version");
        this.defaultGenOpts = new GenOpts("tscfg.example", "ExampleCfg", false, GenOpts$.MODULE$.apply$default$4());
        this.defaultDestDir = "/tmp";
        this.templateOpts = new TemplateOpts(TemplateOpts$.MODULE$.apply$default$1(), TemplateOpts$.MODULE$.apply$default$2());
        this.usage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |tscfg ", "\n       |Usage:  tscfg.Main --spec inputFile [options]\n       |Options (default):\n       |  --pn <packageName>                                     (", ")\n       |  --cn <className>                                       (", ")\n       |  --dd <destDir>                                         (", ")\n       |  --j7                  generate code for java <= 7      (8)\n       |  --scala               generate scala code              (java)\n       |  --scala:bt            use backticks (see #30)          (false)\n       |  --java                generate java code               (the default)\n       |  --tpl <filename>      generate config template         (no default)\n       |  --tpl.ind <string>    template indentation string      (\"", "\")\n       |  --tpl.cp <string>     prefix for template comments     (\"", "\")\n       |Output is written to $destDir/$className.ext\n       |\n       |More information at https://github.com/carueda/tscfg\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.version(), this.defaultGenOpts().packageName(), this.defaultGenOpts().className(), this.defaultDestDir(), this.templateOpts().indent(), this.templateOpts().commentPrefix()})))).stripMargin();
    }
}

