/*
 * Decompiled with CFR 0.152.
 */
package tscfg.generators;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import tscfg.model;
import tscfg.model$BOOLEAN$;
import tscfg.model$DOUBLE$;
import tscfg.model$INTEGER$;
import tscfg.model$LONG$;
import tscfg.model$SIZE$;
import tscfg.model$STRING$;
import tscfg.model$durations$day$;
import tscfg.model$durations$hour$;
import tscfg.model$durations$minute$;
import tscfg.model$durations$ms$;
import tscfg.model$durations$ns$;
import tscfg.model$durations$second$;
import tscfg.model$durations$us$;
import tscfg.util$;

public final class tsConfigUtil$ {
    public static tsConfigUtil$ MODULE$;

    static {
        new tsConfigUtil$();
    }

    public String basicGetter(model.BasicType bt, String path) {
        String string;
        model.BasicType basicType = bt;
        if (model$STRING$.MODULE$.equals(basicType)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getString(\"", "\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        } else if (model$INTEGER$.MODULE$.equals(basicType)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getInt(\"", "\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        } else if (model$LONG$.MODULE$.equals(basicType)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getLong(\"", "\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        } else if (model$DOUBLE$.MODULE$.equals(basicType)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getDouble(\"", "\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        } else if (model$BOOLEAN$.MODULE$.equals(basicType)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getBoolean(\"", "\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        } else if (model$SIZE$.MODULE$.equals(basicType)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getBytes(\"", "\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        } else if (basicType instanceof model.DURATION) {
            model.DURATION dURATION = (model.DURATION)basicType;
            model.durations.DurationQualification q = dURATION.q();
            string = this.durationGetter(path, q);
        } else {
            throw new MatchError((Object)basicType);
        }
        return string;
    }

    public String basicValue(model.Type t, String value) {
        String string;
        model.Type type = t;
        if (model$SIZE$.MODULE$.equals(type)) {
            string = this.sizeValue(value);
        } else if (type instanceof model.DURATION) {
            model.DURATION dURATION = (model.DURATION)type;
            model.durations.DurationQualification q = dURATION.q();
            string = this.durationValue(value, q);
        } else {
            string = model$STRING$.MODULE$.equals(type) ? '\"' + util$.MODULE$.escapeString(value) + '\"' : value;
        }
        return string;
    }

    public model.durations.DurationQualification unifyDuration(String q) {
        model.durations.DurationQualification durationQualification;
        String string = q;
        boolean bl = "ns".equals(string) ? true : ("nano".equals(string) ? true : ("nanos".equals(string) ? true : ("nanosecond".equals(string) ? true : "nanoseconds".equals(string))));
        if (bl) {
            durationQualification = model$durations$ns$.MODULE$;
        } else {
            boolean bl2 = "us".equals(string) ? true : ("micro".equals(string) ? true : ("micros".equals(string) ? true : ("microsecond".equals(string) ? true : "microseconds".equals(string))));
            if (bl2) {
                durationQualification = model$durations$us$.MODULE$;
            } else {
                boolean bl3 = "ms".equals(string) ? true : ("milli".equals(string) ? true : ("millis".equals(string) ? true : ("millisecond".equals(string) ? true : "milliseconds".equals(string))));
                if (bl3) {
                    durationQualification = model$durations$ms$.MODULE$;
                } else {
                    boolean bl4 = "s".equals(string) ? true : ("second".equals(string) ? true : "seconds".equals(string));
                    if (bl4) {
                        durationQualification = model$durations$second$.MODULE$;
                    } else {
                        boolean bl5 = "m".equals(string) ? true : ("minute".equals(string) ? true : "minutes".equals(string));
                        if (bl5) {
                            durationQualification = model$durations$minute$.MODULE$;
                        } else {
                            boolean bl6 = "h".equals(string) ? true : ("hour".equals(string) ? true : "hours".equals(string));
                            if (bl6) {
                                durationQualification = model$durations$hour$.MODULE$;
                            } else {
                                boolean bl7 = "d".equals(string) ? true : ("day".equals(string) ? true : "days".equals(string));
                                if (bl7) {
                                    durationQualification = model$durations$day$.MODULE$;
                                } else {
                                    throw new AssertionError((Object)("unrecognized q='" + q + "'"));
                                }
                            }
                        }
                    }
                }
            }
        }
        return durationQualification;
    }

    public boolean isDurationValue(String value) {
        boolean bl;
        Config config = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k = \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
        try {
            config.getDuration("k");
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    private String durationValue(String value, model.durations.DurationQualification q) {
        Config config = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k = \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
        return ((Object)BoxesRunTime.boxToLong((long)config.getDuration("k", this.timeUnitParam(q)))).toString();
    }

    private String durationGetter(String path, model.durations.DurationQualification q) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getDuration(\"", "\", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, this.timeUnitParamString(q)}));
    }

    private String timeUnitParamString(model.durations.DurationQualification q) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("java.util.concurrent.TimeUnit.");
        model.durations.DurationQualification durationQualification = q;
        if (model$durations$ns$.MODULE$.equals(durationQualification)) {
            string = "NANOSECONDS";
        } else if (model$durations$us$.MODULE$.equals(durationQualification)) {
            string = "MICROSECONDS";
        } else if (model$durations$ms$.MODULE$.equals(durationQualification)) {
            string = "MILLISECONDS";
        } else if (model$durations$second$.MODULE$.equals(durationQualification)) {
            string = "SECONDS";
        } else if (model$durations$minute$.MODULE$.equals(durationQualification)) {
            string = "MINUTES";
        } else if (model$durations$hour$.MODULE$.equals(durationQualification)) {
            string = "HOURS";
        } else if (model$durations$day$.MODULE$.equals(durationQualification)) {
            string = "DAYS";
        } else {
            throw new MatchError((Object)durationQualification);
        }
        return stringBuilder.append((Object)string).toString();
    }

    private TimeUnit timeUnitParam(model.durations.DurationQualification q) {
        TimeUnit timeUnit;
        model.durations.DurationQualification durationQualification = q;
        if (model$durations$ns$.MODULE$.equals(durationQualification)) {
            timeUnit = TimeUnit.NANOSECONDS;
        } else if (model$durations$us$.MODULE$.equals(durationQualification)) {
            timeUnit = TimeUnit.MICROSECONDS;
        } else if (model$durations$ms$.MODULE$.equals(durationQualification)) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (model$durations$second$.MODULE$.equals(durationQualification)) {
            timeUnit = TimeUnit.SECONDS;
        } else if (model$durations$minute$.MODULE$.equals(durationQualification)) {
            timeUnit = TimeUnit.MINUTES;
        } else if (model$durations$hour$.MODULE$.equals(durationQualification)) {
            timeUnit = TimeUnit.HOURS;
        } else if (model$durations$day$.MODULE$.equals(durationQualification)) {
            timeUnit = TimeUnit.DAYS;
        } else {
            throw new MatchError((Object)durationQualification);
        }
        return timeUnit;
    }

    public boolean isSizeValue(String value) {
        boolean bl;
        Config config = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s = \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
        try {
            config.getBytes("s");
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    private String sizeValue(String value) {
        Config config = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s = \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
        return config.getBytes("s").toString();
    }

    private tsConfigUtil$() {
        MODULE$ = this;
    }
}

