/*
 * Decompiled with CFR 0.152.
 */
package com.github.caryyu.spring.embedded.redisserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import redis.embedded.RedisServer;

@Component
public class RedisServerConfiguration
implements DisposableBean,
EnvironmentAware,
InitializingBean {
    private Log log = LogFactory.getLog(this.getClass());
    private RedisServer redisServer;
    private Environment environment;

    public int getPort() {
        return (Integer)this.environment.getProperty("global.redis.port", Integer.class, (Object)6379);
    }

    private boolean isEmbedded() {
        return (Boolean)this.environment.getProperty("global.redis.embedded", Boolean.class, (Object)false);
    }

    public void destroy() throws Exception {
        if (this.redisServer != null) {
            this.redisServer.stop();
            this.redisServer = null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.isEmbedded()) {
            return;
        }
        try {
            int port = this.getPort();
            this.redisServer = new RedisServer(Integer.valueOf(port));
            this.redisServer.start();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("\u5f00\u542f\u672c\u5730\u5d4c\u5165\u5f0fRedis\u670d\u52a1\u5668\u6210\u529f,\u7aef\u53e3:" + port));
            }
        }
        catch (IOException e) {
            throw new FatalBeanException("\u5f00\u542f\u5d4c\u5165\u7684Redis\u670d\u52a1\u5668\u5931\u8d25.", (Throwable)e);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

