/*
 * Decompiled with CFR 0.152.
 */
package com.github.caryyu.spring.embedded.redisserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import redis.embedded.RedisServer;

@Component
public class RedisServerConfiguration
implements DisposableBean,
EnvironmentAware,
InitializingBean {
    private Log log = LogFactory.getLog(this.getClass());
    private RedisServer redisServer;
    private Environment environment;

    public int getPort() {
        int v = (Integer)this.environment.getProperty("spring.redis.port", Integer.class, (Object)0);
        v = v == 0 ? (Integer)this.environment.getProperty("global.redis.port", Integer.class, (Object)6379) : v;
        return v;
    }

    private boolean isEmbedded() {
        Boolean v = (Boolean)this.environment.getProperty("spring.redis.embedded", Boolean.class, null);
        v = v == null ? (Boolean)this.environment.getProperty("global.redis.embedded", Boolean.class, (Object)false) : v;
        return v;
    }

    public void destroy() throws Exception {
        if (this.redisServer != null) {
            this.redisServer.stop();
            this.redisServer = null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.isEmbedded()) {
            return;
        }
        try {
            int port = this.getPort();
            this.redisServer = new RedisServer(Integer.valueOf(port));
            this.redisServer.start();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Starting local embedded redis server successfully, port is " + port));
            }
        }
        catch (IOException e) {
            throw new FatalBeanException("Failed to start local embedded redis server ", (Throwable)e);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

