/*
 * Decompiled with CFR 0.152.
 */
package fr.castorflex.android.smoothprogressbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import fr.castorflex.android.smoothprogressbar.R;
import fr.castorflex.android.smoothprogressbar.SmoothProgressBarUtils;

public class SmoothProgressDrawable
extends Drawable
implements Animatable {
    private static final long FRAME_DURATION = 16L;
    private static final float OFFSET_PER_FRAME = 0.01f;
    private final Rect fBackgroundRect = new Rect();
    private Callbacks mCallbacks;
    private Interpolator mInterpolator;
    private Rect mBounds;
    private Paint mPaint;
    private int[] mColors;
    private int mColorsIndex;
    private boolean mRunning = false;
    private float mCurrentOffset;
    private float mFinishingOffset;
    private int mSeparatorLength;
    private int mSectionsCount;
    private float mSpeed;
    private float mProgressiveStartSpeed;
    private float mProgressiveStopSpeed;
    private boolean mReversed;
    private boolean mNewTurn;
    private boolean mMirrorMode;
    private float mMaxOffset;
    private boolean mFinishing;
    private boolean mProgressiveStartActivated;
    private int mStartSection;
    private int mCurrentSections;
    private float mStrokeWidth;
    private Drawable mBackgroundDrawable;
    private boolean mUseGradients;
    private int[] mLinearGradientColors;
    private float[] mLinearGradientPositions;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            if (SmoothProgressDrawable.this.isFinishing()) {
                SmoothProgressDrawable.this.mFinishingOffset += 0.01f * SmoothProgressDrawable.this.mProgressiveStopSpeed;
                SmoothProgressDrawable.this.mCurrentOffset += 0.01f * SmoothProgressDrawable.this.mProgressiveStopSpeed;
                if (SmoothProgressDrawable.this.mFinishingOffset >= 1.0f) {
                    SmoothProgressDrawable.this.stop();
                }
            } else if (SmoothProgressDrawable.this.isStarting()) {
                SmoothProgressDrawable.this.mCurrentOffset += 0.01f * SmoothProgressDrawable.this.mProgressiveStartSpeed;
            } else {
                SmoothProgressDrawable.this.mCurrentOffset += 0.01f * SmoothProgressDrawable.this.mSpeed;
            }
            if (SmoothProgressDrawable.this.mCurrentOffset >= SmoothProgressDrawable.this.mMaxOffset) {
                SmoothProgressDrawable.this.mNewTurn = true;
                SmoothProgressDrawable.this.mCurrentOffset -= SmoothProgressDrawable.this.mMaxOffset;
            }
            SmoothProgressDrawable.this.scheduleSelf(SmoothProgressDrawable.this.mUpdater, SystemClock.uptimeMillis() + 16L);
            SmoothProgressDrawable.this.invalidateSelf();
        }
    };

    private SmoothProgressDrawable(Interpolator interpolator, int sectionsCount, int separatorLength, int[] colors, float strokeWidth, float speed, float progressiveStartSpeed, float progressiveStopSpeed, boolean reversed, boolean mirrorMode, Callbacks callbacks, boolean progressiveStartActivated, Drawable backgroundDrawable, boolean useGradients) {
        this.mInterpolator = interpolator;
        this.mSectionsCount = sectionsCount;
        this.mStartSection = 0;
        this.mCurrentSections = this.mSectionsCount;
        this.mSeparatorLength = separatorLength;
        this.mSpeed = speed;
        this.mProgressiveStartSpeed = progressiveStartSpeed;
        this.mProgressiveStopSpeed = progressiveStopSpeed;
        this.mReversed = reversed;
        this.mColors = colors;
        this.mColorsIndex = 0;
        this.mMirrorMode = mirrorMode;
        this.mFinishing = false;
        this.mBackgroundDrawable = backgroundDrawable;
        this.mStrokeWidth = strokeWidth;
        this.mMaxOffset = 1.0f / (float)this.mSectionsCount;
        this.mPaint = new Paint();
        this.mPaint.setStrokeWidth(strokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setDither(false);
        this.mPaint.setAntiAlias(false);
        this.mProgressiveStartActivated = progressiveStartActivated;
        this.mCallbacks = callbacks;
        this.mUseGradients = useGradients;
        this.refreshLinearGradientOptions();
    }

    public void setInterpolator(Interpolator interpolator) {
        if (interpolator == null) {
            throw new IllegalArgumentException("Interpolator cannot be null");
        }
        this.mInterpolator = interpolator;
        this.invalidateSelf();
    }

    public void setColors(int[] colors) {
        if (colors == null || colors.length == 0) {
            throw new IllegalArgumentException("Colors cannot be null or empty");
        }
        this.mColorsIndex = 0;
        this.mColors = colors;
        this.refreshLinearGradientOptions();
        this.invalidateSelf();
    }

    public void setColor(int color2) {
        this.setColors(new int[]{color2});
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            throw new IllegalArgumentException("Speed must be >= 0");
        }
        this.mSpeed = speed;
        this.invalidateSelf();
    }

    public void setProgressiveStartSpeed(float speed) {
        if (speed < 0.0f) {
            throw new IllegalArgumentException("SpeedProgressiveStart must be >= 0");
        }
        this.mProgressiveStartSpeed = speed;
        this.invalidateSelf();
    }

    public void setProgressiveStopSpeed(float speed) {
        if (speed < 0.0f) {
            throw new IllegalArgumentException("SpeedProgressiveStop must be >= 0");
        }
        this.mProgressiveStopSpeed = speed;
        this.invalidateSelf();
    }

    public void setSectionsCount(int sectionsCount) {
        if (sectionsCount <= 0) {
            throw new IllegalArgumentException("SectionsCount must be > 0");
        }
        this.mSectionsCount = sectionsCount;
        this.mMaxOffset = 1.0f / (float)this.mSectionsCount;
        this.mCurrentOffset %= this.mMaxOffset;
        this.refreshLinearGradientOptions();
        this.invalidateSelf();
    }

    public void setSeparatorLength(int separatorLength) {
        if (separatorLength < 0) {
            throw new IllegalArgumentException("SeparatorLength must be >= 0");
        }
        this.mSeparatorLength = separatorLength;
        this.invalidateSelf();
    }

    public void setStrokeWidth(float strokeWidth) {
        if (strokeWidth < 0.0f) {
            throw new IllegalArgumentException("The strokeWidth must be >= 0");
        }
        this.mPaint.setStrokeWidth(strokeWidth);
        this.invalidateSelf();
    }

    public void setReversed(boolean reversed) {
        if (this.mReversed == reversed) {
            return;
        }
        this.mReversed = reversed;
        this.invalidateSelf();
    }

    public void setMirrorMode(boolean mirrorMode) {
        if (this.mMirrorMode == mirrorMode) {
            return;
        }
        this.mMirrorMode = mirrorMode;
        this.invalidateSelf();
    }

    public void setBackgroundDrawable(Drawable backgroundDrawable) {
        if (this.mBackgroundDrawable == backgroundDrawable) {
            return;
        }
        this.mBackgroundDrawable = backgroundDrawable;
        this.invalidateSelf();
    }

    public Drawable getBackgroundDrawable() {
        return this.mBackgroundDrawable;
    }

    public int[] getColors() {
        return this.mColors;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public void setProgressiveStartActivated(boolean progressiveStartActivated) {
        this.mProgressiveStartActivated = progressiveStartActivated;
    }

    public void setUseGradients(boolean useGradients) {
        if (this.mUseGradients == useGradients) {
            return;
        }
        this.mUseGradients = useGradients;
        this.refreshLinearGradientOptions();
        this.invalidateSelf();
    }

    protected void refreshLinearGradientOptions() {
        if (this.mUseGradients) {
            this.mLinearGradientColors = new int[this.mSectionsCount + 2];
            this.mLinearGradientPositions = new float[this.mSectionsCount + 2];
        } else {
            this.mPaint.setShader(null);
            this.mLinearGradientColors = null;
            this.mLinearGradientPositions = null;
        }
    }

    public void draw(Canvas canvas) {
        this.mBounds = this.getBounds();
        canvas.clipRect(this.mBounds);
        if (this.mNewTurn) {
            this.mColorsIndex = this.decrementColor(this.mColorsIndex);
            this.mNewTurn = false;
            if (this.isFinishing()) {
                ++this.mStartSection;
                if (this.mStartSection > this.mSectionsCount) {
                    this.stop();
                    return;
                }
            }
            if (this.mCurrentSections < this.mSectionsCount) {
                ++this.mCurrentSections;
            }
        }
        if (this.mUseGradients) {
            this.drawGradient(canvas);
        }
        this.drawStrokes(canvas);
    }

    private void drawGradient(Canvas canvas) {
        float left;
        float xSectionWidth = 1.0f / (float)this.mSectionsCount;
        int currentIndexColor = this.mColorsIndex;
        this.mLinearGradientPositions[0] = 0.0f;
        this.mLinearGradientPositions[this.mLinearGradientPositions.length - 1] = 1.0f;
        int firstColorIndex = currentIndexColor - 1;
        if (firstColorIndex < 0) {
            firstColorIndex += this.mColors.length;
        }
        this.mLinearGradientColors[0] = this.mColors[firstColorIndex];
        for (int i = 0; i < this.mSectionsCount; ++i) {
            float position;
            this.mLinearGradientPositions[i + 1] = position = this.mInterpolator.getInterpolation((float)i * xSectionWidth + this.mCurrentOffset);
            this.mLinearGradientColors[i + 1] = this.mColors[currentIndexColor];
            currentIndexColor = (currentIndexColor + 1) % this.mColors.length;
        }
        this.mLinearGradientColors[this.mLinearGradientColors.length - 1] = this.mColors[currentIndexColor];
        float f = this.mReversed ? (float)(this.mMirrorMode ? Math.abs(this.mBounds.left - this.mBounds.right) / 2 : this.mBounds.left) : (left = (float)this.mBounds.left);
        float right = this.mMirrorMode ? (float)(this.mReversed ? this.mBounds.left : Math.abs(this.mBounds.left - this.mBounds.right) / 2) : (float)this.mBounds.right;
        float top = (float)this.mBounds.centerY() - this.mStrokeWidth / 2.0f;
        float bottom = (float)this.mBounds.centerY() + this.mStrokeWidth / 2.0f;
        LinearGradient linearGradient = new LinearGradient(left, top, right, bottom, this.mLinearGradientColors, this.mLinearGradientPositions, this.mMirrorMode ? Shader.TileMode.MIRROR : Shader.TileMode.CLAMP);
        this.mPaint.setShader((Shader)linearGradient);
    }

    private void drawStrokes(Canvas canvas) {
        if (this.mReversed) {
            canvas.translate((float)this.mBounds.width(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        float prevValue = 0.0f;
        int boundsWidth = this.mBounds.width();
        if (this.mMirrorMode) {
            boundsWidth /= 2;
        }
        int width = boundsWidth + this.mSeparatorLength + this.mSectionsCount;
        int centerY = this.mBounds.centerY();
        float xSectionWidth = 1.0f / (float)this.mSectionsCount;
        float firstX = 0.0f;
        float lastX = 0.0f;
        int currentIndexColor = this.mColorsIndex;
        if (this.mStartSection == this.mCurrentSections && this.mCurrentSections == this.mSectionsCount) {
            firstX = canvas.getWidth();
        }
        for (int i = 0; i <= this.mCurrentSections; ++i) {
            float sectionWidth;
            float xOffset = xSectionWidth * (float)i + this.mCurrentOffset;
            float prev = Math.max(0.0f, xOffset - xSectionWidth);
            float ratioSectionWidth = Math.abs(this.mInterpolator.getInterpolation(prev) - this.mInterpolator.getInterpolation(Math.min(xOffset, 1.0f)));
            float spaceLength = (sectionWidth = (float)((int)((float)width * ratioSectionWidth))) + prev < (float)width ? Math.min(sectionWidth, (float)this.mSeparatorLength) : 0.0f;
            float drawLength = sectionWidth > spaceLength ? sectionWidth - spaceLength : 0.0f;
            float end = prevValue + drawLength;
            if (end > prevValue && i >= this.mStartSection) {
                float xFinishingOffset = this.mInterpolator.getInterpolation(Math.min(this.mFinishingOffset, 1.0f));
                float startX = Math.max(xFinishingOffset * (float)width, Math.min((float)boundsWidth, prevValue));
                float endX = Math.min((float)boundsWidth, end);
                this.drawLine(canvas, boundsWidth, startX, centerY, endX, centerY, currentIndexColor);
                if (i == this.mStartSection) {
                    firstX = startX - (float)this.mSeparatorLength;
                }
            }
            if (i == this.mCurrentSections) {
                lastX = prevValue + sectionWidth;
            }
            prevValue = end + spaceLength;
            currentIndexColor = this.incrementColor(currentIndexColor);
        }
        this.drawBackgroundIfNeeded(canvas, firstX, lastX);
    }

    private void drawLine(Canvas canvas, int canvasWidth, float startX, float startY, float stopX, float stopY, int currentIndexColor) {
        this.mPaint.setColor(this.mColors[currentIndexColor]);
        if (!this.mMirrorMode) {
            canvas.drawLine(startX, startY, stopX, stopY, this.mPaint);
        } else if (this.mReversed) {
            canvas.drawLine((float)canvasWidth + startX, startY, (float)canvasWidth + stopX, stopY, this.mPaint);
            canvas.drawLine((float)canvasWidth - startX, startY, (float)canvasWidth - stopX, stopY, this.mPaint);
        } else {
            canvas.drawLine(startX, startY, stopX, stopY, this.mPaint);
            canvas.drawLine((float)(canvasWidth * 2) - startX, startY, (float)(canvasWidth * 2) - stopX, stopY, this.mPaint);
        }
    }

    private void drawBackgroundIfNeeded(Canvas canvas, float firstX, float lastX) {
        if (this.mBackgroundDrawable == null) {
            return;
        }
        this.fBackgroundRect.top = (int)(((float)canvas.getHeight() - this.mStrokeWidth) / 2.0f);
        this.fBackgroundRect.bottom = (int)(((float)canvas.getHeight() + this.mStrokeWidth) / 2.0f);
        this.fBackgroundRect.left = 0;
        this.fBackgroundRect.right = this.mMirrorMode ? canvas.getWidth() / 2 : canvas.getWidth();
        this.mBackgroundDrawable.setBounds(this.fBackgroundRect);
        if (!this.isRunning()) {
            if (this.mMirrorMode) {
                canvas.save();
                canvas.translate((float)(canvas.getWidth() / 2), 0.0f);
                this.drawBackground(canvas, 0.0f, this.fBackgroundRect.width());
                canvas.scale(-1.0f, 1.0f);
                this.drawBackground(canvas, 0.0f, this.fBackgroundRect.width());
                canvas.restore();
            } else {
                this.drawBackground(canvas, 0.0f, this.fBackgroundRect.width());
            }
            return;
        }
        if (!this.isFinishing() && !this.isStarting()) {
            return;
        }
        if (firstX > lastX) {
            float temp = firstX;
            firstX = lastX;
            lastX = temp;
        }
        if (firstX > 0.0f) {
            if (this.mMirrorMode) {
                canvas.save();
                canvas.translate((float)(canvas.getWidth() / 2), 0.0f);
                if (this.mReversed) {
                    this.drawBackground(canvas, 0.0f, firstX);
                    canvas.scale(-1.0f, 1.0f);
                    this.drawBackground(canvas, 0.0f, firstX);
                } else {
                    this.drawBackground(canvas, (float)(canvas.getWidth() / 2) - firstX, canvas.getWidth() / 2);
                    canvas.scale(-1.0f, 1.0f);
                    this.drawBackground(canvas, (float)(canvas.getWidth() / 2) - firstX, canvas.getWidth() / 2);
                }
                canvas.restore();
            } else {
                this.drawBackground(canvas, 0.0f, firstX);
            }
        }
        if (lastX <= (float)canvas.getWidth()) {
            if (this.mMirrorMode) {
                canvas.save();
                canvas.translate((float)(canvas.getWidth() / 2), 0.0f);
                if (this.mReversed) {
                    this.drawBackground(canvas, lastX, canvas.getWidth() / 2);
                    canvas.scale(-1.0f, 1.0f);
                    this.drawBackground(canvas, lastX, canvas.getWidth() / 2);
                } else {
                    this.drawBackground(canvas, 0.0f, (float)(canvas.getWidth() / 2) - lastX);
                    canvas.scale(-1.0f, 1.0f);
                    this.drawBackground(canvas, 0.0f, (float)(canvas.getWidth() / 2) - lastX);
                }
                canvas.restore();
            } else {
                this.drawBackground(canvas, lastX, canvas.getWidth());
            }
        }
    }

    private void drawBackground(Canvas canvas, float fromX, float toX) {
        int count = canvas.save();
        canvas.clipRect(fromX, (float)((int)(((float)canvas.getHeight() - this.mStrokeWidth) / 2.0f)), toX, (float)((int)(((float)canvas.getHeight() + this.mStrokeWidth) / 2.0f)));
        this.mBackgroundDrawable.draw(canvas);
        canvas.restoreToCount(count);
    }

    private int incrementColor(int colorIndex) {
        if (++colorIndex >= this.mColors.length) {
            colorIndex = 0;
        }
        return colorIndex;
    }

    private int decrementColor(int colorIndex) {
        if (--colorIndex < 0) {
            colorIndex = this.mColors.length - 1;
        }
        return colorIndex;
    }

    public void progressiveStart() {
        this.progressiveStart(0);
    }

    public void progressiveStart(int index) {
        this.resetProgressiveStart(index);
        this.start();
    }

    private void resetProgressiveStart(int index) {
        this.checkColorIndex(index);
        this.mCurrentOffset = 0.0f;
        this.mFinishing = false;
        this.mFinishingOffset = 0.0f;
        this.mStartSection = 0;
        this.mCurrentSections = 0;
        this.mColorsIndex = index;
    }

    public void progressiveStop() {
        this.mFinishing = true;
        this.mStartSection = 0;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    public void start() {
        if (this.mProgressiveStartActivated) {
            this.resetProgressiveStart(0);
        }
        if (this.isRunning()) {
            return;
        }
        if (this.mCallbacks != null) {
            this.mCallbacks.onStart();
        }
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        if (this.mCallbacks != null) {
            this.mCallbacks.onStop();
        }
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public boolean isStarting() {
        return this.mCurrentSections < this.mSectionsCount;
    }

    public boolean isFinishing() {
        return this.mFinishing;
    }

    public void setCallbacks(Callbacks callbacks) {
        this.mCallbacks = callbacks;
    }

    private void checkColorIndex(int index) {
        if (index < 0 || index >= this.mColors.length) {
            throw new IllegalArgumentException(String.format("Index %d not valid", index));
        }
    }

    public static class Builder {
        private Interpolator mInterpolator;
        private int mSectionsCount;
        private int[] mColors;
        private float mSpeed;
        private float mProgressiveStartSpeed;
        private float mProgressiveStopSpeed;
        private boolean mReversed;
        private boolean mMirrorMode;
        private float mStrokeWidth;
        private int mStrokeSeparatorLength;
        private boolean mProgressiveStartActivated;
        private boolean mGenerateBackgroundUsingColors;
        private boolean mGradients;
        private Drawable mBackgroundDrawableWhenHidden;
        private Callbacks mOnProgressiveStopEndedListener;

        public Builder(Context context) {
            this.initValues(context);
        }

        public SmoothProgressDrawable build() {
            if (this.mGenerateBackgroundUsingColors) {
                this.mBackgroundDrawableWhenHidden = SmoothProgressBarUtils.generateDrawableWithColors(this.mColors, this.mStrokeWidth);
            }
            SmoothProgressDrawable ret = new SmoothProgressDrawable(this.mInterpolator, this.mSectionsCount, this.mStrokeSeparatorLength, this.mColors, this.mStrokeWidth, this.mSpeed, this.mProgressiveStartSpeed, this.mProgressiveStopSpeed, this.mReversed, this.mMirrorMode, this.mOnProgressiveStopEndedListener, this.mProgressiveStartActivated, this.mBackgroundDrawableWhenHidden, this.mGradients);
            return ret;
        }

        private void initValues(Context context) {
            Resources res = context.getResources();
            this.mInterpolator = new AccelerateInterpolator();
            this.mSectionsCount = res.getInteger(R.integer.spb_default_sections_count);
            this.mColors = new int[]{res.getColor(R.color.spb_default_color)};
            this.mProgressiveStartSpeed = this.mSpeed = Float.parseFloat(res.getString(R.string.spb_default_speed));
            this.mProgressiveStopSpeed = this.mSpeed;
            this.mReversed = res.getBoolean(R.bool.spb_default_reversed);
            this.mStrokeSeparatorLength = res.getDimensionPixelSize(R.dimen.spb_default_stroke_separator_length);
            this.mStrokeWidth = res.getDimensionPixelOffset(R.dimen.spb_default_stroke_width);
            this.mProgressiveStartActivated = res.getBoolean(R.bool.spb_default_progressiveStart_activated);
            this.mGradients = false;
        }

        public Builder interpolator(Interpolator interpolator) {
            if (interpolator == null) {
                throw new IllegalArgumentException("Interpolator can't be null");
            }
            this.mInterpolator = interpolator;
            return this;
        }

        public Builder sectionsCount(int sectionsCount) {
            if (sectionsCount <= 0) {
                throw new IllegalArgumentException("SectionsCount must be > 0");
            }
            this.mSectionsCount = sectionsCount;
            return this;
        }

        public Builder separatorLength(int separatorLength) {
            if (separatorLength < 0) {
                throw new IllegalArgumentException("SeparatorLength must be >= 0");
            }
            this.mStrokeSeparatorLength = separatorLength;
            return this;
        }

        public Builder color(int color2) {
            this.mColors = new int[]{color2};
            return this;
        }

        public Builder colors(int[] colors) {
            if (colors == null || colors.length == 0) {
                throw new IllegalArgumentException("Your color array must not be empty");
            }
            this.mColors = colors;
            return this;
        }

        public Builder strokeWidth(float width) {
            if (width < 0.0f) {
                throw new IllegalArgumentException("The width must be >= 0");
            }
            this.mStrokeWidth = width;
            return this;
        }

        public Builder speed(float speed) {
            if (speed < 0.0f) {
                throw new IllegalArgumentException("Speed must be >= 0");
            }
            this.mSpeed = speed;
            return this;
        }

        public Builder progressiveStartSpeed(float progressiveStartSpeed) {
            if (progressiveStartSpeed < 0.0f) {
                throw new IllegalArgumentException("progressiveStartSpeed must be >= 0");
            }
            this.mProgressiveStartSpeed = progressiveStartSpeed;
            return this;
        }

        public Builder progressiveStopSpeed(float progressiveStopSpeed) {
            if (progressiveStopSpeed < 0.0f) {
                throw new IllegalArgumentException("progressiveStopSpeed must be >= 0");
            }
            this.mProgressiveStopSpeed = progressiveStopSpeed;
            return this;
        }

        public Builder reversed(boolean reversed) {
            this.mReversed = reversed;
            return this;
        }

        public Builder mirrorMode(boolean mirrorMode) {
            this.mMirrorMode = mirrorMode;
            return this;
        }

        public Builder progressiveStart(boolean progressiveStartActivated) {
            this.mProgressiveStartActivated = progressiveStartActivated;
            return this;
        }

        public Builder callbacks(Callbacks onProgressiveStopEndedListener) {
            this.mOnProgressiveStopEndedListener = onProgressiveStopEndedListener;
            return this;
        }

        public Builder backgroundDrawable(Drawable backgroundDrawableWhenHidden) {
            this.mBackgroundDrawableWhenHidden = backgroundDrawableWhenHidden;
            return this;
        }

        public Builder generateBackgroundUsingColors() {
            this.mGenerateBackgroundUsingColors = true;
            return this;
        }

        public Builder gradients() {
            return this.gradients(true);
        }

        public Builder gradients(boolean useGradients) {
            this.mGradients = useGradients;
            return this;
        }
    }

    public static interface Callbacks {
        public void onStop();

        public void onStart();
    }
}

