/*
 * Decompiled with CFR 0.152.
 */
package retry;

import cats.Applicative;
import cats.Apply;
import cats.Functor;
import cats.Show;
import cats.Show$;
import cats.syntax.package;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import retry.Fibonacci$;
import retry.PolicyDecision;
import retry.PolicyDecision$GiveUp$;
import retry.RetryPolicy;
import retry.RetryPolicy$;
import retry.RetryStatus;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public final class RetryPolicies$ {
    public static RetryPolicies$ MODULE$;
    private final BigInt LongMax;

    static {
        new RetryPolicies$();
    }

    private BigInt LongMax() {
        return this.LongMax;
    }

    private FiniteDuration safeMultiply(FiniteDuration duration, long multiplier) {
        BigInt durationNanos = package$.MODULE$.BigInt().apply(duration.toNanos());
        BigInt resultNanos = durationNanos.$times(package$.MODULE$.BigInt().apply(multiplier));
        BigInt safeResultNanos = resultNanos.min(this.LongMax());
        return FiniteDuration$.MODULE$.apply(safeResultNanos.toLong(), TimeUnit.NANOSECONDS);
    }

    public <M> RetryPolicy<M> alwaysGiveUp(Applicative<M> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable & scala.Serializable)y -> (PolicyDecision$GiveUp$)Function$.MODULE$.const((Object)PolicyDecision$GiveUp$.MODULE$, y), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "alwaysGiveUp", evidence$1);
    }

    public <M> RetryPolicy<M> constantDelay(FiniteDuration delay, Applicative<M> evidence$2) {
        PolicyDecision.DelayAndRetry delayAndRetry = new PolicyDecision.DelayAndRetry(delay);
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable & scala.Serializable)y -> (PolicyDecision.DelayAndRetry)Function$.MODULE$.const((Object)delayAndRetry, y), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"constantDelay(", ")"}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)delay, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))})), evidence$2);
    }

    public <M> RetryPolicy<M> exponentialBackoff(FiniteDuration baseDelay, Applicative<M> evidence$3) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable & scala.Serializable)status -> {
            FiniteDuration delay = MODULE$.safeMultiply(baseDelay, (long)Math.pow(2.0, status.retriesSoFar()));
            return new PolicyDecision.DelayAndRetry(delay);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exponentialBackOff(baseDelay=", ")"}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))})), evidence$3);
    }

    public <M> RetryPolicy<M> limitRetries(int maxRetries, Applicative<M> evidence$4) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable & scala.Serializable)status -> {
            if (status.retriesSoFar() >= maxRetries) {
                return PolicyDecision$GiveUp$.MODULE$;
            }
            return new PolicyDecision.DelayAndRetry(Duration$.MODULE$.Zero());
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetries(maxRetries=", ")"}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)BoxesRunTime.boxToInteger((int)maxRetries), (Show.ContravariantShow)Show$.MODULE$.catsShowForInt()))})), evidence$4);
    }

    public <M> RetryPolicy<M> fibonacciBackoff(FiniteDuration baseDelay, Applicative<M> evidence$5) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable & scala.Serializable)status -> {
            FiniteDuration delay = MODULE$.safeMultiply(baseDelay, Fibonacci$.MODULE$.fibonacci(status.retriesSoFar() + 1));
            return new PolicyDecision.DelayAndRetry(delay);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fibonacciBackoff(baseDelay=", ")"}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))})), evidence$5);
    }

    public <M> RetryPolicy<M> fullJitter(FiniteDuration baseDelay, Applicative<M> evidence$6) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable & scala.Serializable)status -> {
            long e = (long)Math.pow(2.0, status.retriesSoFar());
            FiniteDuration maxDelay = MODULE$.safeMultiply(baseDelay, e);
            long delayNanos = (long)((double)maxDelay.toNanos() * Random$.MODULE$.nextDouble());
            return new PolicyDecision.DelayAndRetry(new FiniteDuration(delayNanos, TimeUnit.NANOSECONDS));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fullJitter(baseDelay=", ")"}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))})), evidence$6);
    }

    public <M> RetryPolicy<M> capDelay(FiniteDuration cap, RetryPolicy<M> policy, Applicative<M> evidence$7) {
        return policy.meet(this.constantDelay(cap, evidence$7), (Apply<M>)evidence$7);
    }

    public <M> RetryPolicy<M> limitRetriesByDelay(FiniteDuration threshold, RetryPolicy<M> policy, Applicative<M> evidence$8) {
        return RetryPolicy$.MODULE$.withShow((Function1 & Serializable & scala.Serializable)status -> RetryPolicies$.decideNextRetry$1(status, policy, evidence$8, threshold), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetriesByDelay(threshold=", ", ", ")"}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)threshold, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)policy, RetryPolicy$.MODULE$.showForRetryPolicy()))})));
    }

    public <M> RetryPolicy<M> limitRetriesByCumulativeDelay(FiniteDuration threshold, RetryPolicy<M> policy, Applicative<M> evidence$9) {
        return RetryPolicy$.MODULE$.withShow((Function1 & Serializable & scala.Serializable)status -> RetryPolicies$.decideNextRetry$2(status, policy, evidence$9, threshold), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetriesByCumulativeDelay(threshold=", ", ", ")"}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)threshold, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)policy, RetryPolicy$.MODULE$.showForRetryPolicy()))})));
    }

    private static final Object decideNextRetry$1(RetryStatus status, RetryPolicy policy$1, Applicative evidence$8$1, FiniteDuration threshold$1) {
        return package.functor$.MODULE$.toFunctorOps(policy$1.decideNextRetry().apply((Object)status), (Functor)evidence$8$1).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PolicyDecision policyDecision = x0$1;
            if (policyDecision instanceof PolicyDecision.DelayAndRetry) {
                PolicyDecision.DelayAndRetry delayAndRetry = (PolicyDecision.DelayAndRetry)policyDecision;
                FiniteDuration delay = delayAndRetry.delay();
                if (delay.$greater((Object)threshold$1)) {
                    return PolicyDecision$GiveUp$.MODULE$;
                }
                return delayAndRetry;
            }
            if (PolicyDecision$GiveUp$.MODULE$.equals(policyDecision)) {
                return PolicyDecision$GiveUp$.MODULE$;
            }
            throw new MatchError((Object)policyDecision);
        });
    }

    private static final Object decideNextRetry$2(RetryStatus status, RetryPolicy policy$2, Applicative evidence$9$1, FiniteDuration threshold$2) {
        return package.functor$.MODULE$.toFunctorOps(policy$2.decideNextRetry().apply((Object)status), (Functor)evidence$9$1).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PolicyDecision policyDecision = x0$1;
            if (policyDecision instanceof PolicyDecision.DelayAndRetry) {
                PolicyDecision.DelayAndRetry delayAndRetry = (PolicyDecision.DelayAndRetry)policyDecision;
                FiniteDuration delay = delayAndRetry.delay();
                if (status.cumulativeDelay().$plus(delay).$greater$eq((Object)threshold$2)) {
                    return PolicyDecision$GiveUp$.MODULE$;
                }
                return delayAndRetry;
            }
            if (PolicyDecision$GiveUp$.MODULE$.equals(policyDecision)) {
                return PolicyDecision$GiveUp$.MODULE$;
            }
            throw new MatchError((Object)policyDecision);
        });
    }

    private RetryPolicies$() {
        MODULE$ = this;
        this.LongMax = package$.MODULE$.BigInt().apply(Long.MAX_VALUE);
    }
}

