/*
 * Decompiled with CFR 0.152.
 */
package retry;

import cats.Applicative;
import cats.Apply;
import cats.Functor;
import cats.Show;
import cats.Show$;
import cats.syntax.package;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import retry.Fibonacci$;
import retry.PolicyDecision;
import retry.PolicyDecision$DelayAndRetry$;
import retry.PolicyDecision$GiveUp$;
import retry.RetryPolicy;
import retry.RetryPolicy$;
import retry.RetryStatus;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.StringContext$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

public final class RetryPolicies$
implements Serializable {
    private static final BigInt LongMax;
    public static final RetryPolicies$ MODULE$;

    private RetryPolicies$() {
    }

    static {
        MODULE$ = new RetryPolicies$();
        LongMax = package$.MODULE$.BigInt().apply(Long.MAX_VALUE);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RetryPolicies$.class);
    }

    private FiniteDuration safeMultiply(FiniteDuration duration, long multiplier) {
        BigInt durationNanos = package$.MODULE$.BigInt().apply(duration.toNanos());
        BigInt resultNanos = durationNanos.$times(package$.MODULE$.BigInt().apply(multiplier));
        BigInt safeResultNanos = resultNanos.min(LongMax);
        return FiniteDuration$.MODULE$.apply(safeResultNanos.toLong(), TimeUnit.NANOSECONDS);
    }

    public <M> RetryPolicy<M> alwaysGiveUp(Applicative<M> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable)y -> (PolicyDecision)Function$.MODULE$.const((Object)PolicyDecision$GiveUp$.MODULE$, y), (Function0<String>)((Function0 & Serializable)this::alwaysGiveUp$$anonfun$2), evidence$1);
    }

    public <M> RetryPolicy<M> constantDelay(FiniteDuration delay, Applicative<M> evidence$1) {
        PolicyDecision.DelayAndRetry delayAndRetry = PolicyDecision$DelayAndRetry$.MODULE$.apply(delay);
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable)y -> (PolicyDecision)Function$.MODULE$.const((Object)delayAndRetry, y), (Function0<String>)((Function0 & Serializable)() -> this.constantDelay$$anonfun$2(delay)), evidence$1);
    }

    public <M> RetryPolicy<M> exponentialBackoff(FiniteDuration baseDelay, Applicative<M> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable)status -> {
            FiniteDuration delay = this.safeMultiply(baseDelay, (long)Math.pow(2.0, status.retriesSoFar()));
            return PolicyDecision$DelayAndRetry$.MODULE$.apply(delay);
        }, (Function0<String>)((Function0 & Serializable)() -> this.exponentialBackoff$$anonfun$2(baseDelay)), evidence$1);
    }

    public <M> RetryPolicy<M> limitRetries(int maxRetries, Applicative<M> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable)status -> (PolicyDecision)(status.retriesSoFar() >= maxRetries ? PolicyDecision$GiveUp$.MODULE$ : PolicyDecision$DelayAndRetry$.MODULE$.apply(Duration$.MODULE$.Zero())), (Function0<String>)((Function0 & Serializable)() -> this.limitRetries$$anonfun$2(maxRetries)), evidence$1);
    }

    public <M> RetryPolicy<M> fibonacciBackoff(FiniteDuration baseDelay, Applicative<M> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable)status -> {
            FiniteDuration delay = this.safeMultiply(baseDelay, Fibonacci$.MODULE$.fibonacci(status.retriesSoFar() + 1));
            return PolicyDecision$DelayAndRetry$.MODULE$.apply(delay);
        }, (Function0<String>)((Function0 & Serializable)() -> this.fibonacciBackoff$$anonfun$2(baseDelay)), evidence$1);
    }

    public <M> RetryPolicy<M> fullJitter(FiniteDuration baseDelay, Applicative<M> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function1<RetryStatus, PolicyDecision>)(Function1 & Serializable)status -> {
            long e = (long)Math.pow(2.0, status.retriesSoFar());
            FiniteDuration maxDelay = this.safeMultiply(baseDelay, e);
            long delayNanos = (long)((double)maxDelay.toNanos() * Random$.MODULE$.nextDouble());
            return PolicyDecision$DelayAndRetry$.MODULE$.apply(new FiniteDuration(delayNanos, TimeUnit.NANOSECONDS));
        }, (Function0<String>)((Function0 & Serializable)() -> this.fullJitter$$anonfun$2(baseDelay)), evidence$1);
    }

    public <M> RetryPolicy<M> capDelay(FiniteDuration cap, RetryPolicy<M> policy, Applicative<M> evidence$1) {
        return policy.meet(this.constantDelay(cap, evidence$1), (Apply<M>)evidence$1);
    }

    public <M> RetryPolicy<M> limitRetriesByDelay(FiniteDuration threshold, RetryPolicy<M> policy, Applicative<M> evidence$1) {
        return RetryPolicy$.MODULE$.withShow((Function1<RetryStatus, Object>)(Function1 & Serializable)status -> this.decideNextRetry$1(policy, evidence$1, threshold, (RetryStatus)status), (Function0<String>)((Function0 & Serializable)() -> this.limitRetriesByDelay$$anonfun$2(threshold, policy)));
    }

    public <M> RetryPolicy<M> limitRetriesByCumulativeDelay(FiniteDuration threshold, RetryPolicy<M> policy, Applicative<M> evidence$1) {
        return RetryPolicy$.MODULE$.withShow((Function1<RetryStatus, Object>)(Function1 & Serializable)status -> this.decideNextRetry$2(policy, evidence$1, threshold, (RetryStatus)status), (Function0<String>)((Function0 & Serializable)() -> this.limitRetriesByCumulativeDelay$$anonfun$2(threshold, policy)));
    }

    private final String alwaysGiveUp$$anonfun$2() {
        return "alwaysGiveUp";
    }

    private final String constantDelay$$anonfun$2(FiniteDuration delay$1) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"constantDelay(", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)delay$1, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))}));
    }

    private final String exponentialBackoff$$anonfun$2(FiniteDuration baseDelay$2) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exponentialBackOff(baseDelay=", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay$2, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))}));
    }

    private final String limitRetries$$anonfun$2(int maxRetries$2) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetries(maxRetries=", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)BoxesRunTime.boxToInteger((int)maxRetries$2), (Show.ContravariantShow)Show$.MODULE$.catsShowForInt()))}));
    }

    private final String fibonacciBackoff$$anonfun$2(FiniteDuration baseDelay$4) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fibonacciBackoff(baseDelay=", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay$4, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))}));
    }

    private final String fullJitter$$anonfun$2(FiniteDuration baseDelay$6) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fullJitter(baseDelay=", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay$6, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))}));
    }

    private final Object decideNextRetry$1(RetryPolicy policy$1, Applicative evidence$1$1, FiniteDuration threshold$1, RetryStatus status) {
        return package.functor$.MODULE$.toFunctorOps(policy$1.decideNextRetry().apply((Object)status), (Functor)evidence$1$1).map((Function1 & Serializable)x$1 -> {
            Product product;
            PolicyDecision policyDecision = x$1;
            if (policyDecision instanceof PolicyDecision.DelayAndRetry) {
                FiniteDuration finiteDuration;
                PolicyDecision.DelayAndRetry delayAndRetry = (PolicyDecision.DelayAndRetry)policyDecision;
                PolicyDecision.DelayAndRetry delayAndRetry2 = PolicyDecision$DelayAndRetry$.MODULE$.unapply(delayAndRetry);
                FiniteDuration delay = finiteDuration = delayAndRetry2._1();
                PolicyDecision.DelayAndRetry r = delayAndRetry;
                product = delay.$greater((Object)threshold$1) ? PolicyDecision$GiveUp$.MODULE$ : r;
            } else if (PolicyDecision$GiveUp$.MODULE$.equals(policyDecision)) {
                product = PolicyDecision$GiveUp$.MODULE$;
            } else {
                throw new MatchError((Object)policyDecision);
            }
            return product;
        });
    }

    private final String limitRetriesByDelay$$anonfun$2(FiniteDuration threshold$3, RetryPolicy policy$2) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetriesByDelay(threshold=", ", ", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)threshold$3, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)policy$2, RetryPolicy$.MODULE$.showForRetryPolicy()))}));
    }

    private final Object decideNextRetry$2(RetryPolicy policy$3, Applicative evidence$1$2, FiniteDuration threshold$4, RetryStatus status) {
        return package.functor$.MODULE$.toFunctorOps(policy$3.decideNextRetry().apply((Object)status), (Functor)evidence$1$2).map((Function1 & Serializable)x$1 -> {
            Product product;
            PolicyDecision policyDecision = x$1;
            if (policyDecision instanceof PolicyDecision.DelayAndRetry) {
                FiniteDuration finiteDuration;
                PolicyDecision.DelayAndRetry delayAndRetry = (PolicyDecision.DelayAndRetry)policyDecision;
                PolicyDecision.DelayAndRetry delayAndRetry2 = PolicyDecision$DelayAndRetry$.MODULE$.unapply(delayAndRetry);
                FiniteDuration delay = finiteDuration = delayAndRetry2._1();
                PolicyDecision.DelayAndRetry r = delayAndRetry;
                product = status.cumulativeDelay().$plus(delay).$greater$eq((Object)threshold$4) ? PolicyDecision$GiveUp$.MODULE$ : r;
            } else if (PolicyDecision$GiveUp$.MODULE$.equals(policyDecision)) {
                product = PolicyDecision$GiveUp$.MODULE$;
            } else {
                throw new MatchError((Object)policyDecision);
            }
            return product;
        });
    }

    private final String limitRetriesByCumulativeDelay$$anonfun$2(FiniteDuration threshold$6, RetryPolicy policy$4) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetriesByCumulativeDelay(threshold=", ", ", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)threshold$6, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)policy$4, RetryPolicy$.MODULE$.showForRetryPolicy()))}));
    }
}

