/*
 * Decompiled with CFR 0.152.
 */
package retry;

import cats.Applicative;
import cats.Apply;
import cats.Functor;
import cats.Show;
import cats.Show$;
import cats.effect.std.Random;
import cats.effect.std.Random$;
import cats.syntax.package;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import retry.Fibonacci$;
import retry.PolicyDecision;
import retry.PolicyDecision$;
import retry.PolicyDecision$DelayAndRetry$;
import retry.RetryPolicy;
import retry.RetryPolicy$;
import retry.RetryStatus;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.StringContext$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class RetryPolicies$
implements Serializable {
    private static final BigInt LongMax;
    public static final RetryPolicies$ MODULE$;

    private RetryPolicies$() {
    }

    static {
        MODULE$ = new RetryPolicies$();
        LongMax = package$.MODULE$.BigInt().apply(Long.MAX_VALUE);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RetryPolicies$.class);
    }

    private FiniteDuration safeMultiply(FiniteDuration duration, long multiplier) {
        BigInt durationNanos = package$.MODULE$.BigInt().apply(duration.toNanos());
        BigInt resultNanos = durationNanos.$times(package$.MODULE$.BigInt().apply(multiplier));
        BigInt safeResultNanos = resultNanos.min(LongMax);
        return FiniteDuration$.MODULE$.apply(safeResultNanos.toLong(), TimeUnit.NANOSECONDS);
    }

    public <F> RetryPolicy<F, Object> alwaysGiveUp(Applicative<F> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function2 & Serializable)(_$2, _$3) -> PolicyDecision$.GiveUp, (Function0<String>)((Function0 & Serializable)RetryPolicies$::alwaysGiveUp$$anonfun$2), evidence$1);
    }

    public <F> RetryPolicy<F, Object> constantDelay(FiniteDuration delay, Applicative<F> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function2 & Serializable)(_$5, _$6) -> PolicyDecision$DelayAndRetry$.MODULE$.apply(delay), (Function0<String>)((Function0 & Serializable)() -> RetryPolicies$.constantDelay$$anonfun$2(delay)), evidence$1);
    }

    public <F> RetryPolicy<F, Object> exponentialBackoff(FiniteDuration baseDelay, Applicative<F> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function2 & Serializable)(_$8, status) -> {
            FiniteDuration delay = MODULE$.safeMultiply(baseDelay, (long)Math.pow(2.0, status.retriesSoFar()));
            return PolicyDecision$DelayAndRetry$.MODULE$.apply(delay);
        }, (Function0<String>)((Function0 & Serializable)() -> RetryPolicies$.exponentialBackoff$$anonfun$2(baseDelay)), evidence$1);
    }

    public <F> RetryPolicy<F, Object> limitRetries(int maxRetries, Applicative<F> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function2 & Serializable)(_$10, status) -> {
            if (status.retriesSoFar() >= maxRetries) {
                return PolicyDecision$.GiveUp;
            }
            return PolicyDecision$DelayAndRetry$.MODULE$.apply(Duration$.MODULE$.Zero());
        }, (Function0<String>)((Function0 & Serializable)() -> RetryPolicies$.limitRetries$$anonfun$2(maxRetries)), evidence$1);
    }

    public <F> RetryPolicy<F, Object> fibonacciBackoff(FiniteDuration baseDelay, Applicative<F> evidence$1) {
        return RetryPolicy$.MODULE$.liftWithShow((Function2 & Serializable)(_$12, status) -> {
            FiniteDuration delay = MODULE$.safeMultiply(baseDelay, Fibonacci$.MODULE$.fibonacci(status.retriesSoFar() + 1));
            return PolicyDecision$DelayAndRetry$.MODULE$.apply(delay);
        }, (Function0<String>)((Function0 & Serializable)() -> RetryPolicies$.fibonacciBackoff$$anonfun$2(baseDelay)), evidence$1);
    }

    public <F> RetryPolicy<F, Object> fullJitter(FiniteDuration baseDelay, Applicative<F> evidence$1, Random<F> evidence$2) {
        return RetryPolicy$.MODULE$.withShow((Function2 & Serializable)(_$14, status) -> {
            long e = (long)Math.pow(2.0, status.retriesSoFar());
            FiniteDuration maxDelay = MODULE$.safeMultiply(baseDelay, e);
            return package.functor$.MODULE$.toFunctorOps(Random$.MODULE$.apply(evidence$2).nextDouble(), (Functor)evidence$1).map((Function1 & Serializable)rnd -> RetryPolicies$.fullJitter$$anonfun$1$$anonfun$1(maxDelay, BoxesRunTime.unboxToDouble((Object)rnd)));
        }, (Function0<String>)((Function0 & Serializable)() -> RetryPolicies$.fullJitter$$anonfun$2(baseDelay)));
    }

    public <F, Res> RetryPolicy<F, Res> capDelay(FiniteDuration cap, RetryPolicy<F, Res> policy, Applicative<F> evidence$1) {
        return policy.meet(this.constantDelay(cap, evidence$1), (Apply<F>)evidence$1);
    }

    public <F, Res> RetryPolicy<F, Res> limitRetriesByDelay(FiniteDuration threshold, RetryPolicy<F, Res> policy, Applicative<F> evidence$1) {
        return RetryPolicy$.MODULE$.withShow((Function2 & Serializable)(actionResult, status) -> this.decideNextRetry$1(policy, evidence$1, threshold, actionResult, (RetryStatus)status), (Function0<String>)((Function0 & Serializable)() -> RetryPolicies$.limitRetriesByDelay$$anonfun$2(threshold, policy)));
    }

    public <F, Res> RetryPolicy<F, Res> limitRetriesByCumulativeDelay(FiniteDuration threshold, RetryPolicy<F, Res> policy, Applicative<F> evidence$1) {
        return RetryPolicy$.MODULE$.withShow((Function2 & Serializable)(actionResult, status) -> this.decideNextRetry$2(policy, evidence$1, threshold, actionResult, (RetryStatus)status), (Function0<String>)((Function0 & Serializable)() -> RetryPolicies$.limitRetriesByCumulativeDelay$$anonfun$2(threshold, policy)));
    }

    public <F, Res> RetryPolicy<F, Res> dynamic(Function1<Res, RetryPolicy<F, Res>> f) {
        return RetryPolicy$.MODULE$.withShow((Function2 & Serializable)(actionResult, status) -> this.decideNextRetry$3(f, actionResult, (RetryStatus)status), (Function0<String>)((Function0 & Serializable)RetryPolicies$::dynamic$$anonfun$2));
    }

    private static final String alwaysGiveUp$$anonfun$2() {
        return "alwaysGiveUp";
    }

    private static final String constantDelay$$anonfun$2(FiniteDuration delay$2) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"constantDelay(", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)delay$2, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))}));
    }

    private static final String exponentialBackoff$$anonfun$2(FiniteDuration baseDelay$2) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exponentialBackOff(baseDelay=", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay$2, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))}));
    }

    private static final String limitRetries$$anonfun$2(int maxRetries$2) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetries(maxRetries=", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)BoxesRunTime.boxToInteger((int)maxRetries$2), (Show.ContravariantShow)Show$.MODULE$.catsShowForInt()))}));
    }

    private static final String fibonacciBackoff$$anonfun$2(FiniteDuration baseDelay$4) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fibonacciBackoff(baseDelay=", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay$4, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))}));
    }

    private static final /* synthetic */ PolicyDecision fullJitter$$anonfun$1$$anonfun$1(FiniteDuration maxDelay$1, double rnd) {
        long delayNanos = (long)((double)maxDelay$1.toNanos() * rnd);
        return PolicyDecision$DelayAndRetry$.MODULE$.apply(new FiniteDuration(delayNanos, TimeUnit.NANOSECONDS));
    }

    private static final String fullJitter$$anonfun$2(FiniteDuration baseDelay$6) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fullJitter(baseDelay=", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)baseDelay$6, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration()))}));
    }

    private final Object decideNextRetry$1(RetryPolicy policy$1, Applicative evidence$1$2, FiniteDuration threshold$1, Object actionResult, RetryStatus status) {
        return package.functor$.MODULE$.toFunctorOps(policy$1.decideNextRetry().apply(actionResult, (Object)status), (Functor)evidence$1$2).map((Function1 & Serializable)x$1 -> {
            PolicyDecision policyDecision = x$1;
            if (policyDecision instanceof PolicyDecision.DelayAndRetry) {
                FiniteDuration finiteDuration;
                PolicyDecision.DelayAndRetry delayAndRetry = (PolicyDecision.DelayAndRetry)policyDecision;
                PolicyDecision.DelayAndRetry delayAndRetry2 = PolicyDecision$DelayAndRetry$.MODULE$.unapply(delayAndRetry);
                FiniteDuration delay = finiteDuration = delayAndRetry2._1();
                PolicyDecision.DelayAndRetry r = delayAndRetry;
                if (delay.$greater((Object)threshold$1)) {
                    return PolicyDecision$.GiveUp;
                }
                return r;
            }
            PolicyDecision policyDecision2 = PolicyDecision$.GiveUp;
            PolicyDecision policyDecision3 = policyDecision;
            if (!(policyDecision2 != null ? !policyDecision2.equals(policyDecision3) : policyDecision3 != null)) {
                return PolicyDecision$.GiveUp;
            }
            throw new MatchError((Object)policyDecision);
        });
    }

    private static final String limitRetriesByDelay$$anonfun$2(FiniteDuration threshold$3, RetryPolicy policy$2) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetriesByDelay(threshold=", ", ", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)threshold$3, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)policy$2, RetryPolicy$.MODULE$.given_Show_RetryPolicy()))}));
    }

    private final Object decideNextRetry$2(RetryPolicy policy$3, Applicative evidence$1$3, FiniteDuration threshold$4, Object actionResult, RetryStatus status) {
        return package.functor$.MODULE$.toFunctorOps(policy$3.decideNextRetry().apply(actionResult, (Object)status), (Functor)evidence$1$3).map((Function1 & Serializable)x$1 -> {
            PolicyDecision policyDecision = x$1;
            if (policyDecision instanceof PolicyDecision.DelayAndRetry) {
                FiniteDuration finiteDuration;
                PolicyDecision.DelayAndRetry delayAndRetry = (PolicyDecision.DelayAndRetry)policyDecision;
                PolicyDecision.DelayAndRetry delayAndRetry2 = PolicyDecision$DelayAndRetry$.MODULE$.unapply(delayAndRetry);
                FiniteDuration delay = finiteDuration = delayAndRetry2._1();
                PolicyDecision.DelayAndRetry r = delayAndRetry;
                if (status.cumulativeDelay().$plus(delay).$greater$eq((Object)threshold$4)) {
                    return PolicyDecision$.GiveUp;
                }
                return r;
            }
            PolicyDecision policyDecision2 = PolicyDecision$.GiveUp;
            PolicyDecision policyDecision3 = policyDecision;
            if (!(policyDecision2 != null ? !policyDecision2.equals(policyDecision3) : policyDecision3 != null)) {
                return PolicyDecision$.GiveUp;
            }
            throw new MatchError((Object)policyDecision);
        });
    }

    private static final String limitRetriesByCumulativeDelay$$anonfun$2(FiniteDuration threshold$6, RetryPolicy policy$4) {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"limitRetriesByCumulativeDelay(threshold=", ", ", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)threshold$6, (Show.ContravariantShow)Show$.MODULE$.catsShowForDuration())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)policy$4, RetryPolicy$.MODULE$.given_Show_RetryPolicy()))}));
    }

    private final Object decideNextRetry$3(Function1 f$1, Object actionResult, RetryStatus status) {
        RetryPolicy policy = (RetryPolicy)f$1.apply(actionResult);
        return policy.decideNextRetry().apply(actionResult, (Object)status);
    }

    private static final String dynamic$$anonfun$2() {
        return Show.ShowInterpolator$.MODULE$.show$extension(package.show$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dynamic(<function>)"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[0]));
    }
}

