/*
 * Decompiled with CFR 0.152.
 */
package scalacache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.AbstractCache;
import scalacache.CacheAlg;
import scalacache.CacheConfig;
import scalacache.Entry;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;
import scalacache.caffeine.CaffeineCache$;
import scalacache.logging.Logger;
import scalacache.logging.Logger$;

@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\u000b\u0017\u0001mA\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005i!A\u0001\u000b\u0001BC\u0002\u0013\r\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003S\u0011!1\u0006A!A!\u0002\u00179\u0006\"B0\u0001\t\u0003\u0001\u0007bB4\u0001\u0005\u0004%)\u0006\u001b\u0005\u0007_\u0002\u0001\u000bQB5\t\u000bA\u0004A\u0011A9\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007;q!!$\u0017\u0011\u0003\tyI\u0002\u0004\u0016-!\u0005\u0011\u0011\u0013\u0005\u0007?B!\t!a%\t\u000f\u0005U\u0005\u0003\"\u0001\u0002\u0018\"9\u0011Q\u0013\t\u0005\u0002\u0005\r\u0006\"CA\\!E\u0005I\u0011AA]\u00055\u0019\u0015M\u001a4fS:,7)Y2iK*\u0011q\u0003G\u0001\tG\u00064g-Z5oK*\t\u0011$\u0001\u0006tG\u0006d\u0017mY1dQ\u0016\u001c\u0001!\u0006\u0002\u001dSM\u0019\u0001!H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g!\r!SeJ\u0007\u00021%\u0011a\u0005\u0007\u0002\u000e\u0003\n\u001cHO]1di\u000e\u000b7\r[3\u0011\u0005!JC\u0002\u0001\u0003\u0006U\u0001\u0011\ra\u000b\u0002\u0002-F\u0011Af\f\t\u0003=5J!AL\u0010\u0003\u000f9{G\u000f[5oOB\u0011a\u0004M\u0005\u0003c}\u00111!\u00118z\u0003))h\u000eZ3sYfLgnZ\u000b\u0002iA!QgP!M\u001b\u00051$BA\u001c9\u0003\u0015\u0019\u0017m\u00195f\u0015\t9\u0012H\u0003\u0002;w\u0005A!-\u001a8nC:,7O\u0003\u0002={\u00051q-\u001b;ik\nT\u0011AP\u0001\u0004G>l\u0017B\u0001!7\u0005\u0015\u0019\u0015m\u00195f!\t\u0011\u0015J\u0004\u0002D\u000fB\u0011AiH\u0007\u0002\u000b*\u0011aIG\u0001\u0007yI|w\u000e\u001e \n\u0005!{\u0012A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001S\u0010\u0011\u0007\u0011ju%\u0003\u0002O1\t)QI\u001c;ss\u0006YQO\u001c3fe2L\u0018N\\4!\u0003\u0019\u0019wN\u001c4jOV\t!\u000b\u0005\u0002%'&\u0011A\u000b\u0007\u0002\f\u0007\u0006\u001c\u0007.Z\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u000b\rdwnY6\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001\u0002;j[\u0016T\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\n)1\t\\8dW\u00061A(\u001b8jiz\"\"!\u00194\u0015\u0007\t$W\rE\u0002d\u0001\u001dj\u0011A\u0006\u0005\u0006!\u001a\u0001\u001dA\u0015\u0005\b-\u001a\u0001\n\u0011q\u0001X\u0011\u0015\u0011d\u00011\u00015\u0003\u0019awnZ4feV\t\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002m1\u00059An\\4hS:<\u0017B\u00018l\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!\u00023p\u000f\u0016$XC\u0001:v)\r\u0019\u0018q\u0001\u000b\u0003iv\u00042\u0001K;{\t\u00151\u0018B1\u0001x\u0005\u00051UCA\u0016y\t\u0015IXO1\u0001,\u0005\u0005y\u0006c\u0001\u0010|O%\u0011Ap\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000byL\u00019A@\u0002\t5|G-\u001a\t\u0006I\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007A\"\u0001B'pI\u0016\u0004\"\u0001K;\t\r\u0005%\u0011\u00021\u0001B\u0003\rYW-_\u0001\u0006I>\u0004V\u000f^\u000b\u0005\u0003\u001f\t)\u0002\u0006\u0005\u0002\u0012\u0005\u0005\u00121EA\u0014)\u0011\t\u0019\"a\u0007\u0011\t!\n)b\f\u0003\u0007m*\u0011\r!a\u0006\u0016\u0007-\nI\u0002\u0002\u0004z\u0003+\u0011\ra\u000b\u0005\u0007}*\u0001\u001d!!\b\u0011\u000b\u0011\n\t!a\b\u0011\u0007!\n)\u0002\u0003\u0004\u0002\n)\u0001\r!\u0011\u0005\u0007\u0003KQ\u0001\u0019A\u0014\u0002\u000bY\fG.^3\t\u000f\u0005%\"\u00021\u0001\u0002,\u0005\u0019A\u000f\u001e7\u0011\tyY\u0018Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003!!WO]1uS>t'bAA\u001c?\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0012\u0011\u0007\u0002\t\tV\u0014\u0018\r^5p]\u0006AAm\u001c*f[>4X-\u0006\u0003\u0002B\u0005\u001dC\u0003BA\"\u0003'\"B!!\u0012\u0002NA!\u0001&a\u00120\t\u001918B1\u0001\u0002JU\u00191&a\u0013\u0005\re\f9E1\u0001,\u0011\u0019q8\u0002q\u0001\u0002PA)A%!\u0001\u0002RA\u0019\u0001&a\u0012\t\r\u0005%1\u00021\u0001B\u0003-!wNU3n_Z,\u0017\t\u001c7\u0016\t\u0005e\u0013q\f\u000b\u0003\u00037\"B!!\u0018\u0002fA!\u0001&a\u00180\t\u00191HB1\u0001\u0002bU\u00191&a\u0019\u0005\re\fyF1\u0001,\u0011\u0019qH\u0002q\u0001\u0002hA)A%!\u0001\u0002jA\u0019\u0001&a\u0018\u0002\u000b\rdwn]3\u0016\t\u0005=\u0014Q\u000f\u000b\u0003\u0003c\"B!a\u001d\u0002|A!\u0001&!\u001e0\t\u00191XB1\u0001\u0002xU\u00191&!\u001f\u0005\re\f)H1\u0001,\u0011\u0019qX\u0002q\u0001\u0002~A)A%!\u0001\u0002\u0000A\u0019\u0001&!\u001e\u0002\u0019Q|W\t\u001f9jef$\u0016.\\3\u0015\t\u0005\u0015\u00151\u0012\t\u00041\u0006\u001d\u0015bAAE3\n9\u0011J\\:uC:$\bbBA\u0015\u001d\u0001\u0007\u0011QF\u0001\u000e\u0007\u00064g-Z5oK\u000e\u000b7\r[3\u0011\u0005\r\u00042C\u0001\t\u001e)\t\ty)A\u0003baBd\u00170\u0006\u0003\u0002\u001a\u0006}E\u0003BAN\u0003C\u0003Ba\u0019\u0001\u0002\u001eB\u0019\u0001&a(\u0005\u000b)\u0012\"\u0019A\u0016\t\u000bA\u0013\u00029\u0001*\u0016\t\u0005\u0015\u0016Q\u0016\u000b\u0005\u0003O\u000b\t\f\u0006\u0003\u0002*\u0006=\u0006\u0003B2\u0001\u0003W\u00032\u0001KAW\t\u0015Q3C1\u0001,\u0011\u0015\u00016\u0003q\u0001S\u0011\u0019\u00114\u00031\u0001\u00024B)QgP!\u00026B!A%TAV\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU!\u00111XAm)\u0011\ti,!5+\u0007]\u000byl\u000b\u0002\u0002BB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017!C;oG\",7m[3e\u0015\r\tYmH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAh\u0003\u000b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u0019\u0011D\u00031\u0001\u0002TB)QgP!\u0002VB!A%TAl!\rA\u0013\u0011\u001c\u0003\u0006UQ\u0011\ra\u000b")
public class CaffeineCache<V>
implements AbstractCache<V> {
    private final Cache<String, Entry<V>> underlying;
    private final CacheConfig config;
    private final Clock clock;
    private final Logger logger;

    public static <V> Clock $lessinit$greater$default$3(Cache<String, Entry<V>> cache) {
        return CaffeineCache$.MODULE$.$lessinit$greater$default$3(cache);
    }

    public static <V> CaffeineCache<V> apply(Cache<String, Entry<V>> cache, CacheConfig cacheConfig) {
        return CaffeineCache$.MODULE$.apply(cache, cacheConfig);
    }

    public static <V> CaffeineCache<V> apply(CacheConfig cacheConfig) {
        return CaffeineCache$.MODULE$.apply(cacheConfig);
    }

    public final <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.get$((AbstractCache)this, keyParts, mode, (Flags)flags);
    }

    public final <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.put$((AbstractCache)this, keyParts, value, ttl, mode, (Flags)flags);
    }

    public final <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return (F)AbstractCache.remove$((AbstractCache)this, keyParts, mode);
    }

    public final <F> F removeAll(Mode<F> mode) {
        return (F)AbstractCache.removeAll$((AbstractCache)this, mode);
    }

    public final <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.caching$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public final <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return AbstractCache.caching$default$2$((AbstractCache)this, keyParts);
    }

    public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingF$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return AbstractCache.cachingF$default$2$((AbstractCache)this, keyParts);
    }

    public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoize$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return AbstractCache.cachingForMemoize$default$2$((AbstractCache)this, (String)baseKey);
    }

    public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoizeF$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public <F> Option<Duration> put$default$3(Seq<Object> keyParts) {
        return CacheAlg.put$default$3$((CacheAlg)this, keyParts);
    }

    public Cache<String, Entry<V>> underlying() {
        return this.underlying;
    }

    public CacheConfig config() {
        return this.config;
    }

    public final Logger logger() {
        return this.logger;
    }

    public <F> F doGet(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0 & Serializable)() -> {
            void var3_3;
            Entry entry = (Entry)this.underlying().getIfPresent((Object)key);
            None$ result = entry == null || entry.isExpired($this.clock) ? None$.MODULE$ : new Some(entry.value());
            this.logCacheHitOrMiss(key, (Option)result);
            return var3_3;
        });
    }

    public <F> F doPut(String key, V value, Option<Duration> ttl, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Entry entry = new Entry(value, ttl.map((Function1 & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
            this.underlying().put((Object)key, (Object)entry);
            this.logCachePut(key, ttl);
        });
    }

    public <F> F doRemove(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & Serializable)() -> this.underlying().invalidate((Object)key));
    }

    public <F> F doRemoveAll(Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & Serializable)() -> this.underlying().invalidateAll());
    }

    public <F> F close(Mode<F> mode) {
        return (F)mode.M().pure((Object)BoxedUnit.UNIT);
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public CaffeineCache(Cache<String, Entry<V>> underlying, CacheConfig config, Clock clock) {
        this.underlying = underlying;
        this.config = config;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        AbstractCache.$init$((AbstractCache)this);
        this.logger = Logger$.MODULE$.getLogger(this.getClass().getName());
    }
}

