/*
 * Decompiled with CFR 0.152.
 */
package scalacache.guava;

import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scalacache.Cache;
import scalacache.Entry;
import scalacache.LoggingSupport;
import scalacache.guava.GuavaCache$;
import scalacache.serialization.Codec;
import scalacache.serialization.InMemoryRepr;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001\u001d\u0011!bR;bm\u0006\u001c\u0015m\u00195f\u0015\t\u0019A!A\u0003hk\u00064\u0018MC\u0001\u0006\u0003)\u00198-\u00197bG\u0006\u001c\u0007.Z\u0002\u0001'\u0011\u0001\u0001B\u0004\r\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\tQb]3sS\u0006d\u0017N_1uS>t\u0017BA\f\u0015\u00051Ie.T3n_JL(+\u001a9s!\ty\u0011$\u0003\u0002\u001b\t\tqAj\\4hS:<7+\u001e9q_J$\b\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u0015UtG-\u001a:ms&tw\r\u0005\u0003\u001fO!\u001aT\"A\u0010\u000b\u0005\u0001\n\u0013!B2bG\",'B\u0001\u0012$\u0003\u0019\u0019w.\\7p]*\u0011A%J\u0001\u0007O>|w\r\\3\u000b\u0003\u0019\n1aY8n\u0013\t\tr\u0004\u0005\u0002*a9\u0011!F\f\t\u0003W)i\u0011\u0001\f\u0006\u0003[\u0019\ta\u0001\u0010:p_Rt\u0014BA\u0018\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=R\u0001C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011a\u0017M\\4\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0007\u001f\nTWm\u0019;\t\u0011q\u0002!\u0011!Q\u0001\fu\nQa\u00197pG.\u0004\"AP!\u000e\u0003}R!\u0001Q\u001c\u0002\tQLW.Z\u0005\u0003\u0005~\u0012Qa\u00117pG.DQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtDC\u0001$K)\t9\u0015\n\u0005\u0002I\u00015\t!\u0001C\u0004=\u0007B\u0005\t9A\u001f\t\u000bq\u0019\u0005\u0019A\u000f\t\u000f1\u0003!\u0019!C+\u001b\u00061An\\4hKJ,\u0012A\u0014\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000bQa\u001d7gi)T\u0011aU\u0001\u0004_J<\u0017BA+Q\u0005\u0019aunZ4fe\"1q\u000b\u0001Q\u0001\u000e9\u000bq\u0001\\8hO\u0016\u0014\b\u0005C\u0003Z\u0001\u0011\u0005#,A\u0002hKR,\"a\u00175\u0015\u0005q3HCA/r!\rq\u0016mY\u0007\u0002?*\u0011\u0001MC\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00012`\u0005\u00191U\u000f^;sKB\u0019\u0011\u0002\u001a4\n\u0005\u0015T!AB(qi&|g\u000e\u0005\u0002hQ2\u0001A!B5Y\u0005\u0004Q'!\u0001,\u0012\u0005-t\u0007CA\u0005m\u0013\ti'BA\u0004O_RD\u0017N\\4\u0011\u0005%y\u0017B\u00019\u000b\u0005\r\te.\u001f\u0005\u0006eb\u0003\u001da]\u0001\u0006G>$Wm\u0019\t\u0005'Q4'#\u0003\u0002v)\t)1i\u001c3fG\")q\u000f\u0017a\u0001Q\u0005\u00191.Z=\t\u000be\u0004A\u0011\t>\u0002\u0007A,H/F\u0002|\u0003\u0013!r\u0001`A\u0006\u0003\u001b\t\t\u0002F\u0002~\u0003\u0007\u00012AX1\u007f!\tIq0C\u0002\u0002\u0002)\u0011A!\u00168ji\"1!\u000f\u001fa\u0002\u0003\u000b\u0001Ra\u0005;\u0002\bI\u00012aZA\u0005\t\u0015I\u0007P1\u0001k\u0011\u00159\b\u00101\u0001)\u0011\u001d\ty\u0001\u001fa\u0001\u0003\u000f\tQA^1mk\u0016Dq!a\u0005y\u0001\u0004\t)\"A\u0002ui2\u0004B!\u00033\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e}\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0003C\tYB\u0001\u0005EkJ\fG/[8o\u0011\u001d\t)\u0003\u0001C!\u0003O\taA]3n_Z,GcA?\u0002*!1q/a\tA\u0002!Bq!!\f\u0001\t\u0003\ny#A\u0005sK6|g/Z!mYR\tQ\u0010C\u0004\u00024\u0001!\t%!\u000e\u0002\u000b\rdwn]3\u0015\u0003yDq!!\u000f\u0001\t\u0013\tY$\u0001\u0007u_\u0016C\b/\u001b:z)&lW\r\u0006\u0003\u0002>\u0005\r\u0003c\u0001 \u0002@%\u0019\u0011\u0011I \u0003\u000f%s7\u000f^1oi\"A\u00111CA\u001c\u0001\u0004\t9bB\u0004\u0002H\tA\t!!\u0013\u0002\u0015\u001d+\u0018M^1DC\u000eDW\rE\u0002I\u0003\u00172a!\u0001\u0002\t\u0002\u000553cAA&\u0011!9A)a\u0013\u0005\u0002\u0005ECCAA%\u0011!\t)&a\u0013\u0005\u0002\u0005]\u0013!B1qa2LH#A$\t\u0011\u0005U\u00131\nC\u0001\u00037\"2aRA/\u0011\u0019a\u0012\u0011\fa\u0001;!Q\u0011\u0011MA&#\u0003%\t!a\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133)\u0011\t)'!\u001f+\u0007u\n9g\u000b\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014!C;oG\",7m[3e\u0015\r\t\u0019HC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA<\u0003[\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u0019a\u0012q\fa\u0001;\u0001")
public class GuavaCache
implements Cache<InMemoryRepr>,
LoggingSupport {
    private final com.google.common.cache.Cache<String, Object> underlying;
    private final Clock clock;
    private final Logger logger;

    public static Clock $lessinit$greater$default$2(com.google.common.cache.Cache<String, Object> cache) {
        return GuavaCache$.MODULE$.$lessinit$greater$default$2(cache);
    }

    public static GuavaCache apply(com.google.common.cache.Cache<String, Object> cache) {
        return GuavaCache$.MODULE$.apply(cache);
    }

    public static GuavaCache apply() {
        return GuavaCache$.MODULE$.apply();
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public final Logger logger() {
        return this.logger;
    }

    public <V> Future<Option<V>> get(String key, Codec<V, InMemoryRepr> codec) {
        Entry entry;
        Object baseValue = this.underlying.getIfPresent((Object)key);
        None$ result = baseValue != null ? ((entry = (Entry)baseValue).isExpired(this.clock) ? None$.MODULE$ : new Some(entry.value())) : None$.MODULE$;
        this.logCacheHitOrMiss(key, (Option)result);
        return Future$.MODULE$.successful((Object)result);
    }

    public <V> Future<BoxedUnit> put(String key, V value, Option<Duration> ttl2, Codec<V, InMemoryRepr> codec) {
        Entry entry = new Entry(value, ttl2.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
        this.underlying.put((Object)key, (Object)entry);
        this.logCachePut(key, ttl2);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public Future<BoxedUnit> remove(String key) {
        this.underlying.invalidate((Object)key);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public Future<BoxedUnit> removeAll() {
        this.underlying.invalidateAll();
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void close() {
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public GuavaCache(com.google.common.cache.Cache<String, Object> underlying, Clock clock) {
        this.underlying = underlying;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

