/*
 * Decompiled with CFR 0.152.
 */
package scalacache.guava;

import com.google.common.cache.Cache;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.AbstractCache;
import scalacache.CacheAlg;
import scalacache.CacheConfig;
import scalacache.Entry;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;
import scalacache.guava.GuavaCache$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001\u001d\u0011!bR;bm\u0006\u001c\u0015m\u00195f\u0015\t\u0019A!A\u0003hk\u00064\u0018MC\u0001\u0006\u0003)\u00198-\u00197bG\u0006\u001c\u0007.Z\u0002\u0001+\tAQcE\u0002\u0001\u0013=\u0001\"AC\u0007\u000e\u0003-Q\u0011\u0001D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d-\u0011a!\u00118z%\u00164\u0007c\u0001\t\u0012'5\tA!\u0003\u0002\u0013\t\ti\u0011IY:ue\u0006\u001cGoQ1dQ\u0016\u0004\"\u0001F\u000b\r\u0001\u0011)a\u0003\u0001b\u0001/\t\ta+\u0005\u0002\u00197A\u0011!\"G\u0005\u00035-\u0011qAT8uQ&tw\r\u0005\u0002\u000b9%\u0011Qd\u0003\u0002\u0004\u0003:L\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u0015UtG-\u001a:ms&tw\r\u0005\u0003\"U1:T\"\u0001\u0012\u000b\u0005\r\"\u0013!B2bG\",'BA\u0013'\u0003\u0019\u0019w.\\7p]*\u0011q\u0005K\u0001\u0007O>|w\r\\3\u000b\u0003%\n1aY8n\u0013\tY#EA\u0003DC\u000eDW\r\u0005\u0002.i9\u0011aF\r\t\u0003_-i\u0011\u0001\r\u0006\u0003c\u0019\ta\u0001\u0010:p_Rt\u0014BA\u001a\f\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005MZ\u0001c\u0001\t9'%\u0011\u0011\b\u0002\u0002\u0006\u000b:$(/\u001f\u0005\tw\u0001\u0011)\u0019!C\u0002y\u000511m\u001c8gS\u001e,\u0012!\u0010\t\u0003!yJ!a\u0010\u0003\u0003\u0017\r\u000b7\r[3D_:4\u0017n\u001a\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\"\u0001\u0005\u0003\u0005\u000b1\u0002#\u0002\u000b\rdwnY6\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u0002;j[\u0016T\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n)1\t\\8dW\")Q\n\u0001C\u0001\u001d\u00061A(\u001b8jiz\"\"a\u0014+\u0015\u0007A\u00136\u000bE\u0002R\u0001Mi\u0011A\u0001\u0005\u0006w1\u0003\u001d!\u0010\u0005\b\u00072\u0003\n\u0011q\u0001E\u0011\u0015yB\n1\u0001!\u0011\u001d1\u0006A1A\u0005V]\u000ba\u0001\\8hO\u0016\u0014X#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016!B:mMRR'\"A/\u0002\u0007=\u0014x-\u0003\u0002`5\n1Aj\\4hKJDa!\u0019\u0001!\u0002\u001bA\u0016a\u00027pO\u001e,'\u000f\t\u0005\u0006G\u0002!\t\u0001Z\u0001\u0006I><U\r^\u000b\u0003K\"$\"A\u001a<\u0015\u0005\u001d\u0004\bc\u0001\u000bi[\u0012)\u0011N\u0019b\u0001U\n\ta)\u0006\u0002\u0018W\u0012)A\u000e\u001bb\u0001/\t\tq\fE\u0002\u000b]NI!a\\\u0006\u0003\r=\u0003H/[8o\u0011\u0015\t(\rq\u0001s\u0003\u0011iw\u000eZ3\u0011\u0007A\u0019X/\u0003\u0002u\t\t!Qj\u001c3f!\t!\u0002\u000eC\u0003xE\u0002\u0007A&A\u0002lKfDQ!\u001f\u0001\u0005\u0002i\fQ\u0001Z8QkR,\"a\u001f@\u0015\u000fq\fI!a\u0003\u0002\u0010Q\u0019Q0a\u0001\u0011\u0007Qq8\u0004B\u0003jq\n\u0007q0F\u0002\u0018\u0003\u0003!Q\u0001\u001c@C\u0002]Aa!\u001d=A\u0004\u0005\u0015\u0001\u0003\u0002\tt\u0003\u000f\u0001\"\u0001\u0006@\t\u000b]D\b\u0019\u0001\u0017\t\r\u00055\u0001\u00101\u0001\u0014\u0003\u00151\u0018\r\\;f\u0011\u001d\t\t\u0002\u001fa\u0001\u0003'\t1\u0001\u001e;m!\u0011Qa.!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005AA-\u001e:bi&|gNC\u0002\u0002 -\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\u0019#!\u0007\u0003\u0011\u0011+(/\u0019;j_:Dq!a\n\u0001\t\u0003\nI#\u0001\u0005e_J+Wn\u001c<f+\u0011\tY#!\r\u0015\t\u00055\u0012Q\b\u000b\u0005\u0003_\t9\u0004\u0005\u0003\u0015\u0003cYBaB5\u0002&\t\u0007\u00111G\u000b\u0004/\u0005UBA\u00027\u00022\t\u0007q\u0003C\u0004r\u0003K\u0001\u001d!!\u000f\u0011\tA\u0019\u00181\b\t\u0004)\u0005E\u0002BB<\u0002&\u0001\u0007A\u0006C\u0004\u0002B\u0001!\t%a\u0011\u0002\u0017\u0011|'+Z7pm\u0016\fE\u000e\\\u000b\u0005\u0003\u000b\nY\u0005\u0006\u0002\u0002HQ!\u0011\u0011JA)!\u0011!\u00121J\u000e\u0005\u000f%\fyD1\u0001\u0002NU\u0019q#a\u0014\u0005\r1\fYE1\u0001\u0018\u0011\u001d\t\u0018q\ba\u0002\u0003'\u0002B\u0001E:\u0002VA\u0019A#a\u0013\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\\u0005)1\r\\8tKV!\u0011QLA2)\t\ty\u0006\u0006\u0003\u0002b\u0005%\u0004\u0003\u0002\u000b\u0002dm!q![A,\u0005\u0004\t)'F\u0002\u0018\u0003O\"a\u0001\\A2\u0005\u00049\u0002bB9\u0002X\u0001\u000f\u00111\u000e\t\u0005!M\fi\u0007E\u0002\u0015\u0003GBq!!\u001d\u0001\t\u0013\t\u0019(\u0001\u0007u_\u0016C\b/\u001b:z)&lW\r\u0006\u0003\u0002v\u0005m\u0004cA#\u0002x%\u0019\u0011\u0011\u0010$\u0003\u000f%s7\u000f^1oi\"A\u0011\u0011CA8\u0001\u0004\t)bB\u0004\u0002\u0000\tA\t!!!\u0002\u0015\u001d+\u0018M^1DC\u000eDW\rE\u0002R\u0003\u00073a!\u0001\u0002\t\u0002\u0005\u00155cAAB\u0013!9Q*a!\u0005\u0002\u0005%ECAAA\u0011!\ti)a!\u0005\u0002\u0005=\u0015!B1qa2LX\u0003BAI\u0003/#B!a%\u0002\u001aB!\u0011\u000bAAK!\r!\u0012q\u0013\u0003\u0007-\u0005-%\u0019A\f\t\rm\nY\tq\u0001>\u0011!\ti)a!\u0005\u0002\u0005uU\u0003BAP\u0003O#B!!)\u0002,R!\u00111UAU!\u0011\t\u0006!!*\u0011\u0007Q\t9\u000b\u0002\u0004\u0017\u00037\u0013\ra\u0006\u0005\u0007w\u0005m\u00059A\u001f\t\u000f}\tY\n1\u0001\u0002.B)\u0011E\u000b\u0017\u00020B!\u0001\u0003OAS\u0011)\t\u0019,a!\u0012\u0002\u0013\u0005\u0011QW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005]\u0016Q\u001b\u000b\u0005\u0003s\u000biMK\u0002E\u0003w[#!!0\u0011\t\u0005}\u0016\u0011Z\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f\\\u0011AC1o]>$\u0018\r^5p]&!\u00111ZAa\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b?\u0005E\u0006\u0019AAh!\u0015\t#\u0006LAi!\u0011\u0001\u0002(a5\u0011\u0007Q\t)\u000e\u0002\u0004\u0017\u0003c\u0013\ra\u0006")
public class GuavaCache<V>
implements AbstractCache<V> {
    private final Cache<String, Entry<V>> underlying;
    private final CacheConfig config;
    private final Clock clock;
    private final Logger logger;

    public static <V> Clock $lessinit$greater$default$3(Cache<String, Entry<V>> cache) {
        return GuavaCache$.MODULE$.$lessinit$greater$default$3(cache);
    }

    public static <V> GuavaCache<V> apply(Cache<String, Entry<V>> cache, CacheConfig cacheConfig) {
        return GuavaCache$.MODULE$.apply(cache, cacheConfig);
    }

    public static <V> GuavaCache<V> apply(CacheConfig cacheConfig) {
        return GuavaCache$.MODULE$.apply(cacheConfig);
    }

    public final <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.get$((AbstractCache)this, keyParts, mode, (Flags)flags);
    }

    public final <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.put$((AbstractCache)this, keyParts, value, ttl, mode, (Flags)flags);
    }

    public final <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return (F)AbstractCache.remove$((AbstractCache)this, keyParts, mode);
    }

    public final <F> F removeAll(Mode<F> mode) {
        return (F)AbstractCache.removeAll$((AbstractCache)this, mode);
    }

    public final <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.caching$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingF$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoize$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoizeF$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public final <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return AbstractCache.caching$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return AbstractCache.cachingF$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return AbstractCache.cachingForMemoize$default$2$((AbstractCache)this, (String)baseKey);
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public <F> Option<Duration> put$default$3(Seq<Object> keyParts) {
        return CacheAlg.put$default$3$((CacheAlg)this, keyParts);
    }

    public CacheConfig config() {
        return this.config;
    }

    public final Logger logger() {
        return this.logger;
    }

    public <F> F doGet(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0 & java.io.Serializable & Serializable)() -> {
            void var3_4;
            Entry entry;
            Entry baseValue = (Entry)$this.underlying.getIfPresent((Object)key);
            None$ result = baseValue != null ? ((entry = baseValue).isExpired($this.clock) ? None$.MODULE$ : new Some(entry.value())) : None$.MODULE$;
            this.logCacheHitOrMiss(key, (Option)result);
            return var3_4;
        });
    }

    public <F> F doPut(String key, V value, Option<Duration> ttl, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Entry entry = new Entry(value, ttl.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
            $this.underlying.put((Object)key, (Object)entry);
            this.logCachePut(key, ttl);
        });
    }

    public <F> F doRemove(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> $this.underlying.invalidate((Object)key));
    }

    public <F> F doRemoveAll(Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> $this.underlying.invalidateAll());
    }

    public <F> F close(Mode<F> mode) {
        return (F)mode.M().pure((Object)BoxedUnit.UNIT);
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public GuavaCache(Cache<String, Entry<V>> underlying, CacheConfig config, Clock clock) {
        this.underlying = underlying;
        this.config = config;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        AbstractCache.$init$((AbstractCache)this);
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

