/*
 * Decompiled with CFR 0.152.
 */
package scalacache.guava;

import com.google.common.cache.Cache;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.AbstractCache;
import scalacache.CacheAlg;
import scalacache.CacheConfig;
import scalacache.Entry;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;
import scalacache.guava.GuavaCache$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u0001\u001d\u0011!bR;bm\u0006\u001c\u0015m\u00195f\u0015\t\u0019A!A\u0003hk\u00064\u0018MC\u0001\u0006\u0003)\u00198-\u00197bG\u0006\u001c\u0007.Z\u0002\u0001+\tAQcE\u0002\u0001\u0013=\u0001\"AC\u0007\u000e\u0003-Q\u0011\u0001D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d-\u0011a!\u00118z%\u00164\u0007c\u0001\t\u0012'5\tA!\u0003\u0002\u0013\t\ti\u0011IY:ue\u0006\u001cGoQ1dQ\u0016\u0004\"\u0001F\u000b\r\u0001\u0011)a\u0003\u0001b\u0001/\t\ta+\u0005\u0002\u00197A\u0011!\"G\u0005\u00035-\u0011qAT8uQ&tw\r\u0005\u0002\u000b9%\u0011Qd\u0003\u0002\u0004\u0003:L\b\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\u0015UtG-\u001a:ms&tw-F\u0001\"!\u0011\u00113&\f\u001d\u000e\u0003\rR!\u0001J\u0013\u0002\u000b\r\f7\r[3\u000b\u0005\u0019:\u0013AB2p[6|gN\u0003\u0002)S\u00051qm\\8hY\u0016T\u0011AK\u0001\u0004G>l\u0017B\u0001\u0017$\u0005\u0015\u0019\u0015m\u00195f!\tqSG\u0004\u00020gA\u0011\u0001gC\u0007\u0002c)\u0011!GB\u0001\u0007yI|w\u000e\u001e \n\u0005QZ\u0011A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001N\u0006\u0011\u0007AI4#\u0003\u0002;\t\t)QI\u001c;ss\"AA\b\u0001B\u0001B\u0003%\u0011%A\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\u0003\u0002\u0003 \u0001\u0005\u000b\u0007I1A \u0002\r\r|gNZ5h+\u0005\u0001\u0005C\u0001\tB\u0013\t\u0011EAA\u0006DC\u000eDWmQ8oM&<\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\u0002\u000f\r|gNZ5hA!Aa\t\u0001B\u0001B\u0003-q)A\u0003dY>\u001c7\u000e\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!A/[7f\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\u000b\rcwnY6\t\u000bA\u0003A\u0011A)\u0002\rqJg.\u001b;?)\t\u0011v\u000bF\u0002T+Z\u00032\u0001\u0016\u0001\u0014\u001b\u0005\u0011\u0001\"\u0002 P\u0001\b\u0001\u0005b\u0002$P!\u0003\u0005\u001da\u0012\u0005\u0006?=\u0003\r!\t\u0005\b3\u0002\u0011\r\u0011\"\u0016[\u0003\u0019awnZ4feV\t1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006)1\u000f\u001c45U*\t\u0001-A\u0002pe\u001eL!AY/\u0003\r1{wmZ3s\u0011\u0019!\u0007\u0001)A\u00077\u00069An\\4hKJ\u0004\u0003\"\u00024\u0001\t\u00039\u0017!\u00023p\u000f\u0016$XC\u00015l)\tI\u0017\u0010\u0006\u0002kgB\u0019Ac\u001b9\u0005\u000b1,'\u0019A7\u0003\u0003\u0019+\"a\u00068\u0005\u000b=\\'\u0019A\f\u0003\u0003}\u00032AC9\u0014\u0013\t\u00118B\u0001\u0004PaRLwN\u001c\u0005\u0006i\u0016\u0004\u001d!^\u0001\u0005[>$W\rE\u0002\u0011mbL!a\u001e\u0003\u0003\t5{G-\u001a\t\u0003)-DQA_3A\u00025\n1a[3z\u0011\u0015a\b\u0001\"\u0001~\u0003\u0015!w\u000eU;u+\rq\u00181\u0001\u000b\b\u007f\u0006=\u0011\u0011CA\u000b)\u0011\t\t!!\u0003\u0011\tQ\t\u0019a\u0007\u0003\u0007Yn\u0014\r!!\u0002\u0016\u0007]\t9\u0001\u0002\u0004p\u0003\u0007\u0011\ra\u0006\u0005\u0007in\u0004\u001d!a\u0003\u0011\tA1\u0018Q\u0002\t\u0004)\u0005\r\u0001\"\u0002>|\u0001\u0004i\u0003BBA\nw\u0002\u00071#A\u0003wC2,X\rC\u0004\u0002\u0018m\u0004\r!!\u0007\u0002\u0007Q$H\u000e\u0005\u0003\u000bc\u0006m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\tIV\u0014\u0018\r^5p]*\u0019\u0011QE\u0006\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002*\u0005}!\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000f\u00055\u0002\u0001\"\u0011\u00020\u0005AAm\u001c*f[>4X-\u0006\u0003\u00022\u0005]B\u0003BA\u001a\u0003\u0007\"B!!\u000e\u0002>A!A#a\u000e\u001c\t\u001da\u00171\u0006b\u0001\u0003s)2aFA\u001e\t\u0019y\u0017q\u0007b\u0001/!9A/a\u000bA\u0004\u0005}\u0002\u0003\u0002\tw\u0003\u0003\u00022\u0001FA\u001c\u0011\u0019Q\u00181\u0006a\u0001[!9\u0011q\t\u0001\u0005B\u0005%\u0013a\u00033p%\u0016lwN^3BY2,B!a\u0013\u0002RQ\u0011\u0011Q\n\u000b\u0005\u0003\u001f\n9\u0006\u0005\u0003\u0015\u0003#ZBa\u00027\u0002F\t\u0007\u00111K\u000b\u0004/\u0005UCAB8\u0002R\t\u0007q\u0003C\u0004u\u0003\u000b\u0002\u001d!!\u0017\u0011\tA1\u00181\f\t\u0004)\u0005E\u0003bBA0\u0001\u0011\u0005\u0013\u0011M\u0001\u0006G2|7/Z\u000b\u0005\u0003G\nI\u0007\u0006\u0002\u0002fQ!\u0011qMA8!\u0011!\u0012\u0011N\u000e\u0005\u000f1\fiF1\u0001\u0002lU\u0019q#!\u001c\u0005\r=\fIG1\u0001\u0018\u0011\u001d!\u0018Q\fa\u0002\u0003c\u0002B\u0001\u0005<\u0002tA\u0019A#!\u001b\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z\u0005aAo\\#ya&\u0014\u0018\u0010V5nKR!\u00111PAA!\rA\u0015QP\u0005\u0004\u0003\u007fJ%aB%ogR\fg\u000e\u001e\u0005\t\u0003/\t)\b1\u0001\u0002\u001c\u001d9\u0011Q\u0011\u0002\t\u0002\u0005\u001d\u0015AC$vCZ\f7)Y2iKB\u0019A+!#\u0007\r\u0005\u0011\u0001\u0012AAF'\r\tI)\u0003\u0005\b!\u0006%E\u0011AAH)\t\t9\t\u0003\u0005\u0002\u0014\u0006%E\u0011AAK\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\t9*!(\u0015\t\u0005e\u0015q\u0014\t\u0005)\u0002\tY\nE\u0002\u0015\u0003;#aAFAI\u0005\u00049\u0002B\u0002 \u0002\u0012\u0002\u000f\u0001\t\u0003\u0005\u0002\u0014\u0006%E\u0011AAR+\u0011\t)+!,\u0015\t\u0005\u001d\u0016\u0011\u0017\u000b\u0005\u0003S\u000by\u000b\u0005\u0003U\u0001\u0005-\u0006c\u0001\u000b\u0002.\u00121a#!)C\u0002]AaAPAQ\u0001\b\u0001\u0005bB\u0010\u0002\"\u0002\u0007\u00111\u0017\t\u0006E-j\u0013Q\u0017\t\u0005!e\nY\u000b\u0003\u0006\u0002:\u0006%\u0015\u0013!C\u0001\u0003w\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT\u0003BA_\u00037$B!a0\u0002T*\u001aq)!1,\u0005\u0005\r\u0007\u0003BAc\u0003\u001fl!!a2\u000b\t\u0005%\u00171Z\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!4\f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\f9MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DqaHA\\\u0001\u0004\t)\u000eE\u0003#W5\n9\u000e\u0005\u0003\u0011s\u0005e\u0007c\u0001\u000b\u0002\\\u00121a#a.C\u0002]\u0001")
public class GuavaCache<V>
implements AbstractCache<V> {
    private final Cache<String, Entry<V>> underlying;
    private final CacheConfig config;
    private final Clock clock;
    private final Logger logger;

    public static <V> Clock $lessinit$greater$default$3(Cache<String, Entry<V>> cache) {
        return GuavaCache$.MODULE$.$lessinit$greater$default$3(cache);
    }

    public static <V> GuavaCache<V> apply(Cache<String, Entry<V>> cache, CacheConfig cacheConfig) {
        return GuavaCache$.MODULE$.apply(cache, cacheConfig);
    }

    public static <V> GuavaCache<V> apply(CacheConfig cacheConfig) {
        return GuavaCache$.MODULE$.apply(cacheConfig);
    }

    public final <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.get$((AbstractCache)this, keyParts, mode, (Flags)flags);
    }

    public final <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.put$((AbstractCache)this, keyParts, value, ttl, mode, (Flags)flags);
    }

    public final <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return (F)AbstractCache.remove$((AbstractCache)this, keyParts, mode);
    }

    public final <F> F removeAll(Mode<F> mode) {
        return (F)AbstractCache.removeAll$((AbstractCache)this, mode);
    }

    public final <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.caching$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingF$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoize$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoizeF$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public final <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return AbstractCache.caching$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return AbstractCache.cachingF$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return AbstractCache.cachingForMemoize$default$2$((AbstractCache)this, (String)baseKey);
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public <F> Option<Duration> put$default$3(Seq<Object> keyParts) {
        return CacheAlg.put$default$3$((CacheAlg)this, keyParts);
    }

    public Cache<String, Entry<V>> underlying() {
        return this.underlying;
    }

    public CacheConfig config() {
        return this.config;
    }

    public final Logger logger() {
        return this.logger;
    }

    public <F> F doGet(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0 & java.io.Serializable & Serializable)() -> {
            void var3_3;
            Entry entry = (Entry)this.underlying().getIfPresent((Object)key);
            None$ result = entry == null || entry.isExpired($this.clock) ? None$.MODULE$ : new Some(entry.value());
            this.logCacheHitOrMiss(key, (Option)result);
            return var3_3;
        });
    }

    public <F> F doPut(String key, V value, Option<Duration> ttl, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Entry entry = new Entry(value, ttl.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
            this.underlying().put((Object)key, (Object)entry);
            this.logCachePut(key, ttl);
        });
    }

    public <F> F doRemove(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.underlying().invalidate((Object)key));
    }

    public <F> F doRemoveAll(Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.underlying().invalidateAll());
    }

    public <F> F close(Mode<F> mode) {
        return (F)mode.M().pure((Object)BoxedUnit.UNIT);
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public GuavaCache(Cache<String, Entry<V>> underlying, CacheConfig config, Clock clock) {
        this.underlying = underlying;
        this.config = config;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        AbstractCache.$init$((AbstractCache)this);
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

