/*
 * Decompiled with CFR 0.152.
 */
package scalacache.guava;

import com.google.common.cache.Cache;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.AbstractCache;
import scalacache.CacheAlg;
import scalacache.CacheConfig;
import scalacache.Entry;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;
import scalacache.guava.GuavaCache$;
import scalacache.logging.Logger;
import scalacache.logging.Logger$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001\u001d\u0011!bR;bm\u0006\u001c\u0015m\u00195f\u0015\t\u0019A!A\u0003hk\u00064\u0018MC\u0001\u0006\u0003)\u00198-\u00197bG\u0006\u001c\u0007.Z\u0002\u0001+\tAQcE\u0002\u0001\u0013=\u0001\"AC\u0007\u000e\u0003-Q\u0011\u0001D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d-\u0011a!\u00118z%\u00164\u0007c\u0001\t\u0012'5\tA!\u0003\u0002\u0013\t\ti\u0011IY:ue\u0006\u001cGoQ1dQ\u0016\u0004\"\u0001F\u000b\r\u0001\u0011)a\u0003\u0001b\u0001/\t\ta+\u0005\u0002\u00197A\u0011!\"G\u0005\u00035-\u0011qAT8uQ&tw\r\u0005\u0002\u000b9%\u0011Qd\u0003\u0002\u0004\u0003:L\b\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\u0015UtG-\u001a:ms&tw-F\u0001\"!\u0011\u00113&\f\u001d\u000e\u0003\rR!\u0001J\u0013\u0002\u000b\r\f7\r[3\u000b\u0005\u0019:\u0013AB2p[6|gN\u0003\u0002)S\u00051qm\\8hY\u0016T\u0011AK\u0001\u0004G>l\u0017B\u0001\u0017$\u0005\u0015\u0019\u0015m\u00195f!\tqSG\u0004\u00020gA\u0011\u0001gC\u0007\u0002c)\u0011!GB\u0001\u0007yI|w\u000e\u001e \n\u0005QZ\u0011A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001N\u0006\u0011\u0007AI4#\u0003\u0002;\t\t)QI\u001c;ss\"AA\b\u0001B\u0001B\u0003%\u0011%A\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\u0003\u0002\u0003 \u0001\u0005\u000b\u0007I1A \u0002\r\r|gNZ5h+\u0005\u0001\u0005C\u0001\tB\u0013\t\u0011EAA\u0006DC\u000eDWmQ8oM&<\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\u0002\u000f\r|gNZ5hA!Aa\t\u0001B\u0001B\u0003-q)A\u0003dY>\u001c7\u000e\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!A/[7f\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\u000b\rcwnY6\t\u000bA\u0003A\u0011A)\u0002\rqJg.\u001b;?)\t\u0011v\u000bF\u0002T+Z\u00032\u0001\u0016\u0001\u0014\u001b\u0005\u0011\u0001\"\u0002 P\u0001\b\u0001\u0005b\u0002$P!\u0003\u0005\u001da\u0012\u0005\u0006?=\u0003\r!\t\u0005\b3\u0002\u0011\r\u0011\"\u0016[\u0003\u0019awnZ4feV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_\t\u00059An\\4hS:<\u0017B\u00011^\u0005\u0019aunZ4fe\"1!\r\u0001Q\u0001\u000em\u000bq\u0001\\8hO\u0016\u0014\b\u0005C\u0003e\u0001\u0011\u0005Q-A\u0003e_\u001e+G/\u0006\u0002gSR\u0011qm\u001e\u000b\u0003QF\u00042\u0001F5o\t\u0015Q7M1\u0001l\u0005\u00051UCA\fm\t\u0015i\u0017N1\u0001\u0018\u0005\u0005y\u0006c\u0001\u0006p'%\u0011\u0001o\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bI\u001c\u00079A:\u0002\t5|G-\u001a\t\u0004!Q4\u0018BA;\u0005\u0005\u0011iu\u000eZ3\u0011\u0005QI\u0007\"\u0002=d\u0001\u0004i\u0013aA6fs\")!\u0010\u0001C\u0001w\u0006)Am\u001c)viV\u0011Ap \u000b\b{\u0006-\u0011QBA\t)\rq\u0018Q\u0001\t\u0004)}\\BA\u00026z\u0005\u0004\t\t!F\u0002\u0018\u0003\u0007!Q!\\@C\u0002]AaA]=A\u0004\u0005\u001d\u0001\u0003\u0002\tu\u0003\u0013\u0001\"\u0001F@\t\u000baL\b\u0019A\u0017\t\r\u0005=\u0011\u00101\u0001\u0014\u0003\u00151\u0018\r\\;f\u0011\u001d\t\u0019\"\u001fa\u0001\u0003+\t1\u0001\u001e;m!\u0011Qq.a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005AA-\u001e:bi&|gNC\u0002\u0002\"-\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\t)#a\u0007\u0003\u0011\u0011+(/\u0019;j_:Dq!!\u000b\u0001\t\u0003\nY#\u0001\u0005e_J+Wn\u001c<f+\u0011\ti#a\r\u0015\t\u0005=\u0012q\b\u000b\u0005\u0003c\tI\u0004\u0005\u0003\u0015\u0003gYBa\u00026\u0002(\t\u0007\u0011QG\u000b\u0004/\u0005]BAB7\u00024\t\u0007q\u0003C\u0004s\u0003O\u0001\u001d!a\u000f\u0011\tA!\u0018Q\b\t\u0004)\u0005M\u0002B\u0002=\u0002(\u0001\u0007Q\u0006C\u0004\u0002D\u0001!\t%!\u0012\u0002\u0017\u0011|'+Z7pm\u0016\fE\u000e\\\u000b\u0005\u0003\u000f\ni\u0005\u0006\u0002\u0002JQ!\u00111JA*!\u0011!\u0012QJ\u000e\u0005\u000f)\f\tE1\u0001\u0002PU\u0019q#!\u0015\u0005\r5\fiE1\u0001\u0018\u0011\u001d\u0011\u0018\u0011\ta\u0002\u0003+\u0002B\u0001\u0005;\u0002XA\u0019A#!\u0014\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005)1\r\\8tKV!\u0011qLA3)\t\t\t\u0007\u0006\u0003\u0002d\u0005-\u0004\u0003\u0002\u000b\u0002fm!qA[A-\u0005\u0004\t9'F\u0002\u0018\u0003S\"a!\\A3\u0005\u00049\u0002b\u0002:\u0002Z\u0001\u000f\u0011Q\u000e\t\u0005!Q\fy\u0007E\u0002\u0015\u0003KBq!a\u001d\u0001\t\u0013\t)(\u0001\u0007u_\u0016C\b/\u001b:z)&lW\r\u0006\u0003\u0002x\u0005u\u0004c\u0001%\u0002z%\u0019\u00111P%\u0003\u000f%s7\u000f^1oi\"A\u00111CA9\u0001\u0004\t9bB\u0004\u0002\u0002\nA\t!a!\u0002\u0015\u001d+\u0018M^1DC\u000eDW\rE\u0002U\u0003\u000b3a!\u0001\u0002\t\u0002\u0005\u001d5cAAC\u0013!9\u0001+!\"\u0005\u0002\u0005-ECAAB\u0011!\ty)!\"\u0005\u0002\u0005E\u0015!B1qa2LX\u0003BAJ\u00033#B!!&\u0002\u001cB!A\u000bAAL!\r!\u0012\u0011\u0014\u0003\u0007-\u00055%\u0019A\f\t\ry\ni\tq\u0001A\u0011!\ty)!\"\u0005\u0002\u0005}U\u0003BAQ\u0003S#B!a)\u0002.R!\u0011QUAV!\u0011!\u0006!a*\u0011\u0007Q\tI\u000b\u0002\u0004\u0017\u0003;\u0013\ra\u0006\u0005\u0007}\u0005u\u00059\u0001!\t\u000f}\ti\n1\u0001\u00020B)!eK\u0017\u00022B!\u0001#OAT\u0011)\t),!\"\u0012\u0002\u0013\u0005\u0011qW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005e\u0016q\u001b\u000b\u0005\u0003w\u000byMK\u0002H\u0003{[#!a0\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013\\\u0011AC1o]>$\u0018\r^5p]&!\u0011QZAb\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b?\u0005M\u0006\u0019AAi!\u0015\u00113&LAj!\u0011\u0001\u0012(!6\u0011\u0007Q\t9\u000e\u0002\u0004\u0017\u0003g\u0013\ra\u0006")
public class GuavaCache<V>
implements AbstractCache<V> {
    private final Cache<String, Entry<V>> underlying;
    private final CacheConfig config;
    private final Clock clock;
    private final Logger logger;

    public static <V> Clock $lessinit$greater$default$3(Cache<String, Entry<V>> cache) {
        return GuavaCache$.MODULE$.$lessinit$greater$default$3(cache);
    }

    public static <V> GuavaCache<V> apply(Cache<String, Entry<V>> cache, CacheConfig cacheConfig) {
        return GuavaCache$.MODULE$.apply(cache, cacheConfig);
    }

    public static <V> GuavaCache<V> apply(CacheConfig cacheConfig) {
        return GuavaCache$.MODULE$.apply(cacheConfig);
    }

    public final <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.get$((AbstractCache)this, keyParts, mode, (Flags)flags);
    }

    public final <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.put$((AbstractCache)this, keyParts, value, ttl, mode, (Flags)flags);
    }

    public final <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return (F)AbstractCache.remove$((AbstractCache)this, keyParts, mode);
    }

    public final <F> F removeAll(Mode<F> mode) {
        return (F)AbstractCache.removeAll$((AbstractCache)this, mode);
    }

    public final <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.caching$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingF$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoize$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoizeF$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public final <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return AbstractCache.caching$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return AbstractCache.cachingF$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return AbstractCache.cachingForMemoize$default$2$((AbstractCache)this, (String)baseKey);
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public <F> Option<Duration> put$default$3(Seq<Object> keyParts) {
        return CacheAlg.put$default$3$((CacheAlg)this, keyParts);
    }

    public Cache<String, Entry<V>> underlying() {
        return this.underlying;
    }

    public CacheConfig config() {
        return this.config;
    }

    public final Logger logger() {
        return this.logger;
    }

    public <F> F doGet(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0 & java.io.Serializable & Serializable)() -> {
            void var3_3;
            Entry entry = (Entry)this.underlying().getIfPresent((Object)key);
            None$ result = entry == null || entry.isExpired($this.clock) ? None$.MODULE$ : new Some(entry.value());
            this.logCacheHitOrMiss(key, (Option)result);
            return var3_3;
        });
    }

    public <F> F doPut(String key, V value, Option<Duration> ttl, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Entry entry = new Entry(value, ttl.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
            this.underlying().put((Object)key, (Object)entry);
            this.logCachePut(key, ttl);
        });
    }

    public <F> F doRemove(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.underlying().invalidate((Object)key));
    }

    public <F> F doRemoveAll(Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.underlying().invalidateAll());
    }

    public <F> F close(Mode<F> mode) {
        return (F)mode.M().pure((Object)BoxedUnit.UNIT);
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public GuavaCache(Cache<String, Entry<V>> underlying, CacheConfig config, Clock clock) {
        this.underlying = underlying;
        this.config = config;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        AbstractCache.$init$((AbstractCache)this);
        this.logger = Logger$.MODULE$.getLogger(this.getClass().getName());
    }
}

