/*
 * Decompiled with CFR 0.152.
 */
package scalacache.guava;

import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scalacache.Cache;
import scalacache.Entry;
import scalacache.LoggingSupport;
import scalacache.guava.GuavaCache$;
import scalacache.serialization.Codec;
import scalacache.serialization.InMemoryRepr;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001\u001d\u0011!bR;bm\u0006\u001c\u0015m\u00195f\u0015\t\u0019A!A\u0003hk\u00064\u0018MC\u0001\u0006\u0003)\u00198-\u00197bG\u0006\u001c\u0007.Z\u0002\u0001'\u0011\u0001\u0001B\u0004\r\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\tQb]3sS\u0006d\u0017N_1uS>t\u0017BA\f\u0015\u00051Ie.T3n_JL(+\u001a9s!\ty\u0011$\u0003\u0002\u001b\t\tqAj\\4hS:<7+\u001e9q_J$\b\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u0015UtG-\u001a:ms&tw\r\u0005\u0003\u001fO!\u001aT\"A\u0010\u000b\u0005\u0001\n\u0013!B2bG\",'B\u0001\u0012$\u0003\u0019\u0019w.\\7p]*\u0011A%J\u0001\u0007O>|w\r\\3\u000b\u0003\u0019\n1aY8n\u0013\t\tr\u0004\u0005\u0002*a9\u0011!F\f\t\u0003W)i\u0011\u0001\f\u0006\u0003[\u0019\ta\u0001\u0010:p_Rt\u0014BA\u0018\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=R\u0001C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011a\u0017M\\4\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0007\u001f\nTWm\u0019;\t\u000bq\u0002A\u0011A\u001f\u0002\rqJg.\u001b;?)\tq\u0004\t\u0005\u0002@\u00015\t!\u0001C\u0003\u001dw\u0001\u0007Q\u0004C\u0004C\u0001\t\u0007IQK\"\u0002\r1|wmZ3s+\u0005!\u0005CA#K\u001b\u00051%BA$I\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0015aA8sO&\u00111J\u0012\u0002\u0007\u0019><w-\u001a:\t\r5\u0003\u0001\u0015!\u0004E\u0003\u001dawnZ4fe\u0002BQa\u0014\u0001\u0005BA\u000b1aZ3u+\t\tf\f\u0006\u0002SYR\u00111k\u001a\t\u0004)^KV\"A+\u000b\u0005YS\u0011AC2p]\u000e,(O]3oi&\u0011\u0001,\u0016\u0002\u0007\rV$XO]3\u0011\u0007%QF,\u0003\u0002\\\u0015\t1q\n\u001d;j_:\u0004\"!\u00180\r\u0001\u0011)qL\u0014b\u0001A\n\ta+\u0005\u0002bIB\u0011\u0011BY\u0005\u0003G*\u0011qAT8uQ&tw\r\u0005\u0002\nK&\u0011aM\u0003\u0002\u0004\u0003:L\b\"\u00025O\u0001\bI\u0017!B2pI\u0016\u001c\u0007\u0003B\nk9JI!a\u001b\u000b\u0003\u000b\r{G-Z2\t\u000b5t\u0005\u0019\u0001\u0015\u0002\u0007-,\u0017\u0010C\u0003p\u0001\u0011\u0005\u0003/A\u0002qkR,\"!\u001d>\u0015\tI\\HP \u000b\u0003g^\u00042\u0001V,u!\tIQ/\u0003\u0002w\u0015\t!QK\\5u\u0011\u0015Ag\u000eq\u0001y!\u0011\u0019\".\u001f\n\u0011\u0005uSH!B0o\u0005\u0004\u0001\u0007\"B7o\u0001\u0004A\u0003\"B?o\u0001\u0004I\u0018!\u0002<bYV,\u0007BB@o\u0001\u0004\t\t!A\u0002ui2\u0004B!\u0003.\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nU\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0003\u001b\t9A\u0001\u0005EkJ\fG/[8o\u0011\u001d\t\t\u0002\u0001C!\u0003'\taA]3n_Z,GcA:\u0002\u0016!1Q.a\u0004A\u0002!Bq!!\u0007\u0001\t\u0003\nY\"A\u0005sK6|g/Z!mYR\t1\u000fC\u0004\u0002 \u0001!\t%!\t\u0002\u000b\rdwn]3\u0015\u0003QDq!!\n\u0001\t\u0013\t9#\u0001\u0007u_\u0016C\b/\u001b:z)&lW\r\u0006\u0003\u0002*\u0005e\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0005i&lWMC\u0002\u00024!\u000bAA[8eC&!\u0011qGA\u0017\u0005!!\u0015\r^3US6,\u0007bB@\u0002$\u0001\u0007\u00111A\u0004\b\u0003{\u0011\u0001\u0012AA \u0003)9U/\u0019<b\u0007\u0006\u001c\u0007.\u001a\t\u0004\u007f\u0005\u0005cAB\u0001\u0003\u0011\u0003\t\u0019eE\u0002\u0002B!Aq\u0001PA!\t\u0003\t9\u0005\u0006\u0002\u0002@!A\u00111JA!\t\u0003\ti%A\u0003baBd\u0017\u0010F\u0001?\u0011!\tY%!\u0011\u0005\u0002\u0005ECc\u0001 \u0002T!1A$a\u0014A\u0002u\u0001")
public class GuavaCache
implements Cache<InMemoryRepr>,
LoggingSupport {
    private final com.google.common.cache.Cache<String, Object> underlying;
    private final Logger logger;

    public static GuavaCache apply(com.google.common.cache.Cache<String, Object> cache) {
        return GuavaCache$.MODULE$.apply(cache);
    }

    public static GuavaCache apply() {
        return GuavaCache$.MODULE$.apply();
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public final Logger logger() {
        return this.logger;
    }

    public <V> Future<Option<V>> get(String key, Codec<V, InMemoryRepr> codec) {
        None$ result;
        block0: {
            Entry entry;
            Object baseValue = this.underlying.getIfPresent((Object)key);
            Object object = baseValue != null ? ((entry = (Entry)baseValue).isExpired() ? None$.MODULE$ : new Some(entry.value())) : (result = None$.MODULE$);
            if (!this.logger().isDebugEnabled()) break block0;
            this.logCacheHitOrMiss(key, (Option)result);
        }
        return Future$.MODULE$.successful((Object)result);
    }

    public <V> Future<BoxedUnit> put(String key, V value, Option<Duration> ttl2, Codec<V, InMemoryRepr> codec) {
        Entry entry = new Entry(value, ttl2.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
        this.underlying.put((Object)key, (Object)entry);
        this.logCachePut(key, ttl2);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public Future<BoxedUnit> remove(String key) {
        this.underlying.invalidate((Object)key);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public Future<BoxedUnit> removeAll() {
        this.underlying.invalidateAll();
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void close() {
    }

    private DateTime toExpiryTime(Duration ttl) {
        return DateTime.now().plus(ttl.toMillis());
    }

    public GuavaCache(com.google.common.cache.Cache<String, Object> underlying) {
        this.underlying = underlying;
        LoggingSupport.$init$((LoggingSupport)this);
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

