/*
 * Decompiled with CFR 0.152.
 */
package scalacache.guava;

import com.google.common.cache.Cache;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.AbstractCache;
import scalacache.CacheAlg;
import scalacache.CacheConfig;
import scalacache.Entry;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;
import scalacache.guava.GuavaCache$;
import scalacache.logging.Logger;
import scalacache.logging.Logger$;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001B\u000b\u0017\u0001mA\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005i!Aq\n\u0001BC\u0002\u0013\r\u0001\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003R\u0011!)\u0006A!A!\u0002\u00171\u0006\"\u00020\u0001\t\u0003y\u0006b\u00024\u0001\u0005\u0004%)f\u001a\u0005\u0007]\u0002\u0001\u000bQ\u00025\t\u000b=\u0004A\u0011\u00019\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u00111\b\u0001\u0005B\u0005u\u0002bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003S\u0002A\u0011IA6\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003;q!a#\u0017\u0011\u0003\tiI\u0002\u0004\u0016-!\u0005\u0011q\u0012\u0005\u0007=B!\t!!%\t\u000f\u0005M\u0005\u0003\"\u0001\u0002\u0016\"9\u00111\u0013\t\u0005\u0002\u0005\u0005\u0006\"CA[!E\u0005I\u0011AA\\\u0005)9U/\u0019<b\u0007\u0006\u001c\u0007.\u001a\u0006\u0003/a\tQaZ;bm\u0006T\u0011!G\u0001\u000bg\u000e\fG.Y2bG\",7\u0001A\u000b\u00039%\u001a2\u0001A\u000f$!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fMB\u0019A%J\u0014\u000e\u0003aI!A\n\r\u0003\u001b\u0005\u00137\u000f\u001e:bGR\u001c\u0015m\u00195f!\tA\u0013\u0006\u0004\u0001\u0005\u000b)\u0002!\u0019A\u0016\u0003\u0003Y\u000b\"\u0001L\u0018\u0011\u0005yi\u0013B\u0001\u0018 \u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\b\u0019\n\u0005Ez\"aA!os\u0006QQO\u001c3fe2L\u0018N\\4\u0016\u0003Q\u0002B!\u000e A\u00176\taG\u0003\u00028q\u0005)1-Y2iK*\u0011\u0011HO\u0001\u0007G>lWn\u001c8\u000b\u0005mb\u0014AB4p_\u001edWMC\u0001>\u0003\r\u0019w.\\\u0005\u0003\u007fY\u0012QaQ1dQ\u0016\u0004\"!\u0011%\u000f\u0005\t3\u0005CA\" \u001b\u0005!%BA#\u001b\u0003\u0019a$o\\8u}%\u0011qiH\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H?A\u0019A\u0005T\u0014\n\u00055C\"!B#oiJL\u0018aC;oI\u0016\u0014H._5oO\u0002\naaY8oM&<W#A)\u0011\u0005\u0011\u0012\u0016BA*\u0019\u0005-\u0019\u0015m\u00195f\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005)1\r\\8dWB\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005i&lWMC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\b\u0006\u0002aKR\u0019\u0011m\u00193\u0011\u0007\t\u0004q%D\u0001\u0017\u0011\u0015ye\u0001q\u0001R\u0011\u001d)f\u0001%AA\u0004YCQA\r\u0004A\u0002Q\na\u0001\\8hO\u0016\u0014X#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-D\u0012a\u00027pO\u001eLgnZ\u0005\u0003[*\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0006I><U\r^\u000b\u0003cR$2A]A\u0003)\t\u0019H\u0010E\u0002)if$Q!^\u0005C\u0002Y\u0014\u0011AR\u000b\u0003W]$Q\u0001\u001f;C\u0002-\u0012\u0011a\u0018\t\u0004=i<\u0013BA> \u0005\u0019y\u0005\u000f^5p]\")Q0\u0003a\u0002}\u0006!Qn\u001c3f!\u0011!s0a\u0001\n\u0007\u0005\u0005\u0001D\u0001\u0003N_\u0012,\u0007C\u0001\u0015u\u0011\u0019\t9!\u0003a\u0001\u0001\u0006\u00191.Z=\u0002\u000b\u0011|\u0007+\u001e;\u0016\t\u00055\u00111\u0003\u000b\t\u0003\u001f\ty\"!\t\u0002&Q!\u0011\u0011CA\r!\u0011A\u00131C\u0018\u0005\rUT!\u0019AA\u000b+\rY\u0013q\u0003\u0003\u0007q\u0006M!\u0019A\u0016\t\ruT\u00019AA\u000e!\u0011!s0!\b\u0011\u0007!\n\u0019\u0002\u0003\u0004\u0002\b)\u0001\r\u0001\u0011\u0005\u0007\u0003GQ\u0001\u0019A\u0014\u0002\u000bY\fG.^3\t\u000f\u0005\u001d\"\u00021\u0001\u0002*\u0005\u0019A\u000f\u001e7\u0011\tyQ\u00181\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003!!WO]1uS>t'bAA\u001b?\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u0012q\u0006\u0002\t\tV\u0014\u0018\r^5p]\u0006AAm\u001c*f[>4X-\u0006\u0003\u0002@\u0005\u0015C\u0003BA!\u0003#\"B!a\u0011\u0002LA!\u0001&!\u00120\t\u0019)8B1\u0001\u0002HU\u00191&!\u0013\u0005\ra\f)E1\u0001,\u0011\u0019i8\u0002q\u0001\u0002NA!Ae`A(!\rA\u0013Q\t\u0005\u0007\u0003\u000fY\u0001\u0019\u0001!\u0002\u0017\u0011|'+Z7pm\u0016\fE\u000e\\\u000b\u0005\u0003/\ni\u0006\u0006\u0002\u0002ZQ!\u00111LA2!\u0011A\u0013QL\u0018\u0005\rUd!\u0019AA0+\rY\u0013\u0011\r\u0003\u0007q\u0006u#\u0019A\u0016\t\rud\u00019AA3!\u0011!s0a\u001a\u0011\u0007!\ni&A\u0003dY>\u001cX-\u0006\u0003\u0002n\u0005MDCAA8)\u0011\t\t(!\u001f\u0011\t!\n\u0019h\f\u0003\u0007k6\u0011\r!!\u001e\u0016\u0007-\n9\b\u0002\u0004y\u0003g\u0012\ra\u000b\u0005\u0007{6\u0001\u001d!a\u001f\u0011\t\u0011z\u0018Q\u0010\t\u0004Q\u0005M\u0014\u0001\u0004;p\u000bb\u0004\u0018N]=US6,G\u0003BAB\u0003\u0013\u00032aVAC\u0013\r\t9\t\u0017\u0002\b\u0013:\u001cH/\u00198u\u0011\u001d\t9C\u0004a\u0001\u0003W\t!bR;bm\u0006\u001c\u0015m\u00195f!\t\u0011\u0007c\u0005\u0002\u0011;Q\u0011\u0011QR\u0001\u0006CB\u0004H._\u000b\u0005\u0003/\u000bi\n\u0006\u0003\u0002\u001a\u0006}\u0005\u0003\u00022\u0001\u00037\u00032\u0001KAO\t\u0015Q#C1\u0001,\u0011\u0015y%\u0003q\u0001R+\u0011\t\u0019+a+\u0015\t\u0005\u0015\u0016q\u0016\u000b\u0005\u0003O\u000bi\u000b\u0005\u0003c\u0001\u0005%\u0006c\u0001\u0015\u0002,\u0012)!f\u0005b\u0001W!)qj\u0005a\u0002#\"1!g\u0005a\u0001\u0003c\u0003R!\u000e A\u0003g\u0003B\u0001\n'\u0002*\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*B!!/\u0002XR!\u00111XAhU\r1\u0016QX\u0016\u0003\u0003\u007f\u0003B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011Z\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0006\r'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"1!\u0007\u0006a\u0001\u0003#\u0004R!\u000e A\u0003'\u0004B\u0001\n'\u0002VB\u0019\u0001&a6\u0005\u000b)\"\"\u0019A\u0016")
public class GuavaCache<V>
implements AbstractCache<V> {
    private final Cache<String, Entry<V>> underlying;
    private final CacheConfig config;
    private final Clock clock;
    private final Logger logger;

    public static <V> Clock $lessinit$greater$default$3(Cache<String, Entry<V>> cache) {
        return GuavaCache$.MODULE$.$lessinit$greater$default$3(cache);
    }

    public static <V> GuavaCache<V> apply(Cache<String, Entry<V>> cache, CacheConfig cacheConfig) {
        return GuavaCache$.MODULE$.apply(cache, cacheConfig);
    }

    public static <V> GuavaCache<V> apply(CacheConfig cacheConfig) {
        return GuavaCache$.MODULE$.apply(cacheConfig);
    }

    public final <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.get$((AbstractCache)this, keyParts, mode, (Flags)flags);
    }

    public final <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.put$((AbstractCache)this, keyParts, value, ttl, mode, (Flags)flags);
    }

    public final <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return (F)AbstractCache.remove$((AbstractCache)this, keyParts, mode);
    }

    public final <F> F removeAll(Mode<F> mode) {
        return (F)AbstractCache.removeAll$((AbstractCache)this, mode);
    }

    public final <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.caching$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public final <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return AbstractCache.caching$default$2$((AbstractCache)this, keyParts);
    }

    public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingF$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return AbstractCache.cachingF$default$2$((AbstractCache)this, keyParts);
    }

    public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoize$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return AbstractCache.cachingForMemoize$default$2$((AbstractCache)this, (String)baseKey);
    }

    public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoizeF$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public <F> Option<Duration> put$default$3(Seq<Object> keyParts) {
        return CacheAlg.put$default$3$((CacheAlg)this, keyParts);
    }

    public Cache<String, Entry<V>> underlying() {
        return this.underlying;
    }

    public CacheConfig config() {
        return this.config;
    }

    public final Logger logger() {
        return this.logger;
    }

    public <F> F doGet(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0 & Serializable)() -> {
            void var3_3;
            Entry entry = (Entry)this.underlying().getIfPresent((Object)key);
            None$ result = entry == null || entry.isExpired($this.clock) ? None$.MODULE$ : new Some(entry.value());
            this.logCacheHitOrMiss(key, (Option)result);
            return var3_3;
        });
    }

    public <F> F doPut(String key, V value, Option<Duration> ttl, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Entry entry = new Entry(value, ttl.map((Function1 & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
            this.underlying().put((Object)key, (Object)entry);
            this.logCachePut(key, ttl);
        });
    }

    public <F> F doRemove(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & Serializable)() -> this.underlying().invalidate((Object)key));
    }

    public <F> F doRemoveAll(Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & Serializable)() -> this.underlying().invalidateAll());
    }

    public <F> F close(Mode<F> mode) {
        return (F)mode.M().pure((Object)BoxedUnit.UNIT);
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public GuavaCache(Cache<String, Entry<V>> underlying, CacheConfig config, Clock clock) {
        this.underlying = underlying;
        this.config = config;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        AbstractCache.$init$((AbstractCache)this);
        this.logger = Logger$.MODULE$.getLogger(this.getClass().getName());
    }
}

