/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.runner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jodd.bean.BeanCopy;
import org.cauli.common.instrument.ClassPool;
import org.cauli.common.instrument.ResourceUtil;
import org.cauli.junit.FrameworkMethodWithParameters;
import org.cauli.junit.TestPlan;
import org.cauli.junit.runner.CauliRunner;
import org.cauli.ui.CauliUIConfig;
import org.cauli.ui.annotation.Action;
import org.cauli.ui.annotation.Require;
import org.cauli.ui.config.IConfig;
import org.cauli.ui.runner.CauliUIStatment;
import org.cauli.ui.runner.UIFrameworkMethod;
import org.cauli.ui.selenium.browser.Engine;
import org.cauli.ui.selenium.listener.ActionListenerProxy;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CauliUIRunner
extends CauliRunner {
    private static Logger logger = LoggerFactory.getLogger(CauliUIRunner.class);
    CauliUIConfig uiConfig = new CauliUIConfig();

    public CauliUIRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void run(RunNotifier notifier) {
        for (Class clazz : ClassPool.getClassPool()) {
            if (!clazz.isAnnotationPresent(Action.class)) continue;
            ActionListenerProxy.register(clazz);
            logger.info("\u626b\u63cf\u5230\u52a8\u4f5c\u76d1\u542c\u5668:{}", (Object)clazz.getName());
        }
        super.run(notifier);
    }

    protected List<FrameworkMethodWithParameters> computeTestMethods() {
        List frameworkMethods = super.computeTestMethods();
        return this.createUIMethod(frameworkMethods);
    }

    protected Statement methodInvoker(FrameworkMethodWithParameters method, Object test) {
        CauliUIStatment statment = new CauliUIStatment((UIFrameworkMethod)method, test);
        statment.setRetryTimes(this.getTestPlan().getRetryTimes());
        return statment;
    }

    private List<FrameworkMethodWithParameters> createUIMethod(List<FrameworkMethodWithParameters> frameworkMethods) {
        ArrayList methods = Lists.newArrayList();
        for (FrameworkMethodWithParameters frameworkMethod : frameworkMethods) {
            Engine[] engines = this.getConfigEngines((FrameworkMethod)frameworkMethod);
            if (engines == null) {
                methods.add(frameworkMethod);
                continue;
            }
            for (Engine engine : engines) {
                UIFrameworkMethod method = new UIFrameworkMethod(frameworkMethod.getMethod(), frameworkMethod.getParameters(), frameworkMethod.getInfo(), engine);
                methods.add(method);
            }
        }
        return methods;
    }

    private Engine[] getConfigEngines(FrameworkMethod method) {
        if (this.isHaveRequireAnnotation(method)) {
            return this.getRequireBrowsers(method);
        }
        return this.uiConfig.getEngines();
    }

    private Engine[] getRequireBrowsers(FrameworkMethod method) {
        if (method.getMethod().isAnnotationPresent(Require.class)) {
            Engine[] engines = ((Require)method.getAnnotation(Require.class)).value();
            return engines;
        }
        if (method.getMethod().getDeclaringClass().isAnnotationPresent(Require.class)) {
            Engine[] engines = method.getMethod().getDeclaringClass().getAnnotation(Require.class).value();
            return engines;
        }
        return new Engine[]{Engine.PHANTOMJS};
    }

    private boolean isHaveRequireAnnotation(FrameworkMethod method) {
        return method.getMethod().isAnnotationPresent(Require.class) || method.getMethod().getDeclaringClass().isAnnotationPresent(Require.class);
    }

    protected TestPlan init() {
        TestPlan testPlan = super.init();
        BeanCopy.beans((Object)testPlan, (Object)((Object)this.uiConfig));
        Set classes = ResourceUtil.getClassByAssignable(IConfig.class);
        if (classes != null && classes.size() > 1) {
            Class clazz = (Class)classes.iterator().next();
            try {
                IConfig config = (IConfig)clazz.newInstance();
                config.config(this.uiConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BeanCopy.beans((Object)((Object)this.uiConfig), (Object)testPlan);
        }
        return testPlan;
    }
}

