/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.cauli.common.instrument.ClassPool;
import org.cauli.common.instrument.ClassUtils;
import org.cauli.ui.annotation.Commit;
import org.cauli.ui.selenium.page.Frame;
import org.cauli.ui.selenium.page.SourcePage;
import org.cauli.ui.selenium.page.SubPage;

public class PageHelper {
    private Map<String, Class<? extends Frame>> frameMap = Maps.newHashMap();
    private Map<String, Class<? extends SubPage>> subPageMap = Maps.newHashMap();
    private Map<String, Class<? extends SourcePage>> sourcePageMap = Maps.newHashMap();
    private static volatile PageHelper pageHelper;

    private PageHelper() {
        Set classes = ClassPool.getClassPool();
        for (Class clazz : classes) {
            if (ClassUtils.isAssignableFromSubClass(Frame.class, (Class)clazz)) {
                this.frameMap.put(clazz.getAnnotation(Commit.class) == null ? clazz.getSimpleName() : clazz.getAnnotation(Commit.class).value(), clazz);
                continue;
            }
            if (ClassUtils.isAssignableFromSubClass(SubPage.class, (Class)clazz)) {
                this.subPageMap.put(clazz.getAnnotation(Commit.class) == null ? clazz.getSimpleName() : clazz.getAnnotation(Commit.class).value(), clazz);
                continue;
            }
            if (!ClassUtils.isAssignableFromSubClass(Commit.class, (Class)clazz)) continue;
            this.sourcePageMap.put(clazz.getAnnotation(Commit.class) == null ? clazz.getSimpleName() : clazz.getAnnotation(Commit.class).value(), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PageHelper getInstance() {
        if (pageHelper != null) return pageHelper;
        Class<PageHelper> clazz = PageHelper.class;
        synchronized (PageHelper.class) {
            if (pageHelper != null) return pageHelper;
            pageHelper = new PageHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return pageHelper;
        }
    }

    public Map<String, Class<? extends Frame>> getFrameMap() {
        return this.frameMap;
    }

    public void setFrameMap(Map<String, Class<? extends Frame>> frameMap) {
        this.frameMap = frameMap;
    }

    public Map<String, Class<? extends SubPage>> getSubPageMap() {
        return this.subPageMap;
    }

    public void setSubPageMap(Map<String, Class<? extends SubPage>> subPageMap) {
        this.subPageMap = subPageMap;
    }

    public Map<String, Class<? extends SourcePage>> getSourcePageMap() {
        return this.sourcePageMap;
    }

    public void setSourcePageMap(Map<String, Class<? extends SourcePage>> sourcePageMap) {
        this.sourcePageMap = sourcePageMap;
    }
}

