/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.browser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.cauli.db.DBCore;
import org.cauli.db.DbManager;
import org.cauli.ui.selenium.browser.Browser;
import org.cauli.ui.selenium.browser.BrowserManager;
import org.cauli.ui.selenium.browser.Engine;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.browser.RemoteBrowser;
import org.cauli.ui.selenium.element.CauliElements;
import org.cauli.ui.selenium.element.IElement;
import org.cauli.ui.selenium.element.Select;
import org.cauli.ui.selenium.element.Table;
import org.cauli.ui.selenium.page.ICurrentPage;
import org.cauli.ui.selenium.page.SourcePage;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auto {
    public static ThreadLocal<Set<Engine>> browserSet = new ThreadLocal<Set<Engine>>(){

        @Override
        public Set<Engine> initialValue() {
            return new HashSet<Engine>();
        }
    };
    private static Logger logger = LoggerFactory.getLogger(Auto.class);
    public static ThreadLocal<BrowserManager> local = new ThreadLocal<BrowserManager>(){

        @Override
        public BrowserManager initialValue() {
            return new BrowserManager();
        }
    };

    public static void require(Engine[] browsers) {
        for (Engine browser : browsers) {
            browserSet.get().add(browser);
        }
    }

    public static void require(String value) {
        Engine b = Enum.valueOf(Engine.class, value.toUpperCase().trim());
        Auto.require(b);
    }

    public static void require(Engine browser) {
        BrowserManager browserManager = new BrowserManager();
        browserManager.setBrowser(new Browser(browser));
        local.set(browserManager);
    }

    public static void require(Engine browser, String url) {
        BrowserManager browserManager = new BrowserManager();
        try {
            browserManager.setBrowser(new Browser(browser, new URL(url)));
        }
        catch (MalformedURLException e) {
            logger.error("\u6ca1\u6709\u8fde\u63a5\u5230\u8fdc\u7a0b\u8282\u70b9\u7684\u670d\u52a1\u5668\uff0c\u8fdc\u7a0b\u6d4f\u89c8\u5668\u5f15\u7528\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u73af\u5883\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01");
            throw new RuntimeException("\u6ca1\u6709\u8fde\u63a5\u5230\u8fdc\u7a0b\u8282\u70b9\u7684\u670d\u52a1\u5668\uff0c\u8fdc\u7a0b\u6d4f\u89c8\u5668\u5f15\u7528\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u73af\u5883\u914d\u7f6e\u662f\u5426\u6b63\u786e", e);
        }
        local.set(browserManager);
    }

    public static void requireRemote(Engine browser, String url) {
        BrowserManager browserManager = new BrowserManager();
        try {
            browserManager.setBrowser(new RemoteBrowser(browser, new URL(url)));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0b\u7684serverURL\u51fa\u73b0\u4e86\u9519\u8bef");
        }
        local.set(browserManager);
    }

    public static IBrowser browser() {
        return local.get().getBrowser();
    }

    public static Engine browserType() {
        return Auto.browser().browserType();
    }

    public static ICurrentPage go(String url) {
        return Auto.browser().open(url);
    }

    public static IElement $(String jquery) {
        return Auto.browser().currentPage().$(jquery);
    }

    public static <T extends IElement> T element(Class<T> clazz) {
        return Auto.currentPage().element(clazz);
    }

    public static void maxWindow() {
        Auto.browser().maxWindow();
    }

    public static void quit() {
        Auto.browser().closeAllWindows();
    }

    public static void back() {
        Auto.browser().back();
    }

    public static void openNew(String url) {
        Auto.browser().openNew(url);
    }

    public static void refresh() {
        Auto.browser().refresh();
    }

    public static Select select(String location) {
        return Auto.browser().currentPage().select(location);
    }

    public static void forward() {
        Auto.browser().forward();
    }

    public static Set<String> getWindows() {
        return Auto.browser().getWindows();
    }

    public static ICurrentPage selectDefaultWindow() {
        return Auto.browser().selectDefaultWindow();
    }

    public static ICurrentPage selectLastOpenedPage() {
        return Auto.browser().selectLastOpenedPage();
    }

    public static ICurrentPage selectWindowByTitle(String title) {
        return Auto.browser().selectWindowByTitle(title);
    }

    public static ICurrentPage selectWindowByUrl(String url) {
        return Auto.browser().selectWindowByUrl(url);
    }

    public static ICurrentPage selectWindowContainsUrl(String url) {
        return Auto.browser().selectWindowContainsUrl(url);
    }

    public static ICurrentPage currentPage() {
        return Auto.browser().currentPage();
    }

    public static WebDriver getCurrentBrowserDriver() {
        return Auto.browser().getCurrentBrowserDriver();
    }

    public static Object runJavaScript(String js, Object ... objects) {
        return Auto.browser().runJavaScript(js, objects);
    }

    public static Object runAsynJavaScript(String js, Object ... objects) {
        return Auto.browser().runAsynJavaScript(js, objects);
    }

    public static void takeScreetShot(String path) {
        Auto.browser().takeScreetShot(path);
    }

    public static boolean isClosed() {
        return Auto.browser().isClosed();
    }

    public static void setClosed(boolean isclose) {
        Auto.browser().setClosed(isclose);
    }

    public static void clearBrowserManager() {
        browserSet.get().clear();
    }

    public static boolean remove(Browser browser) {
        return browserSet.get().remove(browser);
    }

    public static Table table(String location) {
        return Auto.currentPage().table(location);
    }

    public static <T extends SourcePage> T page(Class<T> clazz) {
        return Auto.browser().page(clazz);
    }

    public static void pageLoadTimeout(int seconds) {
        Auto.browser().pageLoadTimeout(seconds);
    }

    public static void elementLoadTimeout(int seconds) {
        Auto.browser().elementLoadTimeout(seconds);
    }

    public static DBCore db(String id) {
        return DbManager.getDBCore((String)id);
    }

    public static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public CauliElements elements(String location) {
        return Auto.currentPage().elements(location);
    }

    public static <T extends SourcePage> T waitFor(T page) {
        return Auto.browser().waitFor(page);
    }
}

