/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.browser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.cauli.ui.selenium.browser.Engine;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.browser.WindowSource;
import org.cauli.ui.selenium.browser.WindowsCollectorListener;
import org.cauli.ui.selenium.element.LocationParse;
import org.cauli.ui.selenium.listener.ActionListenerProxy;
import org.cauli.ui.selenium.page.CurrentPage;
import org.cauli.ui.selenium.page.ICurrentPage;
import org.cauli.ui.selenium.page.Page;
import org.cauli.ui.selenium.page.SourcePage;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser
implements IBrowser {
    private Logger logger = LoggerFactory.getLogger(Browser.class);
    private boolean isClosed = false;
    private boolean isUseJQuery = false;
    private WindowsCollectorListener windowsCollectorListener;
    private WindowSource windowSource;
    private Page page;
    private WebDriver driver;
    private Engine engine;

    public Browser(Engine browser) {
        this.engine = browser;
        this.driver = (WebDriver)browser.browser();
        this.maxWindow();
        this.driver.manage().timeouts().pageLoadTimeout(5L, TimeUnit.SECONDS);
        this.windowSource = new WindowSource(this);
        this.windowsCollectorListener = new WindowsCollectorListener();
        this.windowSource.addWindowsListener(this.windowsCollectorListener);
        this.page = new CurrentPage(this);
        this.pageLoadTimeout(20);
        this.logger.info("\u521d\u59cb\u5316\u4e86\u6d4f\u89c8\u5668" + browser.toString() + "\u6765\u8fdb\u884c\u81ea\u52a8\u5316\u6d4b\u8bd5");
    }

    public Browser(Engine browser, URL url) {
        this.engine = browser;
        this.driver = url == null ? (WebDriver)browser.browser() : browser.browser(url);
        this.maxWindow();
        this.driver.manage().timeouts().pageLoadTimeout(5L, TimeUnit.SECONDS);
        this.windowSource = new WindowSource(this);
        this.windowsCollectorListener = new WindowsCollectorListener();
        this.windowSource.addWindowsListener(this.windowsCollectorListener);
        this.page = new CurrentPage(this);
        this.pageLoadTimeout(20);
        this.logger.info("\u521d\u59cb\u5316\u4e86\u6d4f\u89c8\u5668" + browser.toString() + "\u6765\u8fdb\u884c\u81ea\u52a8\u5316\u6d4b\u8bd5");
    }

    @Override
    public ICurrentPage open(String url) {
        this.getCurrentBrowserDriver().get(url);
        this.setClosed(false);
        this.page.setBrowser(this);
        this.windowSource.windowsCheck();
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u9875\u9762\u4fe1\u606f\uff1aURL--->" + this.page().getUrl());
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u9875\u9762\u4fe1\u606f\uff1aTitle--->" + this.page().getTitle());
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u9875\u9762\u4fe1\u606f\uff1a\u7a97\u53e3\u53e5\u67c4\u6570--->" + this.getWindows().size());
        return this.page;
    }

    @Override
    public void maxWindow() {
        this.driver.manage().window().maximize();
    }

    @Override
    public void closeAllWindows() {
        ActionListenerProxy.getDispatcher().beforecloseAllWindows();
        if (this.driver != null) {
            this.getCurrentBrowserDriver().quit();
            this.setClosed(true);
            this.logger.info("\u5173\u95ed\u4e86\u6d4f\u89c8\u5668");
        } else {
            this.logger.warn("\u4e0e\u6d4f\u89c8\u5668\u4ea4\u4e92\u7684session\u503c\u53ef\u80fd\u5df2\u7ecf\u4e2d\u65ad\u4e86\uff0c\u8bf7\u68c0\u67e5\u7a0b\u5e8f\u662f\u5426\u7f16\u5199\u6b63\u786e\uff0c\u7a0b\u5e8f\u8fd8\u5c06\u7ee7\u7eed\u8fd0\u884c\u4e0b\u53bb");
        }
        ActionListenerProxy.getDispatcher().aftercloseAllWindows();
    }

    @Override
    public Engine browserType() {
        return this.engine;
    }

    @Override
    public void back() {
        ActionListenerProxy.getDispatcher().beforeback();
        this.driver.navigate().back();
        this.logger.info("\u6d4f\u89c8\u5668\u8fdb\u884c\u4e86\u540e\u9000\u64cd\u4f5c");
        ActionListenerProxy.getDispatcher().afterback();
    }

    @Override
    public void refresh() {
        ActionListenerProxy.getDispatcher().beforerefresh();
        this.driver.navigate().refresh();
        this.logger.info("\u6d4f\u89c8\u5668\u8fdb\u884c\u4e86\u5237\u65b0\u64cd\u4f5c");
        ActionListenerProxy.getDispatcher().afterrefresh();
    }

    @Override
    public void forward() {
        ActionListenerProxy.getDispatcher().beforeforward();
        this.driver.navigate().forward();
        this.logger.info("\u6d4f\u89c8\u5668\u8fdb\u884c\u4e86\u524d\u8fdb\u64cd\u4f5c");
        ActionListenerProxy.getDispatcher().afterforward();
    }

    @Override
    public Set<String> getWindows() {
        return this.driver.getWindowHandles();
    }

    @Override
    public ICurrentPage selectDefaultWindow() {
        this.driver.switchTo().defaultContent();
        this.page.setBrowser(this);
        return this.page;
    }

    @Override
    public ICurrentPage selectFrame(int index) {
        this.driver.switchTo().frame(index);
        this.page.setBrowser(this);
        return this.page;
    }

    @Override
    public ICurrentPage selectFrame(String locate) {
        By by = LocationParse.parseLocation(locate, this.driver.getPageSource());
        this.driver.switchTo().frame(this.driver.findElement(by));
        return this.page;
    }

    @Override
    public ICurrentPage selectLastOpenedPage() {
        ActionListenerProxy.getDispatcher().beforeselectWindow();
        this.windowSource.getWindowsCollecter().updateWindows();
        String windowhandle = this.windowSource.getWindowsCollecter().getLastWindowhandle();
        this.driver.switchTo().window(windowhandle);
        this.page.setBrowser(this);
        ActionListenerProxy.getDispatcher().afterselectWindow();
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aURL--->" + this.page().getUrl());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aTitle--->" + this.page().getTitle());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1a\u7a97\u53e3\u53e5\u67c4\u6570--->" + this.getWindows().size());
        return this.page;
    }

    @Override
    public ICurrentPage selectWindowByTitle(String title) {
        ActionListenerProxy.getDispatcher().beforeselectWindow();
        this.windowSource.getWindowsCollecter().updateWindows();
        Set windows = this.getCurrentBrowserDriver().getWindowHandles();
        for (String window : windows) {
            this.getCurrentBrowserDriver().switchTo().window(window);
            String titleName = this.getCurrentBrowserDriver().getTitle();
            if (!titleName.equals(title)) continue;
            break;
        }
        this.logger.info("\u5f53\u524d\u9875\u9762\u5207\u6362\u5230\u4e86-------->" + title);
        ActionListenerProxy.getDispatcher().afterselectWindow();
        this.page.setBrowser(this);
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aURL--->" + this.page().getUrl());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aTitle--->" + this.page().getTitle());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1a\u7a97\u53e3\u53e5\u67c4\u6570--->" + this.getWindows().size());
        return this.page;
    }

    @Override
    public ICurrentPage selectWindowByUrl(String url) {
        ActionListenerProxy.getDispatcher().beforeselectWindow();
        this.windowSource.getWindowsCollecter().updateWindows();
        Set windows = this.getCurrentBrowserDriver().getWindowHandles();
        for (String window : windows) {
            this.getCurrentBrowserDriver().switchTo().window(window);
            String titleName = this.getCurrentBrowserDriver().getCurrentUrl();
            if (!titleName.equals(url)) continue;
            break;
        }
        ActionListenerProxy.getDispatcher().afterselectWindow();
        this.page.setBrowser(this);
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aURL--->" + this.page().getUrl());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aTitle--->" + this.page().getTitle());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1a\u7a97\u53e3\u53e5\u67c4\u6570--->" + this.getWindows().size());
        return this.page;
    }

    public ICurrentPage selectWindowByIndex(Integer index) {
        this.windowSource.getWindowsCollecter().updateWindows();
        String windowhandle = this.windowSource.getWindowsCollecter().getWindowhandleByIndex(index);
        this.driver.switchTo().window(windowhandle);
        this.logger.info("\u5f53\u524d\u9875\u9762\u5207\u6362\u5230\u4e86-------->" + this.driver.getTitle());
        this.page.setBrowser(this);
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aURL--->" + this.page().getUrl());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aTitle--->" + this.page().getTitle());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1a\u7a97\u53e3\u53e5\u67c4\u6570--->" + this.getWindows().size());
        return this.page;
    }

    @Override
    public ICurrentPage selectWindowContainsUrl(String url) {
        ActionListenerProxy.getDispatcher().beforeselectWindow();
        this.windowSource.getWindowsCollecter().updateWindows();
        Set windows = this.getCurrentBrowserDriver().getWindowHandles();
        for (String window : windows) {
            this.getCurrentBrowserDriver().switchTo().window(window);
            String titleName = this.getCurrentBrowserDriver().getCurrentUrl();
            if (!titleName.contains(url)) continue;
            break;
        }
        this.page.setBrowser(this);
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aURL--->" + this.page().getUrl());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aTitle--->" + this.page().getTitle());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1a\u7a97\u53e3\u53e5\u67c4\u6570--->" + this.getWindows().size());
        ActionListenerProxy.getDispatcher().afterselectWindow();
        return this.page;
    }

    @Override
    public ICurrentPage currentPage() {
        if (this.page == null) {
            this.page = new Page(this);
            this.page.setCurrentwindow(this.driver);
        }
        return this.page;
    }

    @Override
    public Page page() {
        if (this.page == null) {
            this.page = new Page(this);
            this.page.setCurrentwindow(this.driver);
        }
        return this.page;
    }

    @Override
    public WebDriver getCurrentBrowserDriver() {
        return this.driver;
    }

    @Override
    public Object runJavaScript(String js, Object ... objects) {
        ActionListenerProxy.getDispatcher().beforerunJS();
        Object obj = ((JavascriptExecutor)this.driver).executeScript(js, objects);
        ActionListenerProxy.getDispatcher().afterrunJS();
        return obj;
    }

    @Override
    public Object runAsynJavaScript(String js, Object ... objects) {
        ActionListenerProxy.getDispatcher().beforerunJS();
        Object obj = ((JavascriptExecutor)this.driver).executeAsyncScript(js, objects);
        ActionListenerProxy.getDispatcher().afterrunJS();
        return obj;
    }

    @Override
    public void takeScreetShot(String path) {
        ActionListenerProxy.getDispatcher().beforetakeScreenShot();
        TakesScreenshot tss = (TakesScreenshot)this.driver;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String time = sdf.format(new Date());
        File file = (File)tss.getScreenshotAs(OutputType.FILE);
        try {
            FileUtils.copyFile((File)file, (File)new File(path + File.separator + time + ".png"));
            this.logger.info("\u6d4f\u89c8\u5668\u5f53\u524d\u9875\u9762\u622a\u5c4f\u6210\u529f\uff01\u622a\u5c4f\u8def\u5f84->" + path);
        }
        catch (IOException e) {
            this.logger.error("\u6d4f\u89c8\u5668\u5f53\u524d\u9875\u9762\u622a\u5c4f\u5931\u8d25\uff01\u53ef\u80fd\u662f\u56e0\u4e3a\u6587\u4ef6\u8def\u5f84\u4e0d\u6b63\u786e");
            e.printStackTrace();
        }
        ActionListenerProxy.getDispatcher().aftertakeScreenShot();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    @Override
    public WindowSource getWindowSource() {
        return this.windowSource;
    }

    protected void setWebDriver(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public void pageLoadTimeout(int seconds) {
        this.driver.manage().timeouts().pageLoadTimeout((long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public <T extends SourcePage> T waitFor(T page) {
        String js = "\nif(document.readyState==\"complete\"){\n   return \"done\"  \n}\n";
        String text = (String)this.runJavaScript(js, new Object[0]);
        for (int i = 0; i < 10; ++i) {
            if ("done".equals(text)) {
                return page;
            }
            this.currentPage().sleep(1);
        }
        return null;
    }

    @Override
    public void elementLoadTimeout(int seconds) {
        this.driver.manage().timeouts().implicitlyWait((long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public <T extends SourcePage> T page(Class<T> pageClass) {
        try {
            Constructor<T> constructor = pageClass.getConstructor(IBrowser.class);
            SourcePage page = (SourcePage)constructor.newInstance(this);
            return (T)this.waitFor(page);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5207\u6362\u9875\u9762\u5931\u8d25..", (Throwable)e);
            return null;
        }
    }

    @Override
    public void openNew(String url) {
        this.runJavaScript("window.open('" + url + "')", new Object[0]);
        this.selectLastOpenedPage();
    }

    @Override
    public boolean isUseJQuery() {
        return this.isUseJQuery;
    }

    @Override
    public ICurrentPage selectWindowContainsTitle(String title) {
        ActionListenerProxy.getDispatcher().beforeselectWindow();
        this.windowSource.getWindowsCollecter().updateWindows();
        Set windows = this.getCurrentBrowserDriver().getWindowHandles();
        for (String window : windows) {
            this.getCurrentBrowserDriver().switchTo().window(window);
            String titleName = this.getCurrentBrowserDriver().getTitle();
            if (!titleName.contains(title)) continue;
            break;
        }
        this.logger.info("\u5f53\u524d\u9875\u9762\u5207\u6362\u5230\u4e86-------->" + title);
        ActionListenerProxy.getDispatcher().afterselectWindow();
        this.page.setBrowser(this);
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aURL--->" + this.page().getUrl());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1aTitle--->" + this.page().getTitle());
        this.logger.info("\u5f53\u524d\u9875\u9762\u4fe1\u606f\uff1a\u7a97\u53e3\u53e5\u67c4\u6570--->" + this.getWindows().size());
        return this.page;
    }

    public void setUseJQuery(boolean isUseJQuery) {
        this.isUseJQuery = isUseJQuery;
    }
}

