/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.element;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.apache.commons.io.IOUtils;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.element.CauliElements;
import org.cauli.ui.selenium.element.IElement;
import org.cauli.ui.selenium.element.LocationParse;
import org.cauli.ui.selenium.listener.ActionListenerProxy;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CauliElement
implements IElement {
    private Logger logger = LoggerFactory.getLogger(CauliElement.class);
    private IBrowser browser;
    private WebElement element;
    private Actions actions;
    private String id;
    private String Locate;

    @Override
    public String getLocate() {
        return this.Locate;
    }

    public void setLocate(String locate) {
        this.Locate = locate;
    }

    public CauliElement(IBrowser browser) {
        this.browser = browser;
        this.actions = new Actions(this.getBrowser().getCurrentBrowserDriver());
        this.id = "Element";
        this.element = null;
    }

    public CauliElement(IBrowser browser, String location) {
        this(browser);
        try {
            WebDriver driver = this.getBrowser().getCurrentBrowserDriver();
            if (this.browser.isUseJQuery()) {
                if (location.contains("->")) {
                    By by = LocationParse.parseLocation(location, driver.getPageSource());
                    this.element = driver.findElement(by);
                    this.id = by.toString();
                } else {
                    this.element = this.jquery(location);
                    this.id = location;
                }
            } else {
                this.element = driver.findElement(LocationParse.parseLocation(location, driver.getPageSource()));
            }
        }
        catch (Exception e) {
            this.element = null;
        }
    }

    protected WebElement jquery(String jquery) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("jquery.js");
        String jqueryJs = null;
        try {
            jqueryJs = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        WebDriver driver = this.getBrowser().getCurrentBrowserDriver();
        return (WebElement)((JavascriptExecutor)driver).executeScript(jqueryJs + "return jQuery(\"" + jquery + "\")[0]", new Object[0]);
    }

    @Override
    public IElement find(String location) {
        WebDriver driver = this.getBrowser().getCurrentBrowserDriver();
        try {
            if (this.element == null) {
                if (this.browser.isUseJQuery()) {
                    if (location.contains("->")) {
                        By by = LocationParse.parseLocation(location, driver.getPageSource());
                        this.element = driver.findElement(by);
                        this.id = by.toString();
                    } else {
                        this.element = this.jquery(location);
                        this.id = location;
                    }
                } else if (this.element == null) {
                    this.element = driver.findElement(LocationParse.parseLocation(location, driver.getPageSource()));
                    this.id = location;
                } else {
                    this.element = this.getElement().findElement(LocationParse.parseLocation(location, driver.getPageSource()));
                    this.id = location;
                }
            }
        }
        catch (NoSuchElementException e) {
            this.element = null;
        }
        return this;
    }

    @Override
    public <T> T find(String location, Class<T> tClass) {
        WebDriver driver = this.getBrowser().getCurrentBrowserDriver();
        try {
            if (this.browser.isUseJQuery()) {
                if (location.contains("->")) {
                    By by = LocationParse.parseLocation(location, driver.getPageSource());
                    this.element = driver.findElement(by);
                    this.id = by.toString();
                } else {
                    this.element = this.jquery(location);
                    this.id = location;
                }
            } else if (this.element == null) {
                this.element = driver.findElement(LocationParse.parseLocation(location, driver.getPageSource()));
                this.setId(location);
            } else {
                this.element = this.getElement().findElement(LocationParse.parseLocation(location, driver.getPageSource()));
                this.setId(location);
            }
        }
        catch (NoSuchElementException e) {
            this.element = null;
        }
        try {
            Constructor<T> constructor = tClass.getConstructor(IBrowser.class, String.class);
            return constructor.newInstance(this.getBrowser(), location);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void click() {
        ActionListenerProxy.getDispatcher().beforeClickOn();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u70b9\u51fb\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u70b9\u51fb\u5931\u8d25\uff01");
        }
        this.element.click();
        this.logger.info("[" + this.id + "]\u70b9\u51fb\u64cd\u4f5c\u6210\u529f");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterClickOn();
    }

    @Override
    public void doubleClick() {
        ActionListenerProxy.getDispatcher().beforedoubleClick();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u53cc\u51fb\u51fb\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u53cc\u51fb\u5931\u8d25\uff01");
        }
        this.actions.doubleClick().build().perform();
        this.logger.info("[" + this.id + "]\u53cc\u51fb\u64cd\u4f5c\u6210\u529f");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterdoubleClick();
    }

    @Override
    public void keyDown(Keys key) {
        ActionListenerProxy.getDispatcher().beforekeyDown();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u6309\u4e0b\u6309\u952e[" + key + "]\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u6309\u4e0b\u6309\u94ae[" + key + "]\u5931\u8d25\uff01");
        }
        this.actions.keyDown(key).build().perform();
        this.logger.info("[" + this.id + "]\u6309\u4e0b\u952e\u76d8\u6309\u94ae[" + key + "]\u6210\u529f");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterkeyDown();
    }

    @Override
    public void keyUp(Keys key) {
        ActionListenerProxy.getDispatcher().beforekeyUp();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u677e\u5f00\u6309\u952e" + key + "\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u677e\u5f00\u6309\u952e" + key + "\u5931\u8d25\uff01");
        }
        this.actions.keyDown(key).build().perform();
        this.logger.info("[" + this.id + "]\u6309\u4e0b\u952e\u76d8\u6309\u94ae" + key + "\u6210\u529f");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterkeyUp();
    }

    @Override
    public void assertAttribute(String attr, String value) {
        if (this.getAttribute(attr).equals(value)) {
            this.logger.info("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u7684\u5c5e\u6027[" + attr + "]\u7684\u503c[=" + value + "]\u65ad\u8a00\u6b63\u786e");
        } else {
            this.logger.error("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u7684\u5c5e\u6027[" + attr + "]\u7684\u503c[=" + value + "]\u65ad\u8a00\u5931\u8d25");
            Assert.fail();
        }
    }

    @Override
    public void assertEditable() {
        if (this.isEnable()) {
            this.logger.info("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u53ef\u7f16\u8f91\u7684\u65ad\u8a00\u6210\u529f");
        } else {
            this.logger.error("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u53ef\u7f16\u8f91\u6027\u65ad\u8a00\u5931\u8d25");
            Assert.fail();
        }
    }

    @Override
    public void assertNotEditable() {
        if (!this.isEnable()) {
            this.logger.info("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u4e0d\u53ef\u7f16\u8f91\u7684\u65ad\u8a00\u6210\u529f");
        } else {
            this.logger.error("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u4e0d\u53ef\u7f16\u8f91\u6027\u65ad\u8a00\u5931\u8d25");
            Assert.fail();
        }
    }

    @Override
    public void assertSelected() {
        if (this.isSelected()) {
            this.logger.info("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u53ef\u9009\u62e9\u6027\u65ad\u8a00\u6210\u529f");
        } else {
            this.logger.error("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u53ef\u9009\u62e9\u6027\u65ad\u8a00\u5931\u8d25");
            Assert.fail();
        }
    }

    @Override
    public void assertIsExist() {
        if (this.isExist()) {
            this.logger.info("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u5b58\u5728\u6027\u65ad\u8a00\u6210\u529f");
        } else {
            this.logger.error("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u5b58\u5728\u6027\u65ad\u8a00\u5931\u8d25");
            Assert.fail();
        }
    }

    @Override
    public void assertText(String text) {
        if (this.getText().equals(text)) {
            this.logger.info("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u7684\u6587\u672c\u503c[" + text + "]\u65ad\u8a00\u6210\u529f");
        } else {
            this.logger.error("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u7684\u6587\u672c\u503c[" + text + "]\u65ad\u8a00\u5931\u8d25");
            Assert.fail();
        }
    }

    @Override
    public void assertValue(String value) {
        if (this.getAttribute("value").equals(value)) {
            this.logger.info("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u7684value\u503c[" + value + "]\u65ad\u8a00\u6210\u529f");
        } else {
            this.logger.error("[" + this.id + "]\u8fd9\u4e2a\u5143\u7d20\u7684value\u503c[" + value + "]\u65ad\u8a00\u5931\u8d25");
            Assert.fail();
        }
    }

    @Override
    public IElement clear() {
        ActionListenerProxy.getDispatcher().beforeclear();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u6e05\u7a7a\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u6e05\u7a7a\u5931\u8d25\uff01");
        }
        this.element.clear();
        this.logger.info("[" + this.id + "]\u6e05\u7a7a\u64cd\u4f5c\u6210\u529f");
        ActionListenerProxy.getDispatcher().afterclear();
        return this;
    }

    @Override
    public void input(String text) {
        ActionListenerProxy.getDispatcher().beforeSendkeys();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u8f93\u5165[" + text + "]\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u8f93\u5165[" + text + "]\u5931\u8d25\uff01");
        }
        this.element.sendKeys(new CharSequence[]{text});
        this.logger.info("[" + this.id + "]\u8f93\u5165[" + text + "]\u503c\u64cd\u4f5c\u6210\u529f");
        ActionListenerProxy.getDispatcher().afterSendkeys();
    }

    @Override
    public void focus() {
        this.element.sendKeys(new CharSequence[]{""});
        this.browser.getWindowSource().windowsCheck();
    }

    @Override
    public String getAttribute(String attr) {
        if (this.isExist()) {
            String attrvalue = this.element.getAttribute(attr);
            this.logger.info("[" + this.id + "]\u83b7\u53d6\u5c5e\u6027[attr]\u7684\u503c[=" + attrvalue + "]\u6210\u529f\u64cd\u4f5c\u6210\u529f");
            return attrvalue;
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u5c5e\u6027" + attr + "\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u5c5e\u6027[" + attr + "]\u7684\u503c\u5931\u8d25\uff01");
    }

    @Override
    public String getText() {
        if (this.isExist()) {
            String text = this.element.getText();
            this.logger.info("[" + this.id + "]\u83b7\u53d6\u6587\u672c\u503c[" + text + "]\u64cd\u4f5c\u6210\u529f");
            return text;
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u6587\u672c\u503c\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u6587\u672c\u503c\u5931\u8d25\uff01");
    }

    @Override
    public String getCssValue(String name) {
        if (this.isExist()) {
            String cssvalue = this.element.getCssValue(name);
            this.logger.info("[" + this.id + "]\u5143\u7d20\u83b7\u53d6css[" + name + "]\u7684\u503c[=" + cssvalue + "]\u64cd\u4f5c\u6210\u529f");
            return cssvalue;
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6Css[" + name + "]\u503c\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6css[" + name + "]\u5931\u8d25\uff01");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Point getLocation() {
        if (this.isExist()) {
            Point point = this.element.getLocation();
            this.logger.info("[" + this.id + "]\u83b7\u53d6\u5143\u7d20\u4f4d\u7f6e\u64cd\u4f5c\u6210\u529f");
            return point;
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u4f4d\u7f6e\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u4f4d\u7f6e\u5931\u8d25\uff01");
    }

    @Override
    public int[] getSize() {
        if (this.isExist()) {
            Dimension ds = this.element.getSize();
            int[] size = new int[]{ds.getHeight(), ds.getWidth()};
            this.logger.info("[" + this.id + "]\u83b7\u53d6\u5143\u7d20\u5927\u5c0f\u64cd\u4f5c\u6210\u529f");
            return size;
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u5143\u7d20\u5927\u5c0f\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u5143\u7d20\u5927\u5c0f\u5931\u8d25\uff01");
    }

    @Override
    public String getTagName() {
        if (this.isExist()) {
            String tagname = this.element.getTagName();
            this.logger.info("[" + this.id + "]\u83b7\u53d6\u5143\u7d20\u6807\u7b7e\u540d[" + tagname + "]\u64cd\u4f5c\u6210\u529f");
            return tagname;
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u5143\u7d20\u6807\u7b7e\u540d\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u5143\u7d20\u6807\u7b7e\u540d\u5931\u8d25\uff01");
    }

    @Override
    public void scroll() {
        ActionListenerProxy.getDispatcher().beforescroll();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u79fb\u52a8\u89c6\u89d2\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u79fb\u52a8\u89c6\u89d2\u5931\u8d25\uff01");
        }
        Point point = this.getLocation();
        int x = point.getX();
        int y = point.getY();
        this.browser.runJavaScript("window.scrollTo(" + x + "," + y + ")", new Object[0]);
        this.logger.info("[" + this.id + "]\u89c6\u89d2\u79fb\u52a8\u5230\u4e86[" + x + "," + y + "]\u7684\u4f4d\u7f6e");
        ActionListenerProxy.getDispatcher().afterscroll();
    }

    @Override
    public void mouseOver() {
        ActionListenerProxy.getDispatcher().beforeMouseOver();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u9f20\u6807\u60ac\u6d6e\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u9f20\u6807\u60ac\u6d6e\u5931\u8d25\uff01");
        }
        this.actions.moveToElement(this.element).build().perform();
        this.logger.info("[" + this.id + "]\u5143\u7d20\u5904\u9f20\u6807\u60ac\u6d6e\u6210\u529f\uff01");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterMouseOver();
    }

    @Override
    public void submit() {
        ActionListenerProxy.getDispatcher().beforesubmit();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u63d0\u4ea4\u8868\u5355\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u63d0\u4ea4\u8868\u5355\u5931\u8d25\uff01");
        }
        this.element.submit();
        this.logger.info("[" + this.id + "]\u5143\u7d20\u63d0\u4ea4\u8868\u5355\u6210\u529f\uff01");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().aftersubmit();
    }

    @Override
    public boolean isDisplay() {
        if (this.isExist()) {
            return this.element.isDisplayed();
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728,\u5224\u65ad\u5143\u7d20\u662f\u5426\u53ef\u89c1\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5224\u65ad\u5143\u7d20\u662f\u5426\u53ef\u89c1\u5931\u8d25\uff01");
    }

    @Override
    public boolean isEnable() {
        if (this.isExist()) {
            return this.element.isEnabled();
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5224\u65ad\u5143\u7d20\u662f\u5426\u53ef\u7f16\u8f91\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5224\u65ad\u5143\u7d20\u662f\u5426\u53ef\u7f16\u8f91\u5931\u8d25\uff01");
    }

    @Override
    public boolean isSelected() {
        if (this.isExist()) {
            return this.element.isSelected();
        }
        this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5224\u65ad\u5143\u7d20\u662f\u5426\u88ab\u9009\u62e9\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5224\u65ad\u5143\u7d20\u662f\u5426\u88ab\u9009\u62e9\u5931\u8d25\uff01");
    }

    @Override
    public void dragAndDrop(IElement e) {
        ActionListenerProxy.getDispatcher().beforedragAndDrop();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u62d6\u62fd\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u62d6\u62fd\u5931\u8d25\uff01");
        }
        this.actions.dragAndDropBy(this.element, e.getLocation().getX(), e.getLocation().getY()).build().perform();
        this.logger.info("[" + this.id + "]\u5143\u7d20\u62d6\u62fd\u6210\u529f");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterdragAndDrop();
    }

    @Override
    public void dragAndDrop(Point point) {
        ActionListenerProxy.getDispatcher().beforedragAndDrop();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u62d6\u62fd\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u62d6\u62fd\u5931\u8d25\uff01");
        }
        this.actions.dragAndDropBy(this.element, point.getX(), point.getY());
        this.logger.info("[" + this.id + "]\u5143\u7d20\u62d6\u62fd\u6210\u529f");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterdragAndDrop();
    }

    @Override
    public void leftDown() {
        ActionListenerProxy.getDispatcher().beforeleftDown();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e\u5931\u8d25\uff01");
        }
        this.actions.clickAndHold(this.element).build().perform();
        this.logger.info("[" + this.id + "]\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterleftDown();
    }

    @Override
    public void leftUp() {
        ActionListenerProxy.getDispatcher().beforeleftUp();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904\u677e\u5f00\u5de6\u952e\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904\u6309\u4f4f\u677e\u5f00\u5931\u8d25\uff01");
        }
        this.actions.release(this.element).build().perform();
        this.logger.info("[" + this.id + "]\u5143\u7d20\u5904\u677e\u5f00\u5de6\u952e");
        this.browser.getWindowSource().windowsCheck();
        ActionListenerProxy.getDispatcher().afterleftUp();
    }

    @Override
    public boolean isExist() {
        if (this.element == null) {
            for (int i = 0; i < 10; ++i) {
                this.locateInit();
                if (this.getElement() != null) break;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.element != null;
        }
        return true;
    }

    private void locateInit() {
        if (this.getLocate() != null) {
            try {
                WebDriver driver = this.getBrowser().getCurrentBrowserDriver();
                if (this.browser.isUseJQuery()) {
                    if (this.getLocate().contains("->")) {
                        By by = LocationParse.parseLocation(this.getLocate(), driver.getPageSource());
                        this.element = driver.findElement(by);
                        this.id = by.toString();
                    } else {
                        this.element = this.jquery(this.getLocate());
                        this.id = this.getLocate();
                    }
                } else {
                    this.element = driver.findElement(LocationParse.parseLocation(this.getLocate(), driver.getPageSource()));
                    this.setId(this.getLocate());
                }
            }
            catch (Exception e) {
                this.logger.warn("\u5143\u7d20{}\u4e0d\u5b58\u5728...", (Object)this.id);
                this.element = null;
            }
        }
    }

    public IBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public WebElement getElement() {
        return this.element;
    }

    @Override
    public IElement child(String location) {
        WebElement e = this.element.findElement(By.partialLinkText((String)location));
        CauliElement cauliElement = new CauliElement(this.getBrowser());
        cauliElement.setElement(e);
        return cauliElement;
    }

    @Override
    public IElement child(String location, int index) {
        WebElement e = (WebElement)this.element.findElements(By.partialLinkText((String)location)).get(index);
        CauliElement cauliElement = new CauliElement(this.getBrowser());
        cauliElement.setElement(e);
        return cauliElement;
    }

    @Override
    public CauliElements children(String location) {
        CauliElements cauliElements = new CauliElements(this.getBrowser(), location);
        cauliElements.setId(location);
        return cauliElements;
    }

    @Override
    public void contextClick() {
        ActionListenerProxy.getDispatcher().beforeContextClick();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904contextClick\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904contextClick\u5931\u8d25\uff01");
        }
        this.actions.contextClick(this.element).build().perform();
        ActionListenerProxy.getDispatcher().afterContextClick();
    }

    @Override
    public void setElement(WebElement element) {
        this.element = element;
    }

    @Override
    public void keyPress(Keys key) {
        ActionListenerProxy.getDispatcher().beforekeyPress();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e\u5931\u8d25\uff01");
        }
        this.element.sendKeys(new CharSequence[]{key});
        this.logger.info("[" + this.id + "]\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e");
        ActionListenerProxy.getDispatcher().afterkeyPress();
    }

    @Override
    public void release() {
        ActionListenerProxy.getDispatcher().beforeRelease();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u9f20\u6807\u6216\u8005\u6309\u952e\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u9f20\u6807\u6216\u8005\u6309\u952e\u5931\u8d25\uff01");
        }
        this.actions.release(this.element).build().perform();
        this.logger.info("[" + this.id + "]\u5143\u7d20\u5904\u677e\u5f00\u9f20\u6807\u6216\u8005\u6309\u952e");
        ActionListenerProxy.getDispatcher().afterRelease();
    }

    @Override
    public void keyPress(String keys) {
        ActionListenerProxy.getDispatcher().beforekeyPress();
        if (!this.isExist()) {
            this.logger.error("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.id + "]\u5143\u7d20\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e\u5931\u8d25\uff01");
        }
        this.element.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{keys})});
        this.logger.info("[" + this.id + "]\u5143\u7d20\u5904\u6309\u4f4f\u5de6\u952e");
        ActionListenerProxy.getDispatcher().afterkeyPress();
    }
}

