/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.element;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.element.CauliElement;
import org.cauli.ui.selenium.element.LocationParse;
import org.cauli.ui.selenium.element.WebElementTransfer;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class CauliElements {
    private List<CauliElement> elements;
    private String id;
    private IBrowser browser;
    private String location;

    public CauliElements(IBrowser browser, String location) {
        this.browser = browser;
        this.location = location;
        this.locateElements();
    }

    public CauliElements(IBrowser browser) {
        this.browser = browser;
        this.elements = null;
    }

    private void locateElements() {
        WebDriver driver = this.browser.getCurrentBrowserDriver();
        try {
            if (this.browser.isUseJQuery()) {
                if (this.location.contains("->")) {
                    By by = LocationParse.parseLocation(this.location, driver.getPageSource());
                    List webElements = driver.findElements(by);
                    this.elements = WebElementTransfer.transferWebElements(webElements, this.browser);
                } else {
                    List<WebElement> webElements = this.jquery(this.location, this.browser);
                    this.elements = WebElementTransfer.transferWebElements(webElements, this.browser);
                }
            } else {
                List webElements = driver.findElements(LocationParse.parseLocation(this.location, driver.getPageSource()));
                this.elements = WebElementTransfer.transferWebElements(webElements, this.browser);
            }
        }
        catch (Exception e) {
            this.elements = null;
        }
    }

    protected List<WebElement> jquery(String jquery, IBrowser browser) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("jquery.js");
        String jqueryJs = null;
        try {
            jqueryJs = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        WebDriver driver = browser.getCurrentBrowserDriver();
        return (List)((JavascriptExecutor)driver).executeScript(jqueryJs + "return jQuery(\"" + jquery + "\")", new Object[0]);
    }

    public CauliElement get(int index) {
        if (this.isExist()) {
            return this.elements.get(index);
        }
        throw new NoSuchElementException("\u6ca1\u6709\u627e\u5230CauliElements:" + this.location);
    }

    public int size() {
        if (this.isExist()) {
            return this.elements.size();
        }
        throw new NoSuchElementException("\u6ca1\u6709\u627e\u5230CauliElements:" + this.location);
    }

    public List<CauliElement> getCauliElements() {
        if (this.isExist()) {
            return this.elements;
        }
        throw new NoSuchElementException("\u6ca1\u6709\u627e\u5230CauliElements:" + this.location);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(IBrowser browser) {
        this.browser = browser;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isExist() {
        if (this.elements == null || this.elements.size() == 0) {
            this.locateElements();
            return this.elements != null && this.elements.size() != 0;
        }
        return true;
    }
}

