/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.element;

import jodd.util.StringUtil;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.cauli.ui.selenium.element.JSoupElement;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationParse {
    private static Logger logger = LoggerFactory.getLogger(LocationParse.class);

    public static By parseLocation(String text, String pageSource) {
        if (null == text || "".equals(text)) {
            return null;
        }
        if (text.contains("->")) {
            String[] strs = StringUtil.split((String)text, (String)"->");
            if (strs.length <= 1) {
                throw new RuntimeException("{}-> \u5b9a\u4f4d\u65b9\u5f0f\u5199\u7684\u4e0d\u6b63\u786e");
            }
            return LocationParse.getLocationType(strs[0], strs[1]);
        }
        try {
            Document document = Jsoup.parse((String)pageSource);
            Element element = document.select(text).first();
            if (element == null) {
                return null;
            }
            JSoupElement jSoupElement = new JSoupElement(element);
            return By.xpath((String)jSoupElement.toXpath());
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7684\u5143\u7d20\u683c\u5f0f\u9519\u8bef..\u8bf7\u68c0\u67e5\u683c\u5f0f...", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static By getLocationType(String by, String location) {
        try {
            By local = (By)MethodUtils.invokeStaticMethod(By.class, (String)by, (Object[])new Object[]{location});
            return local;
        }
        catch (Exception e) {
            logger.info("\u6ca1\u6709\u627e\u5230{}\u7684\u5b9a\u4f4d\u65b9\u5f0f,\u8bf7\u68c0\u67e5\u5b9a\u4f4d\u65b9\u5f0f\u4e66\u5199\u662f\u5426\u6b63\u786e...", (Object)by);
            e.printStackTrace();
            throw new NoSuchElementException("\u6ca1\u6709\u627e\u5230{}\u7684\u5b9a\u4f4d\u65b9\u5f0f,\u8bf7\u68c0\u67e5\u5b9a\u4f4d\u65b9\u5f0f\u4e66\u5199\u662f\u5426\u6b63\u786e...");
        }
    }
}

