/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.element.CauliElement;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
extends CauliElement {
    private Logger logger = LoggerFactory.getLogger(Select.class);
    public org.openqa.selenium.support.ui.Select select;

    public Select(IBrowser browser) {
        super(browser);
    }

    public Select(IBrowser browser, String location) {
        super(browser, location);
        this.select = new org.openqa.selenium.support.ui.Select(this.getElement());
    }

    public void setSelectElement(WebElement element) {
        this.setElement(element);
        this.select = new org.openqa.selenium.support.ui.Select(this.getElement());
    }

    public Select(IBrowser browser, CauliElement cauliElement) {
        super(browser, cauliElement.getLocate());
    }

    public void setSelect(org.openqa.selenium.support.ui.Select select) {
        this.select = select;
    }

    public void selectByIndex(int index) {
        if (!this.isExist()) {
            this.logger.error("\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u901a\u8fc7\u7d22\u5f15\u503c" + index + "\u67e5\u627e\u5931\u8d25\uff01");
            throw new NoSuchElementException(this.getId() + "]\u901a\u8fc7\u7d22\u5f15\u8fdb\u884c\u9009\u62e9\u7684\u65f6\u5019\u5931\u8d25\u4e86\uff0c\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u6ca1\u6709\u88ab\u627e\u5230\uff01");
        }
        this.getSelect().selectByIndex(index);
        this.logger.info("[" + this.getId() + "]\u9009\u62e9\u7b2c" + index + "\u9009\u9879\u6210\u529f\uff01");
    }

    public void selectByValue(String value) {
        if (!this.isExist()) {
            this.logger.error("\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u901a\u8fc7\u503c" + value + "\u67e5\u627e\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.getId() + "]\u901a\u8fc7\u5185\u5bb9\u67e5\u627e\u5143\u7d20\u7684\u65f6\u5019\u5931\u8d25\u4e86\uff01\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u6ca1\u6709\u88ab\u627e\u5230\uff01");
        }
        this.getSelect().selectByValue(value);
        this.logger.info("[" + this.getId() + "]\u9009\u62e9" + value + "\u6240\u5728\u9879\u6210\u529f\uff01");
    }

    public void selectByVisiableText(String text) {
        if (!this.isExist()) {
            this.logger.error("\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u901a\u8fc7\u5185\u5bb9\u503c" + text + "\u67e5\u627e\u5931\u8d25\uff01");
            throw new NoSuchElementException("[" + this.getId() + "]\u901a\u8fc7\u6807\u7b7e\u4e4b\u95f4\u7684\u5185\u5bb9\u6765\u8fdb\u884c\u67e5\u627e\u7684\u65f6\u5019\u5931\u8d25\u4e86\uff0c\u8fd9\u4e2a\u5143\u7d20\u6ca1\u6709\u88ab\u627e\u5230\uff01");
        }
        this.select.selectByVisibleText(text);
        this.logger.info(this.getId() + "]\u9009\u62e9\u503c\u4e3a" + text + "\u6240\u5728\u9879\u6210\u529f\uff01");
    }

    public int getSelectedIndex() {
        int selectedIndex = -1;
        if (this.isExist()) {
            ArrayList allItems = new ArrayList();
            WebElement selectedItem = this.getSelect().getFirstSelectedOption();
            for (int i = 0; i < allItems.size(); ++i) {
                if (!((WebElement)allItems.get(i)).equals(selectedItem)) continue;
                selectedIndex = i;
            }
            this.logger.info("[" + this.getId() + "]\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u7d22\u5f15\u503c\u6210\u529f\uff01");
            return selectedIndex;
        }
        this.logger.error("\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u7d22\u5f15\u503c\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.getId() + "]\u83b7\u53d6\u5f53\u524d\u9879\u7684\u7d22\u5f15\u503c\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u9519\u8bef\uff01\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728");
    }

    public String getSelectedValue() {
        String value = null;
        if (this.isExist()) {
            value = this.getSelect().getFirstSelectedOption().getText();
            this.logger.info("[" + this.getId() + "]\u83b7\u5f97\u9009\u4e2d\u9879\u7684\u7d22\u5f15\u503c\u6210\u529f\uff01");
            return value;
        }
        this.logger.error("\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u83b7\u5f97\u5f53\u524d\u9009\u4e2d\u9879\u5185\u5bb9\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.getId() + "]\u83b7\u53d6\u5f53\u524d\u9879\u7684\u5185\u5bb9\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u9519\u8bef\uff01\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8fd9\u4e2a\u5143\u7d20\u5b9a\u4f4d\u9519\u8bef\u6ca1\u6709\u627e\u5230\uff01");
    }

    public String[] getSelectedValues() {
        if (this.isExist()) {
            List selectedItems = this.getSelect().getAllSelectedOptions();
            String[] values = new String[selectedItems.size()];
            for (int i = 0; i < selectedItems.size(); ++i) {
                values[i] = ((WebElement)selectedItems.get(i)).getText();
            }
            this.logger.info("[" + this.getId() + "]\u83b7\u5f97\u5168\u90e8\u9009\u4e2d\u9879\u5185\u5bb9\u6210\u529f");
            return values;
        }
        this.logger.error("\u5143\u7d20\u6ca1\u6709\u627e\u5230\uff0c\u83b7\u5f97\u5185\u5bb9\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.getId() + "]\u83b7\u53d6\u591a\u4e2a\u5143\u7d20\u7684\u65f6\u5019\u5931\u8d25\u4e86\uff01\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u6ca1\u6709\u88ab\u627e\u5230\uff01");
    }

    public int[] getSelectedIndexs() {
        int[] indexs = null;
        if (this.isExist()) {
            List selectedItems = this.getSelect().getAllSelectedOptions();
            List allItems = this.getSelect().getOptions();
            indexs = new int[selectedItems.size()];
            block0: for (int i = 0; i < selectedItems.size(); ++i) {
                for (int j = 0; j < selectedItems.size(); ++j) {
                    if (!((WebElement)selectedItems.get(i)).equals(allItems.get(j))) continue;
                    indexs[i] = j;
                    continue block0;
                }
            }
            this.logger.info("[" + this.getId() + "]\u83b7\u5f97\u5168\u90e8\u9009\u4e2d\u9879\u5185\u5bb9\u6210\u529f");
            return indexs;
        }
        this.logger.error("\u5143\u7d20\u6ca1\u6709\u627e\u5230\uff0c\u83b7\u5f97\u7d22\u5f15\u503c\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.getId() + "]\u83b7\u53d6\u591a\u4e2a\u7d22\u5f15\u503c\u7684\u65f6\u5019\u5931\u8d25\uff01\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8fd9\u4e2a\u5143\u7d20\u6ca1\u6709\u627e\u5230\uff01");
    }

    public int getComoboBoxSize() {
        int size = -1;
        if (this.isExist()) {
            size = this.getSelect().getOptions().size();
            this.logger.info("[" + this.getId() + "]\u5f97\u5230comobox\u7684\u5927\u5c0f\u4e3a-->" + size);
            return size;
        }
        this.logger.error("\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u8fd4\u56decomobox\u7684\u5927\u5c0f\u5931\u8d25\uff01");
        throw new NoSuchElementException("[" + this.getId() + "]\u83b7\u53d6\u63a7\u4ef6\u5927\u5c0f\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u9519\u8bef\uff01\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728");
    }

    public void selectByRandomIndex() {
        if (!this.isExist()) {
            this.logger.error("[" + this.getId() + "]\u83b7\u53d6\u63a7\u4ef6\u5927\u5c0f\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u9519\u8bef\uff01\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff01");
            throw new NoSuchElementException("[" + this.getId() + "]\u83b7\u53d6\u63a7\u4ef6\u5927\u5c0f\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u9519\u8bef\uff01\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff01");
        }
        Random r = new Random();
        int max = this.getSelect().getOptions().size();
        int random = r.nextInt(max);
        this.getSelect().selectByIndex(random);
        this.logger.info("[" + this.getId() + "]\u9009\u62e9\u4e86\u7b2c" + this.getSelectedIndex() + "\u9879\uff0c\u5e76\u4e14\u503c\u4e3a" + this.getSelectedValue());
    }

    public org.openqa.selenium.support.ui.Select getSelect() {
        return this.select;
    }
}

