/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.element;

import java.util.ArrayList;
import java.util.List;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.element.CauliElement;
import org.cauli.ui.selenium.element.IElement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
extends CauliElement {
    private Logger logger = LoggerFactory.getLogger(Table.class);

    public Table(IBrowser browser) {
        super(browser);
    }

    public Table(IBrowser browser, String location) {
        super(browser, location);
    }

    public Table(IBrowser browser, CauliElement cauliElement) {
        super(browser, cauliElement.getLocate());
    }

    public String getTableContent(int row, int col) {
        String content = null;
        if (this.isExist()) {
            try {
                content = this.getElement().findElement(By.xpath((String)(".//tr[" + row + "]/td[" + col + "]"))).getText();
                this.logger.info("[" + this.getId() + "]\u7b2c" + row + "\u884c\uff0c\u7b2c" + col + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u6210\u529f\uff01");
            }
            catch (Exception e) {
                this.logger.info("[[" + this.getId() + "]\u7b2c" + row + "\u884c\uff0c\u7b2c" + col + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u5931\u8d25\uff01\u627e\u4e0d\u5230\u8fd9\u4e2atable\u5143\u7d20\uff01", (Throwable)e);
            }
            return content;
        }
        this.logger.error("\u7b2c" + row + "\u884c\uff0c\u7b2c" + col + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u6210\u529f\uff01");
        throw new RuntimeException("[" + this.getId() + "]\u83b7\u5f97table\u5185\u7684\u6570\u636e\u7684\u65f6\u5019\u51fa\u73b0\u9519\u8bef\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\u5143\u7d20\u6ca1\u6709\u88ab\u627e\u5230\uff01");
    }

    public IElement cell(int row, int col) {
        if (this.isExist()) {
            CauliElement cauliElement = new CauliElement(this.getBrowser());
            cauliElement.setElement(this.getElement().findElement(By.xpath((String)(".//tr[" + row + "]/td[" + col + "]"))));
            return cauliElement;
        }
        throw new RuntimeException("[" + this.getId() + "]\u83b7\u5f97table\u5185\u7684\u6570\u636e\u7684\u65f6\u5019\u51fa\u73b0\u9519\u8bef\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\u5143\u7d20\u6ca1\u6709\u88ab\u627e\u5230\uff01");
    }

    public String getTableTitle(int row, int col) {
        String content = null;
        if (this.isExist()) {
            try {
                content = this.getElement().findElement(By.xpath((String)(".//tr[" + row + "]/th{" + col + "]"))).getText();
                this.logger.info("[" + this.getId() + "]\u7b2c" + (row + 1) + "\u884c\uff0c\u7b2c" + (col + 1) + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u6210\u529f\uff01");
            }
            catch (Exception e) {
                this.logger.info("[" + this.getId() + "]\u7b2c" + (row + 1) + "\u884c\uff0c\u7b2c" + (col + 1) + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u5931\u8d25\uff01\u627e\u4e0d\u5230\u8fd9\u4e2atable\u5143\u7d20\uff01");
            }
            return content;
        }
        this.logger.error("\u7b2c" + (row + 1) + "\u884c\uff0c\u7b2c" + (col + 1) + "\u5217\u7684\u5143\u7d20\u83b7\u53d6\u6210\u529f\uff01");
        throw new RuntimeException("[" + this.getId() + "]\u83b7\u5f97table\u5185\u7684\u6570\u636e\u7684\u65f6\u5019\u51fa\u73b0\u9519\u8bef\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\u5143\u7d20\u6ca1\u6709\u88ab\u627e\u5230\uff01");
    }

    public List<String> getTableContentByColumn(int col) {
        if (this.isExist()) {
            try {
                ArrayList<String> contents = new ArrayList<String>();
                List cells = this.getElement().findElements(By.xpath((String)(".//td{" + (col + 1) + "]")));
                for (WebElement cell : cells) {
                    contents.add(cell.getText());
                }
                this.logger.info("[" + this.getId() + "]\u7b2c" + col + "\u5217\u7684\u4fe1\u606f\u83b7\u5f97\u6210\u529f\uff01");
                return contents;
            }
            catch (Exception e) {
                this.logger.error("\u7b2c" + col + "\u5217\u7684\u4fe1\u606f\u83b7\u5f97\u5931\u8d25\uff01\uff01");
            }
        } else {
            this.logger.error(">>[" + this.getId() + "]\u7b2c" + col + "\u5217\u7684\u4fe1\u606f\u83b7\u5f97\u5931\u8d25\uff01\uff01\u5143\u7d20\u6ca1\u6709\u627e\u5230\uff01");
            throw new RuntimeException("[" + this.getId() + "]\u67e5\u627e\u8fd9\u4e2a\u5143\u7d20\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u9519\u8bef\uff0c\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff0c\u6ca1\u6709\u627e\u5230\u5143\u7d20\uff01");
        }
        return null;
    }

    public List<List<String>> getAllTableContext() {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        int rowCount = 0;
        if (this.isExist()) {
            try {
                while (this.getElement().findElements(By.xpath((String)(".//tr[" + (rowCount + 1) + "]"))).size() != 0) {
                    contents.add(this.getTableContentByRow(rowCount));
                    this.logger.info("[" + this.getId() + "]\u7b2c" + ++rowCount + "\u884c\u7684\u6240\u6709\u4fe1\u606f\u83b7\u5f97\u6210\u529f\uff01");
                }
            }
            catch (Exception e) {
                this.logger.info("\u7b2c" + rowCount + "\u884c\u7684\u6240\u6709\u4fe1\u606f\u83b7\u5f97\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u8fd9\u4e2atable\u5185\u7684\u8981\u67e5\u627e\u7684\u5143\u7d20\uff01");
            }
            return contents;
        }
        this.logger.info("\u7b2c" + rowCount + "\u884c\u7684\u6240\u6709\u4fe1\u606f\u83b7\u5f97\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u8fd9\u4e2atable\u5143\u7d20\uff01");
        throw new RuntimeException("[" + this.getId() + "]\u67e5\u627etable\u7684\u6240\u6709\u5143\u7d20\u7684\u65f6\u5019\u51fa\u73b0\u9519\u8bef\uff01\u53ef\u80fd\u8fd9\u4e2a\u5143\u7d20\u4e0d\u5b58\u5728\uff01");
    }

    private List<String> getTableContentByRow(int row) {
        ArrayList<String> contents = new ArrayList<String>();
        if (this.isExist()) {
            try {
                WebElement rowCell = this.getElement().findElement(By.xpath((String)(".//tr[" + (row + 1) + "]")));
                List cells = rowCell.findElements(By.xpath((String)".//td"));
                for (WebElement cell : cells) {
                    contents.add(cell.getText());
                }
                this.logger.info("[" + this.getId() + "]\u7b2c" + row + "\u884c\u7684\u4fe1\u606f\u83b7\u5f97\u6210\u529f\uff01");
            }
            catch (Exception e) {
                this.logger.info("\u7b2c" + row + "\u884c\u7684\u4fe1\u606f\u83b7\u5f97\u5931\u8d25\uff01\u627e\u4e0d\u5230table\u5185\u7684\u8981\u67e5\u627e\u7684\u7684\u5143\u7d20\uff01");
            }
            return contents;
        }
        this.logger.info("\u7b2c" + row + "\u884c\u7684\u4fe1\u606f\u83b7\u5f97\u5931\u8d25\uff01\u627e\u4e0d\u5230\u8fd9\u4e2atable\u7684\u5143\u7d20\uff01");
        throw new RuntimeException("[" + this.getId() + "]\u67e5\u627etable\u7684\u503c\u65f6\u51fa\u73b0\u4e86\u9519\u8bef\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8fd9\u4e2atable\u5143\u7d20\u5b9a\u4f4d\u9519\u8bef\uff01\u6ca1\u6709\u627e\u5230\u8fd9\u4e2a\u5143\u7d20");
    }
}

