/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.page;

import org.cauli.ui.FrameLocateType;
import org.cauli.ui.annotation.FindFrame;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.page.ICurrentPage;
import org.cauli.ui.selenium.page.SourcePage;

public class Frame<T extends ICurrentPage>
extends SourcePage {
    private String locate;
    private int index;
    private T parent;

    public Frame(IBrowser browser, T parent) throws Exception {
        super(browser);
        this.parent = parent;
        this.init();
    }

    public Frame(IBrowser browser, T parent, int index) throws Exception {
        super(browser);
        this.parent = parent;
        this.index = index;
        this.initIndexLocate();
    }

    public Frame(IBrowser browser, T parent, String locate) throws Exception {
        super(browser);
        this.parent = parent;
        this.locate = locate;
        this.initIndexLocate();
    }

    private void initIndexLocate() {
        this.getBrowser().selectFrame(this.index);
    }

    private void initLocate() {
        this.getBrowser().selectFrame(this.locate);
    }

    public String getLocate() {
        return this.locate;
    }

    public void setLocate(String locate) {
        this.locate = locate;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void toDefautlContent() {
        this.getBrowser().getCurrentBrowserDriver().switchTo().defaultContent();
    }

    private void init() {
        FindFrame findFrame = this.getClass().getAnnotation(FindFrame.class);
        if (findFrame != null) {
            FrameLocateType frameLocateType = findFrame.type();
            if (frameLocateType == FrameLocateType.INDEX) {
                this.index = Integer.parseInt(findFrame.value());
                this.parent.getBrowser().selectFrame(this.index);
            } else if (frameLocateType == FrameLocateType.LOCATE) {
                this.locate = findFrame.value();
                this.parent.getBrowser().selectFrame(this.locate);
            }
        }
    }

    public T getParent() {
        return this.parent;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }
}

