/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.page;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cauli.ui.exception.FrameEnterException;
import org.cauli.ui.selenium.PageHelper;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.element.CauliElement;
import org.cauli.ui.selenium.element.CauliElements;
import org.cauli.ui.selenium.element.IElement;
import org.cauli.ui.selenium.element.Select;
import org.cauli.ui.selenium.element.Table;
import org.cauli.ui.selenium.listener.ActionListenerProxy;
import org.cauli.ui.selenium.page.Frame;
import org.cauli.ui.selenium.page.ICurrentPage;
import org.cauli.ui.selenium.page.SubPage;
import org.junit.Assert;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Page
implements ICurrentPage {
    private Logger logger = LoggerFactory.getLogger(Page.class);
    private String commit;
    private Map<String, CauliElement> cauliElementMap = Maps.newHashMap();
    private Map<String, CauliElements> elementsMap = Maps.newHashMap();
    private Map<String, Class<? extends Frame>> frameMap = Maps.newHashMap();
    private Map<String, Class<? extends SubPage>> subPageMap = Maps.newHashMap();
    private Actions actions;
    private WebDriver currentwindow;
    private IBrowser browser;

    public WebDriver getCurrentwindow() {
        return this.currentwindow;
    }

    public Map<String, CauliElement> getCauliElementMap() {
        return this.cauliElementMap;
    }

    public void addCauliElement(CauliElement cauliElement) {
        this.cauliElementMap.put(cauliElement.getId(), cauliElement);
    }

    public void initFrameAndSubPage() {
        this.frameMap.putAll(PageHelper.getInstance().getFrameMap());
        this.subPageMap.putAll(PageHelper.getInstance().getSubPageMap());
    }

    public String getCommit() {
        return this.commit;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    @Override
    public IBrowser getBrowser() {
        return this.browser;
    }

    public Page(IBrowser browser) {
        this.browser = browser;
        this.currentwindow = browser.getCurrentBrowserDriver();
        this.actions = new Actions(this.getCurrentwindow());
        this.initFrameAndSubPage();
    }

    public Page(WebDriver driver) {
        this.currentwindow = driver;
    }

    @Override
    public void setBrowser(IBrowser browser) {
        this.browser = browser;
        this.currentwindow = browser.getCurrentBrowserDriver();
    }

    @Override
    public <T> T frame(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(ICurrentPage.class).newInstance(this);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Frame frame(int index) throws FrameEnterException {
        try {
            return new Frame<Page>(this.browser, this, index);
        }
        catch (Exception e) {
            this.logger.error("\u5207\u6362Frame[\u7d22\u5f15:{}]\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:{}", (Object)index, (Object)e);
            throw new FrameEnterException("\u65e0\u6cd5\u5207\u5165Frame,\u7d22\u5f15:" + index, e);
        }
    }

    @Override
    public Frame frame(String locate) throws FrameEnterException {
        try {
            return new Frame<Page>(this.browser, this, locate);
        }
        catch (Exception e) {
            this.logger.error("\u5207\u6362Frame[{}]\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:{}", (Object)locate, (Object)e);
            throw new FrameEnterException("\u65e0\u6cd5\u5207\u5165Frame" + locate, e);
        }
    }

    @Override
    public Set<Cookie> getAllCookies() {
        return this.currentwindow.manage().getCookies();
    }

    @Override
    public void deleteAllCookies() {
        this.currentwindow.manage().deleteAllCookies();
        this.logger.info("[" + this.commit + "]\u8fdb\u884c\u4e86\u5220\u9664\u6240\u6709cookie\u7684\u64cd\u4f5c");
    }

    @Override
    public String getTitle() {
        return this.currentwindow.getTitle();
    }

    @Override
    public String getUrl() {
        return this.currentwindow.getCurrentUrl();
    }

    @Override
    public String getCookieByName(String name) {
        return this.currentwindow.manage().getCookieNamed(name).getValue();
    }

    public static <T> T page(Class<T> clazz) {
        try {
            Object currentpage = Class.forName(clazz.getName()).newInstance();
            return (T)currentpage;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u8fd9\u4e2aclass\u7c7b" + clazz.getName() + ",\u8bf7\u68c0\u67e5\u7c7b\u662f\u5426\u88ab\u52a0\u8f7d\u6216\u8005\u7c7b\u540d\u662f\u5426\u6b63\u786e", e);
        }
    }

    @Override
    public void open(String url) {
        this.currentwindow.get(url);
        this.logger.info("[" + this.commit + "]\u9875\u9762\u8df3\u8f6c\u5230\u4e86\u9875\u9762" + url);
    }

    @Override
    public <T extends IElement> T element(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(this.getBrowser().getClass());
            return (T)((IElement)constructor.newInstance(this.getBrowser()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchElementException("\u6ca1\u6709\u627e\u5230\u6b64\u7c7b\u578b\u7684\u5143\u7d20:" + clazz.getName(), (Throwable)e);
        }
    }

    @Override
    public Select select(String location) {
        Select select;
        if (location.startsWith("@")) {
            select = new Select(this.getBrowser());
            select.setSelectElement(this.cauliElementMap.get(StringUtils.substringBefore((String)location, (String)"@")).getElement());
        } else {
            select = new Select(this.getBrowser(), location);
        }
        return select;
    }

    protected Map<String, CauliElements> getElementsMap() {
        return this.elementsMap;
    }

    protected void setElementsLists(Map<String, CauliElements> elementsLists) {
        this.elementsMap = elementsLists;
    }

    @Override
    public IElement element(String location) {
        if (StringUtils.startsWith((CharSequence)location, (CharSequence)"@")) {
            String id = StringUtils.substringAfter((String)location, (String)"@");
            if (this.cauliElementMap.get(id) != null) {
                return this.getCauliElementMap().get(id);
            }
        } else {
            return new CauliElement(this.getBrowser(), location);
        }
        return null;
    }

    @Override
    public void assertAlert() {
        try {
            this.browser.getCurrentBrowserDriver().switchTo().alert();
            this.logger.info("\u5f53\u524d\u9875\u9762\u627e\u5230\u4e86alert\uff0c\u6821\u9a8c\u6210\u529f\uff01");
        }
        catch (NoAlertPresentException e) {
            this.logger.error("\u5f53\u524d\u9875\u9762\u6ca1\u6709\u627e\u5230\u4e86alert\uff0c\u6821\u9a8c\u5931\u8d25\uff01");
            Assert.fail();
        }
    }

    @Override
    public void assertTextNotPresent(String text) {
        if (this.getPageSource().contains(text)) {
            this.logger.info("\u5f53\u524d\u9875\u9762\u627e\u5230\u6307\u5b9a\u7684\u5185\u5bb9\uff0c\u6821\u9a8c\u6210\u529f\uff01");
        } else {
            this.logger.error("\u5f53\u524d\u9875\u9762\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u5185\u5bb9" + text + "\uff0c\u6821\u9a8c\u5931\u8d25\uff01");
            Assert.fail();
        }
    }

    @Override
    public void assertTitle(String title) {
        if (this.getTitle().equals(title)) {
            this.logger.info("\u5f53\u524d\u9875\u9762\u7684title\u503c[" + title + "]\u6821\u9a8c\u6210\u529f\uff0c\u6821\u9a8c\u6210\u529f\uff01");
        } else {
            this.logger.error("\u5f53\u524d\u9875\u9762title\u503c[" + title + "]\u6821\u9a8c\u5931\u8d25\uff0c\u65ad\u8a00\u5931\u8d25\uff01");
            Assert.fail();
        }
    }

    @Override
    public void assertTextPresent(String text) {
        if (this.getPageSource().contains(text)) {
            this.logger.info("\u5f53\u524d\u9875\u9762\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5185\u5bb9\uff0c\u6821\u9a8c\u6210\u529f\uff01");
        } else {
            this.logger.error("\u5f53\u524d\u9875\u9762\u627e\u5230\u4e86\u6307\u5b9a\u5185\u5bb9" + text + "\uff0c\u6821\u9a8c\u5931\u8d25\uff01");
            Assert.fail();
        }
    }

    @Override
    public String getPageSource() {
        return this.currentwindow.getPageSource();
    }

    @Override
    public String dealAlert() {
        ActionListenerProxy.getDispatcher().beforedealAlert();
        String alerMessage = null;
        try {
            Alert alert = this.browser.getCurrentBrowserDriver().switchTo().alert();
            alerMessage = alert.getText();
            alert.accept();
            ActionListenerProxy.getDispatcher().afterdealAlert();
            return alerMessage;
        }
        catch (Exception e) {
            ActionListenerProxy.getDispatcher().afterdealAlert();
            this.logger.warn("[" + this.commit + "]\u6ca1\u6709\u627e\u5230alert\u7a97\u53e3\uff0c\u7a0b\u5e8f\u5c06\u7ee7\u7eed\u8fd0\u884c\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u4ee3\u7801\u662f\u5426\u6b63\u786e");
            return null;
        }
    }

    @Override
    public String dealConfirm(boolean isyes) {
        ActionListenerProxy.getDispatcher().beforedealConfirm();
        String alerMessage = null;
        try {
            Alert alert = this.browser.getCurrentBrowserDriver().switchTo().alert();
            alerMessage = alert.getText();
            if (isyes) {
                alert.accept();
            } else {
                alert.dismiss();
            }
            ActionListenerProxy.getDispatcher().afterdealConfirm();
            return alerMessage;
        }
        catch (Exception e) {
            ActionListenerProxy.getDispatcher().afterdealConfirm();
            this.logger.warn("[" + this.commit + "]\u6ca1\u6709\u627e\u5230comfirm\u7a97\u53e3\uff0c\u7a0b\u5e8f\u5c06\u7ee7\u7eed\u8fd0\u884c\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u4ee3\u7801\u662f\u5426\u6b63\u786e");
            return null;
        }
    }

    @Override
    public String dealPrompt(boolean isyes, String text) {
        ActionListenerProxy.getDispatcher().beforedealPrompt();
        String alerMessage = null;
        try {
            Alert alert = this.browser.getCurrentBrowserDriver().switchTo().alert();
            alert.sendKeys(text);
            alerMessage = alert.getText();
            if (isyes) {
                alert.accept();
            } else {
                alert.dismiss();
            }
            ActionListenerProxy.getDispatcher().afterdealPrompt();
            return alerMessage;
        }
        catch (Exception e) {
            ActionListenerProxy.getDispatcher().afterdealPrompt();
            this.logger.warn("[" + this.commit + "]\u6ca1\u6709\u627e\u5230prompt\u7a97\u53e3\uff0c\u7a0b\u5e8f\u5c06\u7ee7\u7eed\u8fd0\u884c\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u4ee3\u7801\u662f\u5426\u6b63\u786e");
            return null;
        }
    }

    @Override
    public Object runJavaScript(String js, Object ... objects) {
        return ((JavascriptExecutor)this.currentwindow).executeScript(js, objects);
    }

    @Override
    public Object runAsynJavaScript(String js, Object ... objects) {
        return ((JavascriptExecutor)this.currentwindow).executeAsyncScript(js, objects);
    }

    @Override
    public ICurrentPage openNewWindow(String url) {
        this.runJavaScript("window.open(\"" + url + "\")", new Object[0]);
        this.logger.info("\u5728\u65b0\u7684\u7a97\u53e3\u6253\u5f00\u4e86\u94fe\u63a5" + url);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.browser.selectLastOpenedPage();
        return this.browser.currentPage();
    }

    @Override
    public WebDriver getCurrentWindow() {
        return this.browser.getCurrentBrowserDriver();
    }

    public void setCurrentwindow(WebDriver currentwindow) {
        this.currentwindow = currentwindow;
    }

    @Override
    public <T extends IElement> T element(Class<T> clazz, String location) {
        block4: {
            try {
                if (StringUtils.startsWith((CharSequence)location, (CharSequence)"@")) {
                    String id = StringUtils.substringAfter((String)location, (String)"@");
                    CauliElement element = this.getCauliElementMap().get(id);
                    if (element != null) {
                        Constructor<T> ctor1 = clazz.getConstructor(IBrowser.class);
                        IElement t = (IElement)ctor1.newInstance(this.getBrowser());
                        t.setElement(element.getElement());
                    }
                    break block4;
                }
                Constructor<T> ctor = clazz.getConstructor(IBrowser.class, String.class);
                return (T)((IElement)ctor.newInstance(this.getBrowser(), location));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IElement $(String jquery) {
        CauliElement cauliElement = new CauliElement(this.browser, jquery);
        cauliElement.setId(jquery);
        return cauliElement;
    }

    @Override
    public void keypress(Keys key) {
        this.actions.sendKeys(new CharSequence[]{key}).perform();
    }

    @Override
    public void release() {
        this.actions.release().build().perform();
    }

    @Override
    public Table table(String location) {
        Table table = null;
        if (StringUtils.startsWith((CharSequence)location, (CharSequence)"@")) {
            String id = StringUtils.substringAfter((String)location, (String)"@");
            if (this.getCauliElementMap().get(id) != null) {
                table = new Table(this.getBrowser(), this.getCauliElementMap().get(id));
            }
        } else {
            table = new Table(this.getBrowser(), location);
        }
        return table;
    }

    @Override
    public CauliElements elements(String location) {
        CauliElements cauliElements = null;
        if (StringUtils.startsWith((CharSequence)location, (CharSequence)"@")) {
            String id = StringUtils.substringAfter((String)location, (String)"@");
            if (this.getCauliElementMap().get(id) != null) {
                cauliElements = this.elementsMap.get(location);
            }
        } else {
            cauliElements = new CauliElements(this.getBrowser(), location);
        }
        return cauliElements;
    }

    @Override
    public void addCauliElements(CauliElements cauliElements) {
        this.elementsMap.put(cauliElements.getId(), cauliElements);
    }

    @Override
    public void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

