/*
 * Decompiled with CFR 0.152.
 */
package org.cauli.ui.selenium.page;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import jodd.util.StringUtil;
import org.cauli.ui.annotation.Commit;
import org.cauli.ui.annotation.Find;
import org.cauli.ui.annotation.Source;
import org.cauli.ui.selenium.LocateSource;
import org.cauli.ui.selenium.browser.IBrowser;
import org.cauli.ui.selenium.element.CauliElement;
import org.cauli.ui.selenium.element.CauliElements;
import org.cauli.ui.selenium.element.IElement;
import org.cauli.ui.selenium.page.CurrentPage;
import org.cauli.ui.source.ElementEntity;
import org.cauli.ui.source.PageEntity;
import org.cauli.ui.source.PagesEntity;
import org.springframework.util.ResourceUtils;

public abstract class SourcePage
extends CurrentPage
implements LocateSource {
    private String pageCommit;
    private String configUrl;
    private String configTitle;

    public SourcePage(IBrowser browser) throws Exception {
        super(browser);
        this.setBrowser(browser);
        if (this.getClass().isAnnotationPresent(Commit.class)) {
            Commit commit = this.getClass().getAnnotation(Commit.class);
            this.pageCommit = commit.value();
            this.configTitle = commit.title();
            this.configUrl = commit.url();
            if (!StringUtil.isEmpty((CharSequence)this.configTitle)) {
                this.getBrowser().selectWindowContainsTitle(this.configTitle);
            } else {
                this.getBrowser().selectWindowContainsUrl(this.configUrl);
            }
        } else {
            throw new Exception(this.getClass().getSimpleName() + "\u5fc5\u987b\u5b9a\u4e49Commimt\u6ce8\u89e3\u4fe1\u606f");
        }
        this.init();
        this.initFrameAndSubPage();
    }

    public String getConfigUrl() {
        return this.configUrl;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    public String getConfigTitle() {
        return this.configTitle;
    }

    public void setConfigTitle(String configTitle) {
        this.configTitle = configTitle;
    }

    public void setPageCommit(String pageCommit) {
        this.pageCommit = pageCommit;
    }

    public String getPageCommit() {
        return this.pageCommit;
    }

    private void init() throws Exception {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(Find.class)) continue;
            if (IElement.class.isAssignableFrom(field.getType())) {
                this.parseCauliElement(field);
                continue;
            }
            if (field.getType() == CauliElements.class) {
                this.parseCauliElements(field);
                continue;
            }
            throw new RuntimeException("\u5c5e\u6027\u7c7b\u578b\u9519\u8bef,\u5b9a\u4e49\u7684\u5c5e\u6027\u53ea\u80fd\u591f\u4e3a\u4e34\u65f6\u5143\u7d20,\u4e3aTempElement\u7c7b\u578b:" + field.getName());
        }
        this.load();
    }

    private void parseCauliElement(Field field) {
        Find find = field.getAnnotation(Find.class);
        String id = find.id();
        if (!"".equals(find.value())) {
            String value = find.value();
            try {
                Constructor<?> constructor = field.getType().getConstructor(IBrowser.class);
                CauliElement cauliElement = (CauliElement)constructor.newInstance(this.getBrowser());
                cauliElement.setLocate(value);
                if ("".equals(id)) {
                    cauliElement.setId(value);
                } else {
                    cauliElement.setId(id);
                }
                field.set(this, cauliElement);
                this.addCauliElement(cauliElement);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseCauliElements(Field field) {
        Find find = field.getAnnotation(Find.class);
        String id = find.id();
        if (!"".equals(find.value())) {
            String location = find.value();
            CauliElements cauliElements = new CauliElements(this.getBrowser(), location);
            try {
                if ("".equals(id)) {
                    cauliElements.setId(location);
                } else {
                    cauliElements.setId(id);
                    this.addCauliElements(cauliElements);
                }
                field.set(this, cauliElements);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void load() throws Exception {
        if (this.getClass().isAnnotationPresent(Source.class)) {
            String fileName = this.getClass().getAnnotation(Source.class).value();
            File file = ResourceUtils.getFile((String)fileName);
            XStream xStream = new XStream();
            xStream.processAnnotations(new Class[]{PagesEntity.class, PageEntity.class, ElementEntity.class});
            PagesEntity pages = (PagesEntity)xStream.fromXML(file);
            for (PageEntity pageEntity : pages.getPages()) {
                if (!pageEntity.getName().equals(this.pageCommit)) continue;
                List<ElementEntity> elementEntities = pageEntity.getElements();
                for (ElementEntity elementEntity : elementEntities) {
                    CauliElement cauliElement = new CauliElement(this.getBrowser(), elementEntity.getLocate());
                    cauliElement.setId(elementEntity.getId());
                    this.addCauliElement(cauliElement);
                }
            }
        }
    }
}

