/*
 * Decompiled with CFR 0.152.
 */
package com.cflint;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFParsedStatement;
import com.cflint.config.CFLintPluginInfo;
import java.util.List;
import net.htmlparser.jericho.Element;

public class BugInfo {
    String filename;
    int line;
    int column;
    String message;
    String messageCode;
    String expression;
    String function;
    String variable;
    String severity;

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int row) {
        this.column = row;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public String toString() {
        return "BugInfo [filename=" + this.filename + ", line=" + this.line + ", column=" + this.column + ", message=" + this.message + ", messageCode=" + this.messageCode + ", expression=" + this.expression + "]";
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public static class BugInfoBuilder {
        BugInfo bugInfo = new BugInfo();
        List<CFLintPluginInfo.PluginInfoRule.PluginParameter> parameters = null;

        public void setRuleParameters(List<CFLintPluginInfo.PluginInfoRule.PluginParameter> parameters) {
            this.parameters = parameters;
        }

        public BugInfoBuilder setLine(int line) {
            this.bugInfo.line = line;
            return this;
        }

        public BugInfoBuilder setColumn(int column) {
            this.bugInfo.column = column;
            return this;
        }

        public BugInfoBuilder setMessage(String message) {
            this.bugInfo.message = message;
            return this;
        }

        public BugInfoBuilder setMessageCode(String messageCode) {
            this.bugInfo.messageCode = messageCode;
            return this;
        }

        public BugInfoBuilder setMessageInfo(CFLintPluginInfo.PluginInfoRule.PluginMessage messageInfo) {
            this.setMessageCode(messageInfo.getCode());
            this.setSeverity(messageInfo.getSeverity());
            this.setMessage(messageInfo.getMessageText());
            return this;
        }

        public BugInfoBuilder setFilename(String filename) {
            this.bugInfo.filename = filename;
            return this;
        }

        public BugInfoBuilder setFunction(String function) {
            this.bugInfo.function = function;
            return this;
        }

        public BugInfoBuilder setVariable(String variable) {
            this.bugInfo.variable = variable;
            return this;
        }

        public BugInfoBuilder setSeverity(String severity) {
            this.bugInfo.severity = severity;
            return this;
        }

        public BugInfoBuilder setExpression(String expression) {
            if (expression == null) {
                expression = "";
            }
            this.bugInfo.expression = expression.length() > 200 ? expression.substring(0, 200) : expression;
            return this;
        }

        public BugInfo build() {
            this.doMessageText(null);
            return this.bugInfo;
        }

        public BugInfo build(CFParsedStatement expression, Element elem) {
            int elemLine = 1;
            int elemColumn = 1;
            if (elem != null) {
                elemLine = elem.getSource().getRow(elem.getBegin());
                elemColumn = elem.getSource().getColumn(elem.getBegin());
            }
            this.bugInfo.setLine(elemLine + Math.max(expression == null ? 0 : expression.getLine() - 1, 0));
            this.bugInfo.setColumn(elemColumn + Math.max(expression == null ? 0 : expression.getColumn() - 1, 0));
            this.doMessageText(elem);
            return this.bugInfo;
        }

        public BugInfo build(CFExpression expression, Element elem) {
            int elemLine = 1;
            int elemColumn = 1;
            if (elem != null) {
                elemLine = elem.getSource().getRow(elem.getBegin());
                elemColumn = elem.getSource().getColumn(elem.getBegin());
            }
            this.bugInfo.setLine(elemLine + Math.max(expression == null ? 0 : expression.getLine() - 1, 0));
            this.bugInfo.setColumn(elemColumn + Math.max(expression == null ? 0 : expression.getColumn() - 1, 0));
            this.doMessageText(elem);
            return this.bugInfo;
        }

        private final String notNull(String in) {
            if (in == null) {
                return "";
            }
            return in.trim();
        }

        private void doMessageText(Element elem) {
            String message = this.notNull(this.bugInfo.getMessage());
            if ((message = message.replaceAll("\\$\\{variable\\}", this.notNull(this.bugInfo.getVariable()))).contains("{tag}") && elem != null) {
                message = message.replaceAll("\\$\\{tag\\}", this.notNull(elem.getName()));
            }
            if (this.parameters != null) {
                for (CFLintPluginInfo.PluginInfoRule.PluginParameter param : this.parameters) {
                    message = message.replaceAll("\\$\\{" + param.getName() + "\\}", this.notNull(param.getValue()));
                }
            }
            this.setMessage(message);
        }
    }
}

