/*
 * Decompiled with CFR 0.152.
 */
package com.cflint;

import com.cflint.BugInfo;
import com.cflint.tools.CFLintFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BugList
implements Iterable<BugInfo> {
    Map<String, List<BugInfo>> bugList = new HashMap<String, List<BugInfo>>();
    private static final long serialVersionUID = -8008927848087276202L;
    CFLintFilter filter;

    public BugList(CFLintFilter filter) {
        this.filter = filter;
    }

    public CFLintFilter getFilter() {
        return this.filter;
    }

    public void setFilter(CFLintFilter filter) {
        this.filter = filter;
    }

    public boolean add(BugInfo bugInfo) {
        if (this.filter == null || this.filter.include(bugInfo)) {
            if (!this.bugList.containsKey(bugInfo.getMessageCode())) {
                this.bugList.put(bugInfo.getMessageCode(), new ArrayList());
            }
            List<BugInfo> curBugList = this.bugList.get(bugInfo.getMessageCode());
            return curBugList.add(bugInfo);
        }
        return false;
    }

    public Map<String, List<BugInfo>> getBugList() {
        return this.bugList;
    }

    public int size() {
        int size = 0;
        for (List<BugInfo> list : this.bugList.values()) {
            size += list.size();
        }
        return size;
    }

    public List<BugInfo> getFlatBugList() {
        ArrayList<BugInfo> retval = new ArrayList<BugInfo>();
        for (List<BugInfo> list : this.bugList.values()) {
            retval.addAll(list);
        }
        return retval;
    }

    @Override
    public Iterator<BugInfo> iterator() {
        return this.getFlatBugList().iterator();
    }
}

