/*
 * Decompiled with CFR 0.152.
 */
package com.cflint;

import cfml.parsing.CFMLParser;
import cfml.parsing.CFMLSource;
import cfml.parsing.cfscript.CFAssignmentExpression;
import cfml.parsing.cfscript.CFBinaryExpression;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFFullVarExpression;
import cfml.parsing.cfscript.CFFunctionExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.CFLiteral;
import cfml.parsing.cfscript.CFNestedExpression;
import cfml.parsing.cfscript.CFUnaryExpression;
import cfml.parsing.cfscript.CFVarDeclExpression;
import cfml.parsing.cfscript.script.CFCompDeclStatement;
import cfml.parsing.cfscript.script.CFCompoundStatement;
import cfml.parsing.cfscript.script.CFExpressionStatement;
import cfml.parsing.cfscript.script.CFForInStatement;
import cfml.parsing.cfscript.script.CFForStatement;
import cfml.parsing.cfscript.script.CFFuncDeclStatement;
import cfml.parsing.cfscript.script.CFFunctionParameter;
import cfml.parsing.cfscript.script.CFIfStatement;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.reporting.IErrorReporter;
import cfml.parsing.reporting.ParseException;
import com.cflint.BugInfo;
import com.cflint.BugList;
import com.cflint.StackHandler;
import com.cflint.config.CFLintConfig;
import com.cflint.config.CFLintPluginInfo;
import com.cflint.config.ConfigRuntime;
import com.cflint.config.ConfigUtils;
import com.cflint.listeners.ProgressMonitorListener;
import com.cflint.listeners.ScanProgressListener;
import com.cflint.plugins.CFLintScanner;
import com.cflint.plugins.Context;
import com.cflint.plugins.exceptions.CFLintExceptionListener;
import com.cflint.plugins.exceptions.DefaultCFLintExceptionListener;
import com.cflint.tools.CFLintFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.antlr.runtime.BitSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;

public class CFLint
implements IErrorReporter {
    private static final String FILE_ERROR = "FILE_ERROR";
    private static final String PARSE_ERROR = "PARSE_ERROR";
    final CFMLParser cfmlParser = new CFMLParser();
    StackHandler handler = new StackHandler();
    boolean inFunction = false;
    boolean inAssignment = false;
    boolean inComponent = false;
    BugList bugs;
    List<CFLintScanner> extensions = new ArrayList<CFLintScanner>();
    List<String> allowedExtensions = new ArrayList<String>();
    boolean verbose = false;
    boolean logError = false;
    boolean quiet = false;
    boolean showProgress = false;
    boolean progressUsesThread = true;
    final String cfcExtension = ".cfc";
    final String cfmExtenstion = ".cfm";
    final String resourceBundleName = "com.cflint.cflint";
    final String allowedExtensionsName = "allowedextensions";
    final String progressMonitorName = "CFLint";
    private String currentFile;
    List<ScanProgressListener> scanProgressListeners = new ArrayList<ScanProgressListener>();
    List<CFLintExceptionListener> exceptionListeners = new ArrayList<CFLintExceptionListener>();
    ConfigRuntime configuration;
    private Stack<Element> currentElement = new Stack();
    int parserCounter = 1;

    public CFLint() {
        this((CFLintConfig)null);
    }

    public CFLint(CFLintConfig configFile) {
        CFLintPluginInfo pluginInfo = ConfigUtils.loadDefaultPluginInfo();
        this.configuration = new ConfigRuntime(configFile, pluginInfo);
        for (CFLintPluginInfo.PluginInfoRule ruleInfo : this.configuration.getRules()) {
            this.extensions.add(ConfigUtils.loadPlugin(ruleInfo));
        }
        CFLintFilter filter = CFLintFilter.createFilter();
        this.bugs = new BugList(filter);
        if (this.exceptionListeners.size() == 0) {
            this.addExceptionListener(new DefaultCFLintExceptionListener(this.bugs));
        }
        try {
            this.allowedExtensions.addAll(Arrays.asList(ResourceBundle.getBundle("com.cflint.cflint").getString("allowedextensions").split(",")));
        }
        catch (Exception e) {
            this.allowedExtensions.add(".cfc");
            this.allowedExtensions.add(".cfm");
        }
        this.cfmlParser.setErrorReporter((IErrorReporter)this);
    }

    public CFLint(CFLintScanner ... bugsScanners) {
        this((ConfigRuntime)null, bugsScanners);
    }

    @Deprecated
    public CFLint(ConfigRuntime configuration, CFLintScanner ... bugsScanners) {
        this.configuration = configuration;
        for (CFLintScanner scanner : bugsScanners) {
            CFLintPluginInfo.PluginInfoRule ruleInfo;
            this.extensions.add(scanner);
            if (configuration == null || (ruleInfo = configuration.getRuleByClass(scanner.getClass())) == null) continue;
            ruleInfo.setPluginInstance(scanner);
        }
        CFLintFilter filter = CFLintFilter.createFilter();
        this.bugs = new BugList(filter);
        if (this.exceptionListeners.size() == 0) {
            this.addExceptionListener(new DefaultCFLintExceptionListener(this.bugs));
        }
        try {
            this.allowedExtensions.addAll(Arrays.asList(ResourceBundle.getBundle("com.cflint.cflint").getString("allowedextensions").split(",")));
        }
        catch (Exception e) {
            this.allowedExtensions.add(".cfc");
            this.allowedExtensions.add(".cfm");
        }
    }

    public void scan(String folder) {
        final File f = new File(folder);
        if (this.showProgress) {
            final ProgressMonitorListener progressMonitorListener = new ProgressMonitorListener("CFLint");
            this.addScanProgressListener(progressMonitorListener);
            if (this.progressUsesThread) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CFLint.this.prescan(f, 0, progressMonitorListener);
                    }
                }).start();
            } else {
                this.prescan(f, 0, progressMonitorListener);
            }
        }
        this.scan(f);
        this.fireClose();
    }

    private int prescan(File folderOrFile, int counter, ProgressMonitorListener progressMonitorListener) {
        if (folderOrFile.isDirectory()) {
            for (File file : folderOrFile.listFiles()) {
                counter = this.prescan(file, counter, progressMonitorListener);
            }
            if (counter > 10) {
                progressMonitorListener.setTotalToProcess(counter);
            }
            return counter;
        }
        if (!folderOrFile.isHidden() && this.checkExtension(folderOrFile)) {
            return counter + 1;
        }
        return counter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scan(File folderOrFile) {
        if (folderOrFile.isDirectory()) {
            for (File file : folderOrFile.listFiles()) {
                this.scan(file);
            }
            return;
        } else {
            if (folderOrFile.isHidden() || !this.checkExtension(folderOrFile)) return;
            String src = CFLint.load(folderOrFile);
            try {
                this.process(src, folderOrFile.getAbsolutePath());
                return;
            }
            catch (Exception e) {
                if (!this.quiet) {
                    if (this.verbose) {
                        e.printStackTrace(System.err);
                    } else {
                        System.err.println(e.getMessage());
                    }
                }
                if (!this.logError) return;
                System.out.println("Logging Error: FILE_ERROR");
                this.fireCFLintException(e, FILE_ERROR, folderOrFile.getAbsolutePath(), null, null, null, null);
            }
        }
    }

    protected boolean checkExtension(File file) {
        for (String ext : this.allowedExtensions) {
            if (!file.getName().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    static String load(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            return new String(b);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void process(String src, String filename) throws ParseException, IOException {
        this.fireStartedProcessing(filename);
        CFMLSource cfmlSource = new CFMLSource(src);
        List elements = cfmlSource.getChildElements();
        if (elements.size() == 0 && src.contains("component")) {
            CFScriptStatement scriptStatement = this.cfmlParser.parseScript(src);
            this.process(scriptStatement, filename, null, (String)null);
        } else {
            this.processStack(elements, " ", filename, null);
        }
        this.fireFinishedProcessing(filename);
    }

    public void processStack(List<Element> elements, String space, String filename, CFIdentifier functionName) throws ParseException, IOException {
        for (Element elem : elements) {
            Context context = new Context(filename, elem, functionName, this.inAssignment, this.handler);
            this.process(elem, space, context);
        }
    }

    public void processStack(List<Element> elements, String space, Context context) throws ParseException, IOException {
        for (Element elem : elements) {
            this.process(elem, space, context.subContext(elem));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(Element elem, String space, Context context) throws ParseException, IOException {
        context.setInComponent(this.inComponent);
        this.currentElement.push(elem);
        try {
            block22: {
                for (CFLintScanner plugin : this.extensions) {
                    try {
                        plugin.element(elem, context, this.bugs);
                        for (Context.ContextMessage message : context.getMessages()) {
                            this.reportRule(elem, null, context, plugin, message);
                        }
                        context.getMessages().clear();
                    }
                    catch (Exception e) {
                        this.reportRule(elem, null, context, plugin, e.getMessage());
                    }
                }
                if (elem.getName().equals("cfset") || elem.getName().equals("cfif")) {
                    String expr;
                    int elemLine = elem.getSource().getRow(elem.getBegin());
                    int elemColumn = elem.getSource().getColumn(elem.getBegin());
                    Pattern p = Pattern.compile("<\\w+\\s(.*[^/])/?>", 40);
                    Matcher m = p.matcher(expr = elem.getFirstStartTag().toString());
                    if (m.matches()) {
                        String cfscript = m.group(1);
                        try {
                            CFExpression expression = this.cfmlParser.parseCFExpression(cfscript, (ANTLRErrorListener)this);
                            if (expression == null) {
                                throw new NullPointerException("expression is null, parsing error");
                            }
                            this.process(expression, context.getFilename(), elem, context.getFunctionName());
                        }
                        catch (Exception npe) {
                            int line = elem.getSource().getRow(elem.getBegin());
                            int column = elem.getSource().getColumn(elem.getBegin());
                            if (this.quiet) break block22;
                            System.err.println("Error in: " + this.shortSource(elem.getSource(), line) + " @ " + line + ":");
                            if (this.verbose) {
                                npe.printStackTrace(System.err);
                            }
                        }
                    }
                } else if (elem.getName().equals("cfargument")) {
                    String name = elem.getAttributeValue("name");
                    if (name != null) {
                        this.handler.addArgument(name);
                    }
                } else if (elem.getName().equals("cfscript")) {
                    String cfscript = elem.getContent().toString();
                    CFScriptStatement scriptStatement = this.cfmlParser.parseScript(cfscript);
                    this.process(scriptStatement, context.getFilename(), elem, context.getFunctionName());
                }
            }
            if (elem.getName().equals("cffunction")) {
                this.inFunction = true;
                this.handler.push("function");
                context.setFunctionName(elem.getAttributeValue("name"));
                this.processStack(elem.getChildElements(), space + " ", context);
                this.inFunction = false;
                this.handler.pop();
                return;
            }
            if (elem.getName().equals("cfcomponent")) {
                this.inComponent = true;
                this.handler.push("component");
                context.setInComponent(true);
                this.processStack(elem.getChildElements(), space + " ", context);
                this.inComponent = false;
                this.handler.pop();
                return;
            }
            if (elem.getName().equalsIgnoreCase("cfquery")) {
                List list = elem.getAllElements();
                this.processStack(list.subList(1, list.size()), space + " ", context);
                return;
            }
            if (elem.getName().equalsIgnoreCase("cfqueryparam")) {
                if (elem.getAttributeValue("value") == null) return;
                return;
            }
            this.processStack(elem.getChildElements(), space + " ", context);
            return;
        }
        finally {
            this.currentElement.pop();
        }
    }

    private String shortSource(Source source, int line) {
        String retval;
        String string = retval = source == null ? "" : source.toString().trim();
        if (retval.length() < 300) {
            return retval;
        }
        try {
            BufferedReader sr = new BufferedReader(new StringReader(source.toString()));
            for (int i = 1; i < line; ++i) {
                sr.readLine();
            }
            return sr.readLine().replaceAll("\t", " ");
        }
        catch (Exception e) {
            return retval.substring(0, 300);
        }
    }

    public String stripLineComments(String cfscript) {
        return cfscript.replaceAll("//[^\r\n]*\r?\n", "\r\n");
    }

    private void process(CFScriptStatement expression, String filename, Element elem, CFIdentifier functionName) {
        this.process(expression, filename, elem, functionName.Decompile(0));
    }

    private void process(CFScriptStatement expression, String filename, Element elem, String functionName) {
        Context context = new Context(filename, elem, functionName, this.inAssignment, this.handler);
        context.setInComponent(this.inComponent);
        for (CFLintScanner plugin : this.extensions) {
            try {
                plugin.expression(expression, context, this.bugs);
                for (Context.ContextMessage message : context.getMessages()) {
                    this.reportRule(elem, (Object)expression, context, plugin, message);
                }
                context.getMessages().clear();
            }
            catch (Exception e) {
                this.reportRule(elem, (Object)expression, context, plugin, e.getMessage());
            }
        }
        if (expression instanceof CFCompoundStatement) {
            for (CFScriptStatement statement : ((CFCompoundStatement)expression).getStatements()) {
                this.process(statement, filename, elem, functionName);
            }
        } else if (expression instanceof CFExpressionStatement) {
            this.process(((CFExpressionStatement)expression).getExpression(), filename, elem, functionName);
        } else if (expression instanceof CFCompDeclStatement) {
            this.inComponent = true;
            this.process(((CFCompDeclStatement)expression).getBody(), filename, elem, functionName);
            this.inComponent = false;
        } else if (expression instanceof CFForStatement) {
            this.process(((CFForStatement)expression).getInit(), filename, elem, functionName);
            this.process(((CFForStatement)expression).getCond(), filename, elem, functionName);
            this.process(((CFForStatement)expression).getNext(), filename, elem, functionName);
            this.process(((CFForStatement)expression).getBody(), filename, elem, functionName);
        } else if (expression instanceof CFForInStatement) {
            this.process(((CFForInStatement)expression).getVariable(), filename, elem, functionName);
            this.process(((CFForInStatement)expression).getStructure(), filename, elem, functionName);
            this.process(((CFForInStatement)expression).getBody(), filename, elem, functionName);
        } else if (expression instanceof CFIfStatement) {
            CFIfStatement cfif = (CFIfStatement)expression;
            this.process(cfif.getCond(), filename, elem, functionName);
            this.process(cfif.getThenStatement(), filename, elem, functionName);
            if (cfif.getElseStatement() != null) {
                this.process(cfif.getElseStatement(), filename, elem, functionName);
            }
        } else if (expression instanceof CFFuncDeclStatement) {
            CFFuncDeclStatement function = (CFFuncDeclStatement)expression;
            this.inFunction = true;
            this.handler.push("function");
            if ("init".equals(function.getName())) {
                this.inFunction = false;
            }
            for (CFFunctionParameter param : function.getFormals()) {
                this.handler.addArgument(param.getName());
            }
            this.process(function.getBody(), filename, elem, function.getName());
            this.inFunction = false;
            this.handler.pop();
        }
    }

    private void process(CFExpression expression, String filename, Element elem, String functionName) {
        block14: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block13: {
                                    Context context = new Context(filename, elem, functionName, this.inAssignment, this.handler);
                                    context.setInComponent(this.inComponent);
                                    for (CFLintScanner cFLintScanner : this.extensions) {
                                        try {
                                            cFLintScanner.expression(expression, context, this.bugs);
                                            for (Context.ContextMessage message : context.getMessages()) {
                                                this.reportRule(elem, (Object)expression, context, cFLintScanner, message);
                                            }
                                            context.getMessages().clear();
                                        }
                                        catch (Exception e) {
                                            this.reportRule(elem, (Object)expression, context, cFLintScanner, e.getMessage());
                                        }
                                    }
                                    if (!(expression instanceof CFUnaryExpression)) break block13;
                                    this.process(((CFUnaryExpression)expression).getSub(), filename, elem, functionName);
                                    break block14;
                                }
                                if (!(expression instanceof CFNestedExpression)) break block15;
                                this.process(((CFNestedExpression)expression).getSub(), filename, elem, functionName);
                                break block14;
                            }
                            if (!(expression instanceof CFAssignmentExpression)) break block16;
                            this.inAssignment = true;
                            this.process(((CFAssignmentExpression)expression).getLeft(), filename, elem, functionName);
                            this.inAssignment = false;
                            this.process(((CFAssignmentExpression)expression).getRight(), filename, elem, functionName);
                            break block14;
                        }
                        if (!(expression instanceof CFBinaryExpression)) break block17;
                        this.process(((CFBinaryExpression)expression).getLeft(), filename, elem, functionName);
                        this.process(((CFBinaryExpression)expression).getRight(), filename, elem, functionName);
                        break block14;
                    }
                    if (!(expression instanceof CFFunctionExpression)) break block18;
                    CFFunctionExpression cfFunctionExpr = (CFFunctionExpression)expression;
                    for (Object expr : cfFunctionExpr.getArgs()) {
                        this.process((CFExpression)expr, filename, elem, functionName);
                    }
                    break block14;
                }
                if (!(expression instanceof CFIdentifier)) break block19;
                String name = ((CFIdentifier)expression).getName();
                this.handler.checkVariable(name);
                if (!(expression instanceof CFFullVarExpression)) break block14;
                CFFullVarExpression cFFullVarExpression = (CFFullVarExpression)expression;
                for (CFExpression expr : cFFullVarExpression.getExpressions()) {
                    if (!(expr instanceof CFFunctionExpression)) continue;
                    this.process(expr, filename, elem, functionName);
                }
                break block14;
            }
            if (expression instanceof CFVarDeclExpression) {
                this.handler.addVariable(((CFVarDeclExpression)expression).getName());
                this.process(((CFVarDeclExpression)expression).getInit(), filename, elem, functionName);
            } else if (expression instanceof CFLiteral && expression.getToken().getType() == 6) {
                for (String string : this.splitHash(expression.Decompile(0))) {
                    try {
                        CFExpression subExpression = this.cfmlParser.parseCFExpression(string, (ANTLRErrorListener)this);
                        if (expression == null) {
                            throw new NullPointerException("expression is null, parsing error");
                        }
                        this.process(subExpression, filename, elem, functionName);
                    }
                    catch (Exception npe) {
                        int line = elem.getSource().getRow(elem.getBegin());
                        int column = elem.getSource().getColumn(elem.getBegin());
                        if (this.quiet) continue;
                        System.err.println("Error in: " + this.shortSource(elem.getSource(), line) + " @ " + line + ":");
                        if (!this.verbose) continue;
                        npe.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    protected void reportRule(Element elem, Object expression, Context context, CFLintScanner plugin, String msg) {
        String[] exceptionmsg = (msg != null ? msg : "").split(":");
        String msgcode = exceptionmsg[0].trim();
        String nameVar = exceptionmsg.length > 1 ? exceptionmsg[1].trim() : null;
        this.reportRule(elem, expression, context, plugin, new Context.ContextMessage(msgcode, nameVar));
    }

    protected void reportRule(Element elem, Object expression, Context context, CFLintScanner plugin, Context.ContextMessage msg) {
        String msgcode = msg.getMessageCode();
        String nameVar = msg.getVariable();
        if (this.configuration == null) {
            throw new NullPointerException("Configuration is null");
        }
        CFLintPluginInfo.PluginInfoRule ruleInfo = this.configuration.getRuleForPlugin(plugin);
        if (ruleInfo == null) {
            throw new NullPointerException("Rule not found for " + plugin.getClass().getSimpleName());
        }
        CFLintPluginInfo.PluginInfoRule.PluginMessage msgInfo = ruleInfo.getMessageByCode(msgcode);
        if (this.configuration == null) {
            throw new NullPointerException("Message definition not found for [" + msgcode + "] in " + plugin.getClass().getSimpleName());
        }
        BugInfo.BugInfoBuilder bldr = new BugInfo.BugInfoBuilder().setMessageCode(msgcode).setVariable(nameVar).setFunction(context.getFunctionName()).setFilename(context.getFilename());
        if (msgInfo != null) {
            bldr.setSeverity(msgInfo.getSeverity());
            bldr.setMessage(msgInfo.getMessageText());
        } else {
            System.err.println("Message code: " + msgcode + " is not configured correctly.");
            bldr.setSeverity("WARNING");
            bldr.setMessage(msgcode);
        }
        if (elem != null) {
            bldr.setExpression(elem.toString());
        }
        bldr.setRuleParameters(ruleInfo.getParameters());
        if (expression instanceof CFExpression) {
            this.bugs.add(bldr.build((CFExpression)expression, elem));
        } else {
            this.bugs.add(bldr.build((CFParsedStatement)expression, elem));
        }
    }

    public BugList getBugs() {
        return this.bugs;
    }

    public List<String> getAllowedExtensions() {
        return this.allowedExtensions;
    }

    public void setAllowedExtensions(List<String> allowedExtensions) {
        this.allowedExtensions = allowedExtensions;
    }

    public void reportError(String arg0) {
        String file = this.currentFile == null ? "" : this.currentFile + "\r\n";
        System.out.println(file + "------4-" + arg0);
    }

    public void reportError(org.antlr.runtime.RecognitionException arg0) {
        String file = this.currentFile == null ? "" : this.currentFile + "\r\n";
        System.out.println(file + "-------" + arg0);
    }

    public void reportError(String[] arg0, org.antlr.runtime.RecognitionException arg1) {
        String file = this.currentFile == null ? "" : this.currentFile + "\r\n";
        System.out.println(file + "-------" + arg0);
    }

    public void reportError(org.antlr.runtime.IntStream arg0, org.antlr.runtime.RecognitionException arg1, BitSet arg2) {
        String file = this.currentFile == null ? "" : this.currentFile + "\r\n";
        System.out.println(file + "-------" + arg0);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void addScanProgressListener(ScanProgressListener scanProgressListener) {
        this.scanProgressListeners.add(scanProgressListener);
    }

    protected void fireStartedProcessing(String srcidentifier) {
        this.currentFile = srcidentifier;
        for (ScanProgressListener p : this.scanProgressListeners) {
            p.startedProcessing(srcidentifier);
        }
    }

    protected void fireFinishedProcessing(String srcidentifier) {
        for (ScanProgressListener p : this.scanProgressListeners) {
            p.finishedProcessing(srcidentifier);
        }
        this.currentFile = null;
    }

    protected void fireClose() {
        for (ScanProgressListener p : this.scanProgressListeners) {
            p.close();
        }
    }

    public void addExceptionListener(CFLintExceptionListener exceptionListener) {
        this.exceptionListeners.add(exceptionListener);
    }

    protected void fireCFLintException(Exception e, String messageCode, String filename, Integer line, Integer column, String functionName, String expression) {
        for (CFLintExceptionListener p : this.exceptionListeners) {
            p.exceptionOccurred(e, messageCode, filename, line, column, functionName, expression);
        }
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public void setProgressUsesThread(boolean progressUsesThread) {
        this.progressUsesThread = progressUsesThread;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        String file;
        String string = file = this.currentFile == null ? "" : this.currentFile + "\r\n";
        if (!this.currentElement.isEmpty()) {
            Element elem = this.currentElement.peek();
            if (line == 1) {
                line = elem.getSource().getRow(elem.getBegin());
                charPositionInLine += elem.getSource().getColumn(elem.getBegin());
            } else {
                line = elem.getSource().getRow(elem.getBegin()) + line - 1;
            }
        }
        this.fireCFLintException((Exception)e, PARSE_ERROR, this.currentFile, line, charPositionInLine, "", offendingSymbol == null ? "" : offendingSymbol.toString());
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, java.util.BitSet ambigAlts, ATNConfigSet configs) {
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, java.util.BitSet conflictingAlts, ATNConfigSet configs) {
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
    }

    public void reportError(RecognitionException re) {
        String file = this.currentFile == null ? "" : this.currentFile + "\r\n";
        System.out.println(file + "----RecognitionException ---" + re.getCtx().getSourceInterval().a + " : " + re.getCtx().getSourceInterval().b);
    }

    public void reportError(String[] tokenNames, RecognitionException re) {
        String file = this.currentFile == null ? "" : this.currentFile + "\r\n";
        System.out.println(file + "----reportError ---" + re.getCtx().getSourceInterval().a + " : " + re.getCtx().getSourceInterval().b);
    }

    public void reportError(IntStream input, RecognitionException re, BitSet follow) {
        String file = this.currentFile == null ? "" : this.currentFile + "\r\n";
        System.out.println(file + "----reportError ---");
    }

    List<String> splitHash(String input) {
        input = input + "   ";
        ArrayList<String> retval = new ArrayList<String>();
        int start = 0;
        int end = -1;
        while (start < input.length() && end < input.length()) {
            if (end > start) {
                retval.add(input.substring(start, end));
            }
            for (start = end + 1; start < input.length() && input.charAt(start) != '#'; ++start) {
            }
            end = ++start;
            while (end < input.length() && input.charAt(end) != '#') {
                if (input.charAt(++end) != '#' || input.charAt(end + 1) != '#') continue;
                end += 2;
            }
        }
        return retval;
    }
}

