/*
 * Decompiled with CFR 0.152.
 */
package com.cflint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StackHandler {
    Deque<Stack> varStack = new ArrayDeque<Stack>();
    Set<String> excludes = new HashSet<String>();

    public StackHandler() {
        this.excludes.add("VARIABLES");
        this.excludes.add("ARGUMENTS");
        this.excludes.add("SUPER");
        this.excludes.add("SESSION");
        this.excludes.add("APPLICATION");
        this.excludes.add("THIS");
        this.excludes.add("LOCAL");
        this.varStack.push(new Stack(""));
    }

    public void addVariable(String name) {
        this.varStack.peek().getVariables().add(name.toUpperCase());
    }

    public void addArgument(String name) {
        this.varStack.peek().getArguments().add(name.toUpperCase());
    }

    public boolean hasArgument(String name) {
        return this.varStack.peek().getArguments().contains(name.toUpperCase());
    }

    public void push(String pathName) {
        this.varStack.push(new Stack(pathName));
    }

    public void pop() {
        this.varStack.pop();
    }

    public Object getPluginVar(Class<?> clazz, String var) {
        String key = clazz.getName() + "_" + var;
        for (Stack vars : this.varStack) {
            if (!vars.getPluginvariables().containsKey(key)) continue;
            return vars.getPluginvariables().get(key);
        }
        return null;
    }

    public Collection<Object> getPluginAllVars(Class<?> clazz, String var) {
        ArrayList<Object> retval = new ArrayList<Object>();
        String key = clazz.getName() + "_" + var;
        for (Stack vars : this.varStack) {
            if (!vars.getPluginvariables().containsKey(key)) continue;
            Object value = vars.getPluginvariables().get(key);
            if (value instanceof Collection) {
                retval.addAll((Collection)value);
                continue;
            }
            retval.add(value);
        }
        return retval;
    }

    public void setPluginVar(Class<?> clazz, String var, Object value) {
        String key = clazz.getName() + "_" + var;
        this.varStack.peek().getPluginvariables().put(key, value);
    }

    public boolean isVariable(String name) {
        for (Stack vars : this.varStack) {
            if (!vars.getVariables().contains(name.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isArgument(String name) {
        for (Stack vars : this.varStack) {
            if (!vars.getArguments().contains(name.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean checkVariable(String name) {
        if (this.excludes.contains(name.toUpperCase())) {
            return true;
        }
        for (Stack vars : this.varStack) {
            if (vars.getReported().contains(name.toUpperCase())) {
                return true;
            }
            if (vars.getVariables().contains(name.toUpperCase())) {
                return true;
            }
            if (!vars.getArguments().contains(name.toUpperCase())) continue;
            vars.getVariables().add(name.toUpperCase());
            return true;
        }
        this.varStack.peek().getReported().add(name.toUpperCase());
        return false;
    }

    public static class Stack {
        Set<String> variables = new HashSet<String>();
        Set<String> reported = new HashSet<String>();
        Map<String, Object> pluginvariables = new HashMap<String, Object>();
        Set<String> arguments = new HashSet<String>();
        String pathName;

        public Stack(String pathName) {
            this.pathName = pathName;
        }

        public String getPathName() {
            return this.pathName;
        }

        public void setPathName(String pathName) {
            this.pathName = pathName;
        }

        public Set<String> getVariables() {
            return this.variables;
        }

        public Set<String> getArguments() {
            return this.arguments;
        }

        public Map<String, Object> getPluginvariables() {
            return this.pluginvariables;
        }

        public Set<String> getReported() {
            return this.reported;
        }
    }
}

