/*
 * Decompiled with CFR 0.152.
 */
package com.cflint;

import com.cflint.BugInfo;
import com.cflint.BugList;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XMLOutput {
    List<String> CODE_GROUPBY_FUNCTION = Arrays.asList("PARSE_ERROR");

    public void output(BugList bugList, Writer writer) throws IOException {
        writer.append("<issues>").append(System.getProperty("line.separator"));
        for (Map.Entry<String, List<BugInfo>> bugEntry : bugList.getBugList().entrySet()) {
            Iterator<BugInfo> iterator = bugEntry.getValue().iterator();
            BugInfo bugInfo = iterator.hasNext() ? iterator.next() : null;
            BugInfo prevbugInfo = null;
            while (bugInfo != null) {
                writer.append("<issue");
                writer.append(" severity=\"").append(bugEntry.getValue().get(0).getSeverity()).append("\"");
                writer.append(" id=\"").append(bugEntry.getValue().get(0).getMessageCode()).append("\"");
                writer.append(" message=\"").append(bugEntry.getValue().get(0).getMessageCode()).append("\"");
                writer.append(" category=\"CFLint\"");
                writer.append(" abbrev=\"").append(this.abbrev(bugEntry.getValue().get(0).getMessageCode())).append("\"");
                writer.append(">");
                do {
                    writer.append("<location");
                    writer.append(" file=\"").append(bugInfo.getFilename()).append("\"");
                    writer.append(" fileName=\"").append(this.filename(bugInfo.getFilename())).append("\"");
                    writer.append(" column=\"").append(Integer.valueOf(bugInfo.getColumn()).toString()).append("\"");
                    writer.append(" line=\"").append(Integer.valueOf(bugInfo.getLine()).toString()).append("\"");
                    writer.append(" message=\"").append(this.xmlEscapeText(bugInfo.getMessage())).append("\"");
                    writer.append(" variable=\"").append(this.xmlEscapeText(bugInfo.getVariable())).append("\"");
                    writer.append(">");
                    writer.append("<Expression><![CDATA[").append(bugInfo.getExpression() == null ? "" : bugInfo.getExpression().replace("<![CDATA[", "").replace("]]>", "")).append("]]></Expression>");
                    writer.append("</location>").append(System.getProperty("line.separator"));
                } while (this.isGrouped(prevbugInfo = bugInfo, bugInfo = iterator.hasNext() ? iterator.next() : null));
                writer.append("</issue>").append(System.getProperty("line.separator"));
            }
        }
        writer.append("</issues>");
        writer.close();
    }

    private boolean isGrouped(BugInfo prevbugInfo, BugInfo bugInfo) {
        if (prevbugInfo == null || bugInfo == null) {
            return false;
        }
        if (!this.safeEquals(prevbugInfo.getMessageCode(), bugInfo.getMessageCode())) {
            return false;
        }
        if (!this.safeEquals(prevbugInfo.getFilename(), bugInfo.getFilename())) {
            return false;
        }
        return this.CODE_GROUPBY_FUNCTION.contains(bugInfo.getMessageCode()) && this.safeEquals(prevbugInfo.getFunction(), bugInfo.getFunction());
    }

    private boolean safeEquals(String a, String b) {
        return a != null && b != null && a.equals(b);
    }

    public void outputFindBugs(BugList bugList, Writer writer) throws IOException, TransformerException {
        StringWriter sw = new StringWriter();
        this.output(bugList, sw);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        InputStream is = this.getClass().getResourceAsStream("/findbugs/cflint-to-findbugs.xsl");
        Transformer transformer = tFactory.newTransformer(new StreamSource(is));
        transformer.transform(new StreamSource(new StringReader(sw.toString())), new StreamResult(writer));
        writer.close();
    }

    private CharSequence filename(String filename) {
        return filename.substring(Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92)));
    }

    private CharSequence abbrev(String messageCode) {
        if (messageCode.length() <= 2) {
            return messageCode;
        }
        String[] ms = messageCode.split("_");
        if (ms.length >= 2) {
            return (ms[0].substring(0, 1) + ms[1].substring(0, 1)).toUpperCase();
        }
        return ms[0].substring(0, 2).toUpperCase();
    }

    String xmlEscapeText(String t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < t.length(); ++i) {
            char c = t.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        sb.append("&#" + c + ";");
                        continue block7;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

