/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.ant;

import com.cflint.CFLint;
import com.cflint.HTMLOutput;
import com.cflint.TextOutput;
import com.cflint.XMLOutput;
import com.cflint.config.CFLintConfig;
import com.cflint.config.ConfigUtils;
import com.cflint.tools.CFLintFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ProgressMonitor;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CFLintTask
extends Task {
    boolean showProgress;
    String includeRule;
    String excludeRule;
    File filterFile;
    File xmlFile;
    File htmlFile;
    File textFile;
    File configFile;
    String xmlStyle = "cflint";
    String htmlStyle = "plain.xsl";
    String extensions;
    boolean verbose;
    boolean quiet;
    private final List<FileSet> filesets = new ArrayList<FileSet>();

    public void execute() {
        try {
            String[] includeCodes;
            String[] excludeCodes;
            File ffile;
            CFLintConfig config = null;
            if (this.configFile != null) {
                config = ConfigUtils.unmarshal(new FileInputStream(this.configFile), CFLintConfig.class);
            }
            CFLint cflint = new CFLint(config);
            cflint.setVerbose(this.verbose);
            cflint.setQuiet(this.quiet);
            if (this.extensions != null && this.extensions.trim().length() > 0) {
                cflint.setAllowedExtensions(Arrays.asList(this.extensions.trim().split(",")));
            }
            CFLintFilter filter = CFLintFilter.createFilter();
            if (this.filterFile != null && (ffile = this.filterFile).exists()) {
                FileInputStream fis = new FileInputStream(ffile);
                byte[] b = new byte[fis.available()];
                fis.read(b);
                filter = CFLintFilter.createFilter(new String(b));
            }
            if (this.excludeRule != null && this.excludeRule.trim().length() > 0 && (excludeCodes = this.excludeRule.split(",")) != null && excludeCodes.length > 0) {
                filter.excludeCode(excludeCodes);
            }
            if (this.includeRule != null && this.includeRule.trim().length() > 0 && (includeCodes = this.includeRule.split(",")) != null && includeCodes.length > 0) {
                filter.excludeCode(includeCodes);
            }
            cflint.getBugs().setFilter(filter);
            if (this.xmlFile == null && this.htmlFile == null && this.textFile == null) {
                this.xmlFile = new File("cflint-result.xml");
            }
            if (this.xmlFile != null) {
                if (this.verbose) {
                    System.out.println("Style:" + this.xmlStyle);
                }
                if ("findbugs".equalsIgnoreCase(this.xmlStyle)) {
                    new XMLOutput().outputFindBugs(cflint.getBugs(), new FileWriter(this.xmlFile));
                } else {
                    new XMLOutput().output(cflint.getBugs(), new FileWriter(this.xmlFile));
                }
            }
            if (this.textFile != null) {
                OutputStreamWriter textwriter = this.textFile != null ? new FileWriter(this.textFile) : new OutputStreamWriter(System.out);
                new TextOutput().output(cflint.getBugs(), textwriter);
            }
            if (this.htmlFile != null) {
                try {
                    new HTMLOutput(this.htmlStyle).output(cflint.getBugs(), new FileWriter(this.htmlFile));
                }
                catch (TransformerException e) {
                    throw new IOException(e);
                }
            }
            for (FileSet fileset : this.filesets) {
                String[] includedFiles;
                int progress = 1;
                DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
                ProgressMonitor progressMonitor = this.showProgress && this.filesets.size() > 0 ? new ProgressMonitor(null, "CFLint", "", 1, ds.getIncludedFilesCount()) : null;
                for (String includedFile : includedFiles = ds.getIncludedFiles()) {
                    if (progressMonitor.isCanceled()) {
                        throw new RuntimeException("CFLint scan cancelled");
                    }
                    String filename = ds.getBasedir() + File.separator + includedFile;
                    progressMonitor.setNote("scanning " + includedFile);
                    cflint.scan(filename);
                    progressMonitor.setProgress(progress++);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String shorten(String includedFile) {
        if (includedFile == null) {
            return "";
        }
        if ((includedFile = includedFile.trim()).length() < 20) {
            return includedFile;
        }
        return ".." + includedFile.substring(includedFile.length() - 20);
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public void setIncludeRule(String includeRule) {
        this.includeRule = includeRule;
    }

    public void setExcludeRule(String excludeRule) {
        this.excludeRule = excludeRule;
    }

    public void setFilterFile(File filterFile) {
        this.filterFile = filterFile;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public void setHtmlFile(File htmlFile) {
        this.htmlFile = htmlFile;
    }

    public void setTextFile(File textFile) {
        this.textFile = textFile;
    }

    public void setXmlStyle(String xmlStyle) {
        this.xmlStyle = xmlStyle;
    }

    public void setHtmlStyle(String htmlStyle) {
        this.htmlStyle = htmlStyle;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }
}

