/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.config;

import com.cflint.plugins.CFLintScanner;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="CFLint-Plugin")
public class CFLintPluginInfo {
    List<PluginInfoRule> rules = new ArrayList<PluginInfoRule>();

    public List<PluginInfoRule> getRules() {
        return this.rules;
    }

    @XmlElement(name="ruleImpl")
    public void setRules(List<PluginInfoRule> rules) {
        this.rules = rules;
    }

    public PluginInfoRule getRuleByName(String ruleName) {
        for (PluginInfoRule rule : this.rules) {
            if (ruleName == null || !ruleName.equals(rule.getName())) continue;
            return rule;
        }
        return null;
    }

    public static class PluginInfoRule {
        String name;
        String className;
        List<PluginMessage> messages = new ArrayList<PluginMessage>();
        List<PluginParameter> parameters = new ArrayList<PluginParameter>();
        CFLintScanner pluginInstance;

        public CFLintScanner getPluginInstance() {
            return this.pluginInstance;
        }

        @XmlTransient
        public void setPluginInstance(CFLintScanner pluginInstance) {
            this.pluginInstance = pluginInstance;
        }

        public String getClassName() {
            return this.className;
        }

        @XmlAttribute(name="className")
        public void setClassName(String className) {
            this.className = className;
        }

        public List<PluginParameter> getParameters() {
            return this.parameters;
        }

        @XmlElement(name="parameter")
        public void setParameters(List<PluginParameter> parameters) {
            this.parameters = parameters;
        }

        public String getName() {
            return this.name;
        }

        public void addParameter(String name, String value) {
            PluginParameter p = new PluginParameter();
            p.setName(name);
            p.setValue(value);
            this.parameters.add(p);
        }

        @XmlAttribute(name="name")
        public void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PluginInfoRule other = (PluginInfoRule)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public List<PluginMessage> getMessages() {
            return this.messages;
        }

        @XmlElement(name="message")
        public void setMessages(List<PluginMessage> messages) {
            this.messages = messages;
        }

        public PluginMessage getMessageByCode(String messageCode) {
            for (PluginMessage message : this.messages) {
                if (messageCode == null || !messageCode.equals(message.getCode())) continue;
                return message;
            }
            return null;
        }

        public static class PluginMessage {
            String code;
            String messageText;
            String severity;

            public PluginMessage(String code) {
                this.code = code;
            }

            public PluginMessage() {
            }

            public String getCode() {
                return this.code;
            }

            @XmlAttribute(name="code")
            public void setCode(String code) {
                this.code = code;
            }

            public String getMessageText() {
                return this.messageText;
            }

            @XmlElement(name="messageText")
            public void setMessageText(String messageText) {
                this.messageText = messageText;
            }

            public String getSeverity() {
                return this.severity;
            }

            @XmlElement(name="severity")
            public void setSeverity(String severity) {
                this.severity = severity;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PluginMessage other = (PluginMessage)obj;
                return !(this.code == null ? other.code != null : !this.code.equals(other.code));
            }
        }

        public static class PluginParameter {
            String name;
            String value;

            public String getName() {
                return this.name;
            }

            @XmlAttribute(name="name")
            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            @XmlAttribute(name="value")
            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

