/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.config;

import com.cflint.config.CFLintConfig;
import com.cflint.config.CFLintPluginInfo;
import com.cflint.plugins.CFLintScanner;
import java.util.ArrayList;

public class ConfigRuntime
extends CFLintConfig {
    public ConfigRuntime() {
    }

    public ConfigRuntime(CFLintConfig config, CFLintPluginInfo pluginInfo) {
        ArrayList<CFLintPluginInfo.PluginInfoRule> rules = new ArrayList<CFLintPluginInfo.PluginInfoRule>();
        if (config != null) {
            this.includes.addAll(config.getIncludes());
            this.excludes.addAll(config.getExcludes());
            rules.addAll(config.getRules());
        }
        for (CFLintPluginInfo.PluginInfoRule rule : pluginInfo.getRules()) {
            if (rules.contains(rule)) continue;
            rules.add(rule);
        }
        if (config != null) {
            if (config.getIncludes().size() > 0) {
                block1: for (CFLintPluginInfo.PluginInfoRule rule : rules) {
                    for (CFLintPluginInfo.PluginInfoRule.PluginMessage msg : rule.getMessages()) {
                        if (!config.getIncludes().contains(msg)) continue;
                        this.getRules().add(rule);
                        continue block1;
                    }
                }
            } else {
                for (CFLintPluginInfo.PluginInfoRule rule : rules) {
                    boolean excluded = true;
                    for (CFLintPluginInfo.PluginInfoRule.PluginMessage msg : rule.getMessages()) {
                        excluded = excluded && config.getExcludes().contains(msg);
                    }
                    if (excluded) continue;
                    this.getRules().add(rule);
                }
            }
        } else {
            this.getRules().addAll(rules);
        }
    }

    public boolean isIncludeMessage(String messageCode) {
        return this.isIncludeMessage(new CFLintPluginInfo.PluginInfoRule.PluginMessage(messageCode));
    }

    public boolean isIncludeMessage(CFLintPluginInfo.PluginInfoRule.PluginMessage message) {
        if (this.includes.size() > 0) {
            return this.includes.contains(message);
        }
        return !this.excludes.contains(message);
    }

    public CFLintPluginInfo.PluginInfoRule getRuleByClass(Class<?> clazz) {
        String className = clazz.getSimpleName();
        for (CFLintPluginInfo.PluginInfoRule rule : this.getRules()) {
            if (!rule.getName().equals(className) && !className.equals(rule.getClassName())) continue;
            return rule;
        }
        return null;
    }

    public CFLintPluginInfo.PluginInfoRule getRuleForPlugin(CFLintScanner plugin) {
        for (CFLintPluginInfo.PluginInfoRule rule : this.getRules()) {
            if (rule.getPluginInstance() != plugin) continue;
            return rule;
        }
        return this.getRuleByClass(plugin.getClass());
    }
}

