/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.config;

import com.cflint.config.CFLintConfig;
import com.cflint.config.CFLintPluginInfo;
import com.cflint.plugins.CFLintScanner;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ConfigUtils {
    static JAXBContext CFLintConfigContext = null;
    static final String PLUGIN_PACKAGE = "com.cflint.plugins.core";

    public static Marshaller createMarshaller() throws JAXBException {
        if (CFLintConfigContext == null) {
            ConfigUtils.init();
        }
        return CFLintConfigContext.createMarshaller();
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        if (CFLintConfigContext == null) {
            ConfigUtils.init();
        }
        return CFLintConfigContext.createUnmarshaller();
    }

    protected static synchronized void init() throws JAXBException {
        CFLintConfigContext = JAXBContext.newInstance((Class[])new Class[]{CFLintPluginInfo.class, CFLintConfig.class});
    }

    public static String marshal(Object obj) throws JAXBException {
        StringWriter sw = new StringWriter();
        ConfigUtils.createMarshaller().marshal(obj, (Writer)sw);
        return sw.toString();
    }

    public static String marshalQuietly(Object obj) {
        try {
            return ConfigUtils.marshal(obj);
        }
        catch (JAXBException e) {
            return null;
        }
    }

    public static <E> E unmarshal(String xml, Class<E> expectedClass) throws JAXBException {
        StringWriter sw = new StringWriter();
        return (E)ConfigUtils.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    public static <E> E unmarshal(InputStream inputStream, Class<E> expectedClass) throws JAXBException {
        StringWriter sw = new StringWriter();
        return (E)ConfigUtils.createUnmarshaller().unmarshal((Reader)new InputStreamReader(inputStream));
    }

    public static CFLintPluginInfo loadDefaultPluginInfo() {
        InputStream inputStream = ConfigUtils.class.getResourceAsStream("/cflint.definition.xml");
        if (inputStream != null) {
            try {
                return ConfigUtils.unmarshal(inputStream, CFLintPluginInfo.class);
            }
            catch (JAXBException e) {
                e.printStackTrace(System.err);
            }
        }
        return new CFLintPluginInfo();
    }

    public static CFLintScanner loadPlugin(CFLintPluginInfo.PluginInfoRule ruleInfo) {
        String shortClassName = ruleInfo.getClassName() != null && ruleInfo.getClassName().trim().length() > 0 ? ruleInfo.getClassName() : ruleInfo.getName();
        String className = "com.cflint.plugins.core." + shortClassName.trim();
        try {
            Class<?> pluginClass = Class.forName(className);
            CFLintScanner plugin = (CFLintScanner)pluginClass.newInstance();
            for (CFLintPluginInfo.PluginInfoRule.PluginParameter param : ruleInfo.getParameters()) {
                plugin.setParameter(param.getName(), param.getValue());
            }
            ruleInfo.setPluginInstance(plugin);
            return plugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

