/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.listeners;

import com.cflint.listeners.ScanProgressListener;
import javax.swing.ProgressMonitor;

public class ProgressMonitorListener
implements ScanProgressListener {
    int fileCounter = 0;
    int totalFileCount = 1;
    final ProgressMonitor progressMonitor;
    boolean indeterminate = true;

    public ProgressMonitorListener(String progressLabel) {
        this.progressMonitor = new ProgressMonitor(null, progressLabel, "processing", 0, 1);
    }

    @Override
    public void startedProcessing(String srcidentifier) {
        if (this.progressMonitor.isCanceled()) {
            throw new RuntimeException("Cancelled by user");
        }
        if (this.indeterminate && this.fileCounter + 1 >= this.totalFileCount) {
            this.totalFileCount += 10;
            this.progressMonitor.setMaximum(this.totalFileCount);
        }
        this.progressMonitor.setProgress(this.fileCounter++);
        this.progressMonitor.setNote("[" + this.fileCounter + "/" + this.totalFileCount + "] processing " + this.shorten(srcidentifier));
    }

    private String shorten(String srcidentifier) {
        if (srcidentifier == null) {
            return "";
        }
        if (srcidentifier.length() < 80) {
            return srcidentifier;
        }
        return srcidentifier.substring(0, 78) + "..";
    }

    @Override
    public void finishedProcessing(String srcidentifier) {
    }

    public void setTotalToProcess(int total) {
        this.indeterminate = false;
        this.totalFileCount = total;
        this.progressMonitor.setMaximum(total);
    }

    @Override
    public void close() {
        this.progressMonitor.close();
    }
}

