/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.main;

import com.cflint.CFLint;
import com.cflint.HTMLOutput;
import com.cflint.TextOutput;
import com.cflint.Version;
import com.cflint.XMLOutput;
import com.cflint.config.CFLintConfig;
import com.cflint.config.ConfigUtils;
import com.cflint.tools.CFLintFilter;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CFLintMain {
    List<String> folder = new ArrayList<String>();
    String filterFile = null;
    boolean verbose = false;
    boolean logerror = false;
    boolean quiet = false;
    boolean xmlOutput = false;
    boolean htmlOutput = true;
    boolean textOutput = false;
    String xmlOutFile = "cflint-result.xml";
    String xmlstyle = "cflint";
    String htmlOutFile = "cflint-result.html";
    String htmlStyle = "plain.xsl";
    String textOutFile = null;
    String[] includeCodes = null;
    String[] excludeCodes = null;
    private String extensions;
    boolean showprogress = false;
    boolean progressUsesThread = true;
    private String configfile = null;

    public static void main(String[] args) throws ParseException, IOException, TransformerException, JAXBException {
        Options options = new Options();
        options.addOption("includeRule", true, "specify rules to include");
        options.addOption("excludeRule", true, "specify rules to exclude");
        options.addOption("folder", true, "folder(s) to scan");
        options.addOption("file", true, "file(s) to scan");
        options.addOption("filterFile", true, "filter file");
        options.addOption("v", false, "verbose");
        options.addOption("version", false, "show the version number");
        options.addOption("ui", false, "show UI");
        options.addOption("verbose", false, "verbose");
        options.addOption("showprogress", false, "show progress bar");
        options.addOption("singlethread", false, "show progress bar");
        options.addOption("logerror", false, "log parsing errors as bugs");
        options.addOption("e", false, "log parsing errors as bugs");
        options.addOption("q", false, "quiet");
        options.addOption("quiet", false, "quiet");
        options.addOption("h", false, "display this help");
        options.addOption("help", false, "display this help");
        options.addOption("xml", false, "output in xml format");
        options.addOption("xmlfile", true, "specify the output xml file (default: cflint-results.xml)");
        options.addOption("xmlstyle", true, "cflint,findbugs");
        options.addOption("html", false, "output in html format (default)");
        options.addOption("htmlfile", true, "specify the output html file (default: cflint-results.html)");
        options.addOption("htmlstyle", true, "default,plain");
        options.addOption("text", false, "output in plain text");
        options.addOption("textfile", true, "specify the output text file (default: cflint-results.txt)");
        options.addOption("extensions", true, "specify the extensions of the CF source files (default: .cfm,.cfc)");
        options.addOption("configfile", true, "specify the location of the config file");
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption('h') || cmd.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("cflint", options);
            return;
        }
        if (cmd.hasOption("version")) {
            System.out.println("CFLint " + Version.getVersion());
            return;
        }
        CFLintMain main = new CFLintMain();
        main.verbose = cmd.hasOption('v') || cmd.hasOption("verbose");
        main.quiet = cmd.hasOption('q') || cmd.hasOption("quiet");
        main.logerror = cmd.hasOption('e') || cmd.hasOption("logerror");
        main.xmlOutput = cmd.hasOption("xml") || cmd.hasOption("xmlstyle") || cmd.hasOption("xmlfile");
        boolean bl = main.textOutput = cmd.hasOption("text") || cmd.hasOption("textfile");
        if (cmd.hasOption("ui")) {
            main.ui();
        }
        if (main.xmlOutput || main.textOutput) {
            boolean bl2 = main.htmlOutput = cmd.hasOption("html") || cmd.hasOption("htmlstyle") || cmd.hasOption("htmlfile");
        }
        if (cmd.hasOption("folder")) {
            main.folder.addAll(Arrays.asList(cmd.getOptionValue("folder").split(",")));
        }
        if (cmd.hasOption("file")) {
            main.folder.addAll(Arrays.asList(cmd.getOptionValue("file").split(",")));
        }
        if (cmd.hasOption("htmlstyle")) {
            main.htmlStyle = cmd.getOptionValue("htmlstyle");
            if (!main.htmlStyle.endsWith(".xsl") && !main.htmlStyle.endsWith(".xslt")) {
                main.htmlStyle = main.htmlStyle + ".xsl";
            }
        }
        if (cmd.hasOption("xmlstyle")) {
            main.xmlstyle = cmd.getOptionValue("xmlstyle");
        }
        if (cmd.hasOption("filterFile")) {
            main.filterFile = cmd.getOptionValue("filterFile");
        }
        if (cmd.hasOption("xmlfile")) {
            main.xmlOutFile = cmd.getOptionValue("xmlfile");
        }
        if (cmd.hasOption("configfile")) {
            main.configfile = cmd.getOptionValue("configfile");
        }
        if (cmd.hasOption("htmlfile")) {
            main.htmlOutFile = cmd.getOptionValue("htmlfile");
        }
        if (cmd.hasOption("textfile")) {
            main.textOutFile = cmd.getOptionValue("textfile");
        }
        if (cmd.hasOption("extensions")) {
            main.extensions = cmd.getOptionValue("extensions");
        }
        if (cmd.hasOption("includeRule")) {
            main.includeCodes = cmd.getOptionValue("includeRule").split(",");
        }
        if (cmd.hasOption("excludeRule")) {
            main.excludeCodes = cmd.getOptionValue("excludeRule").split(",");
        }
        main.showprogress = cmd.hasOption("showprogress") || !cmd.hasOption("showprogress") && cmd.hasOption("ui");
        boolean bl3 = main.progressUsesThread = !cmd.hasOption("singlethread");
        if (main.isValid()) {
            main.execute();
            if (cmd.hasOption("ui")) {
                main.open();
            }
        } else {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("cflint", options);
        }
    }

    private void open() throws IOException {
        if (this.xmlOutput) {
            Desktop.getDesktop().open(new File(this.xmlOutFile));
            return;
        }
        if (this.textOutput && this.textOutFile != null) {
            Desktop.getDesktop().open(new File(this.textOutFile));
            return;
        }
        if (this.htmlOutput) {
            Desktop.getDesktop().open(new File(this.htmlOutFile));
            return;
        }
    }

    private void ui() {
        int[] indxs;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select target directory");
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        this.folder.add(chooser.getSelectedFile().getAbsolutePath());
        String[] slist = new String[]{"xml", "html", "text"};
        JList<String> list = new JList<String>(slist);
        JOptionPane.showMessageDialog(null, list, "Output Type", -1);
        for (int indx : indxs = list.getSelectedIndices()) {
            if (indx == 0) {
                this.xmlOutput = true;
            }
            if (indx == 1) {
                this.htmlOutput = true;
            }
            if (indx != 2) continue;
            this.textOutput = true;
        }
    }

    private void execute() throws IOException, TransformerException, JAXBException {
        Object ffile;
        CFLintConfig config = null;
        if (this.configfile != null) {
            config = ConfigUtils.unmarshal(new FileInputStream(this.configfile), CFLintConfig.class);
        }
        CFLint cflint = new CFLint(config);
        cflint.setVerbose(this.verbose);
        cflint.setLogError(this.logerror);
        cflint.setQuiet(this.quiet);
        cflint.setShowProgress(this.showprogress);
        cflint.setProgressUsesThread(this.progressUsesThread);
        if (this.extensions != null && this.extensions.trim().length() > 0) {
            try {
                cflint.setAllowedExtensions(Arrays.asList(this.extensions.trim().split(",")));
            }
            catch (Exception e) {
                System.out.println("Unable to use extensions (" + this.extensions + ") using default instead. " + e.getMessage());
            }
        }
        CFLintFilter filter = CFLintFilter.createFilter();
        if (this.filterFile != null && ((File)(ffile = new File(this.filterFile))).exists()) {
            FileInputStream fis = new FileInputStream((File)ffile);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            filter = CFLintFilter.createFilter(new String(b));
        }
        if (this.excludeCodes != null && this.excludeCodes.length > 0) {
            filter.excludeCode(this.excludeCodes);
        }
        if (this.includeCodes != null && this.includeCodes.length > 0) {
            filter.includeCode(this.includeCodes);
        }
        cflint.getBugs().setFilter(filter);
        for (String scanfolder : this.folder) {
            cflint.scan(scanfolder);
        }
        if (this.xmlOutput) {
            if (this.verbose) {
                System.out.println("Style:" + this.xmlstyle);
            }
            if ("findbugs".equalsIgnoreCase(this.xmlstyle)) {
                if (this.verbose) {
                    System.out.println("Writing findbugs style to " + this.xmlOutFile);
                }
                new XMLOutput().outputFindBugs(cflint.getBugs(), new FileWriter(this.xmlOutFile));
            } else {
                if (this.verbose) {
                    System.out.println("Writing " + this.xmlOutFile);
                }
                new XMLOutput().output(cflint.getBugs(), new FileWriter(this.xmlOutFile));
            }
        }
        if (this.textOutput) {
            if (this.textOutFile != null && this.verbose) {
                System.out.println("Writing " + this.textOutFile);
            }
            OutputStreamWriter textwriter = this.textOutFile != null ? new FileWriter(this.textOutFile) : new OutputStreamWriter(System.out);
            new TextOutput().output(cflint.getBugs(), textwriter);
        }
        if (this.htmlOutput) {
            try {
                if (this.verbose) {
                    System.out.println("Writing " + this.htmlOutFile);
                }
                new HTMLOutput(this.htmlStyle).output(cflint.getBugs(), new FileWriter(this.htmlOutFile));
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
        }
        if (this.includeCodes != null) {
            cflint.getBugs().getFilter().includeCode(this.includeCodes);
        }
        if (this.excludeCodes != null) {
            cflint.getBugs().getFilter().excludeCode(this.excludeCodes);
        }
    }

    private boolean isValid() {
        if (this.folder.isEmpty()) {
            System.err.println("Set -scanFolder");
            return false;
        }
        return true;
    }
}

