/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins;

import cfml.parsing.cfscript.CFIdentifier;
import com.cflint.StackHandler;
import java.util.ArrayList;
import java.util.List;
import net.htmlparser.jericho.Element;

public class Context {
    String filename;
    final Element element;
    String functionName;
    final boolean inAssignmentExpression;
    boolean inComponent;
    final StackHandler callStack;
    final List<ContextMessage> messages = new ArrayList<ContextMessage>();

    public Context(String filename, Element element, CFIdentifier functionName, boolean inAssignmentExpression, StackHandler handler) {
        this.filename = filename;
        this.element = element;
        this.functionName = functionName == null ? "" : functionName.Decompile(0);
        this.inAssignmentExpression = inAssignmentExpression;
        this.callStack = handler;
    }

    public Context(String filename, Element element, String functionName, boolean inAssignmentExpression, StackHandler handler) {
        this.filename = filename;
        this.element = element;
        this.functionName = functionName == null ? "" : functionName;
        this.inAssignmentExpression = inAssignmentExpression;
        this.callStack = handler;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Element getElement() {
        return this.element;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionIdentifier(CFIdentifier functionName) {
        this.functionName = functionName == null ? "" : functionName.Decompile(0);
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public boolean isInFunction() {
        return this.functionName != null && this.getFunctionName().length() > 0;
    }

    public boolean isInAssignmentExpression() {
        return this.inAssignmentExpression;
    }

    public StackHandler getCallStack() {
        return this.callStack;
    }

    public String fileFunctionString() {
        if (this.functionName == null && this.filename == null) {
            return null;
        }
        StringBuilder key = new StringBuilder();
        if (this.filename != null) {
            key.append(this.filename.trim());
        }
        key.append(":");
        if (this.functionName != null) {
            key.append(this.functionName);
        }
        return key.toString();
    }

    public boolean isInComponent() {
        return this.inComponent;
    }

    public void setInComponent(boolean inComponent) {
        this.inComponent = inComponent;
    }

    public List<ContextMessage> getMessages() {
        return this.messages;
    }

    public void addMessage(String messageCode, String variable) {
        this.messages.add(new ContextMessage(messageCode, variable));
    }

    public Context subContext(Element elem) {
        Context context2 = new Context(this.getFilename(), elem, this.getFunctionName(), this.isInAssignmentExpression(), this.callStack);
        context2.setInComponent(this.isInComponent());
        return context2;
    }

    public static class ContextMessage {
        String messageCode;
        String variable;

        public ContextMessage(String messageCode, String variable) {
            this.messageCode = messageCode;
            this.variable = variable;
        }

        public String getMessageCode() {
            return this.messageCode;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

