/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.script.CFFuncDeclStatement;
import cfml.parsing.cfscript.script.CFFunctionParameter;
import cfml.parsing.cfscript.script.CFScriptStatement;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import com.cflint.tools.CFTool;
import net.htmlparser.jericho.Element;

public class ArgDefChecker
extends CFLintScannerAdapter {
    @Override
    public void expression(CFScriptStatement expression, Context context, BugList bugs) {
        if (expression instanceof CFFuncDeclStatement) {
            CFFuncDeclStatement function = (CFFuncDeclStatement)expression;
            for (CFFunctionParameter argument : function.getFormals()) {
                String name = argument.getName();
                if (argument.toString().contains("required") || argument.toString().contains("=")) continue;
                function.getLine();
                function.getColumn();
                context.addMessage("ARG_DEFAULT_MISSING", name);
            }
        }
    }

    @Override
    public void element(Element element, Context context, BugList bugs) {
        if (element.getName().equals("cfargument")) {
            String name = element.getAttributeValue("name");
            boolean required = CFTool.toBoolean(element.getAttributeValue("required"));
            String defaultExpr = element.getAttributeValue("default");
            if (!required && defaultExpr == null) {
                element.getSource().getRow(element.getBegin());
                element.getSource().getColumn(element.getBegin());
                context.addMessage("ARG_DEFAULT_MISSING", name);
            }
        }
    }
}

