/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFFullVarExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.CFVarDeclExpression;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import java.util.HashSet;
import java.util.Set;

public class ArgVarChecker
extends CFLintScannerAdapter {
    Set<String> alreadyReported1 = new HashSet<String>();
    Set<String> alreadyReported2 = new HashSet<String>();

    @Override
    public void expression(CFExpression expression, Context context, BugList bugs) {
        if (expression instanceof CFVarDeclExpression) {
            String name = ((CFVarDeclExpression)expression).getName();
            if (context.isInFunction() && context.getCallStack().hasArgument(name)) {
                String fileKey = context.fileFunctionString();
                if (this.alreadyReported1.contains(fileKey)) {
                    return;
                }
                this.alreadyReported1.add(fileKey);
                context.addMessage("ARG_VAR_CONFLICT", name);
            }
        } else if (expression instanceof CFFullVarExpression) {
            CFIdentifier cfIdentifier1;
            CFFullVarExpression fullVarExpr = (CFFullVarExpression)expression;
            if (fullVarExpr.getExpressions().size() > 1 && fullVarExpr.getExpressions().get(0) instanceof CFIdentifier && (cfIdentifier1 = (CFIdentifier)fullVarExpr.getExpressions().get(0)).getName().equalsIgnoreCase("arguments") && fullVarExpr.getExpressions().get(1) instanceof CFIdentifier) {
                CFIdentifier cfIdentifier2 = (CFIdentifier)fullVarExpr.getExpressions().get(1);
                String name = cfIdentifier2.getName();
                if (context.getCallStack().isVariable(name)) {
                    String fileKey = context.fileFunctionString();
                    if (this.alreadyReported2.contains(fileKey)) {
                        return;
                    }
                    this.alreadyReported2.add(fileKey);
                    context.addMessage("ARG_VAR_MIXED", name);
                }
            }
            this.expression((CFExpression)fullVarExpr.getExpressions().get(0), context, bugs);
        }
    }
}

