/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import com.cflint.BugInfo;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import net.htmlparser.jericho.Element;
import ro.fortsoft.pf4j.Extension;

@Extension
public class CFQueryChecker
extends CFLintScannerAdapter {
    final String message = "Don't use <cfquery> in .cfm files. Database should not be coupled with view";
    final String severity = "ERROR";
    final String messageCode = "NEVER_USE_QUERY_IN_CFM";

    @Override
    public void expression(CFExpression expression, Context context, BugList bugs) {
    }

    @Override
    public void expression(CFScriptStatement expression, Context context, BugList bugs) {
    }

    @Override
    public void element(Element element, Context context, BugList bugs) {
        String file = context.getFilename();
        String ext = file.substring(file.length() - 3, file.length());
        String tagName = element.getName();
        if (tagName.equals("cfquery") && ext.equals("cfm")) {
            int begLine = element.getSource().getRow(element.getBegin());
            bugs.add(new BugInfo.BugInfoBuilder().setLine(begLine).setMessageCode("NEVER_USE_QUERY_IN_CFM").setSeverity("ERROR").setFilename(context.getFilename()).setMessage("Don't use <cfquery> in .cfm files. Database should not be coupled with view").build());
        }
    }
}

